/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.hunterbot;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.NavigationState;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UT2004ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Rotate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

@AgentScoped
public class HunterBot
extends UT2004BotModuleController<UT2004Bot> {
    @JProp
    public boolean shouldEngage = true;
    @JProp
    public boolean shouldPursue = true;
    @JProp
    public boolean shouldRearm = true;
    @JProp
    public boolean shouldCollectHealth = true;
    @JProp
    public int healthLevel = 75;
    @JProp
    public int frags = 0;
    @JProp
    public int deaths = 0;
    protected Player enemy = null;
    protected Item item = null;
    protected TabooSet<Item> tabooItems = null;
    private UT2004PathAutoFixer autoFixer;
    private static int instanceCount = 0;
    protected boolean runningToPlayer = false;
    protected int pursueCount = 0;
    protected List<Item> itemsToRunAround = null;

    @EventListener(eventClass=PlayerKilled.class)
    public void playerKilled(PlayerKilled event) {
        if (event.getKiller().equals((Object)this.info.getId())) {
            ++this.frags;
        }
        if (this.enemy == null) {
            return;
        }
        if (this.enemy.getId().equals((Object)event.getId())) {
            this.enemy = null;
        }
    }

    public void prepareBot(UT2004Bot bot) {
        this.tabooItems = new TabooSet(bot);
        this.autoFixer = new UT2004PathAutoFixer(bot, this.navigation.getPathExecutor(), this.fwMap, this.aStar, this.navBuilder);
        this.navigation.getState().addListener((FlagListener)new FlagListener<NavigationState>(){

            public void flagChanged(NavigationState changedValue) {
                switch (changedValue) {
                    case PATH_COMPUTATION_FAILED: 
                    case STUCK: {
                        if (HunterBot.this.item != null) {
                            HunterBot.this.tabooItems.add((Object)HunterBot.this.item, 10.0);
                        }
                        HunterBot.this.reset();
                        break;
                    }
                    case TARGET_REACHED: {
                        HunterBot.this.reset();
                    }
                }
            }
        });
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.LIGHTNING_GUN, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.SHOCK_RIFLE, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.MINIGUN, false);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.FLAK_CANNON, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.ROCKET_LAUNCHER, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.LINK_GUN, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.ASSAULT_RIFLE, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.BIO_RIFLE, true);
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName("Hunter-" + ++instanceCount).setDesiredSkill(Integer.valueOf(5));
    }

    protected void reset() {
        this.item = null;
        this.enemy = null;
        this.navigation.stopNavigation();
        this.itemsToRunAround = null;
    }

    @EventListener(eventClass=PlayerDamaged.class)
    public void playerDamaged(PlayerDamaged event) {
        this.log.info("I have just hurt other bot for: " + event.getDamageType() + "[" + event.getDamage() + "]");
    }

    @EventListener(eventClass=BotDamaged.class)
    public void botDamaged(BotDamaged event) {
        this.log.info("I have just been hurt by other bot for: " + event.getDamageType() + "[" + event.getDamage() + "]");
    }

    public void logic() {
        if (this.shouldEngage && this.players.canSeeEnemies() && this.weaponry.hasLoadedWeapon()) {
            this.stateEngage();
            return;
        }
        if (this.info.isShooting().booleanValue() || this.info.isSecondaryShooting().booleanValue()) {
            this.getAct().act((CommandMessage)new StopShooting());
        }
        if (this.senses.isBeingDamaged()) {
            this.stateHit();
            return;
        }
        if (this.enemy != null && this.shouldPursue && this.weaponry.hasLoadedWeapon()) {
            this.statePursue();
            return;
        }
        if (this.shouldCollectHealth && this.info.getHealth() < this.healthLevel) {
            this.stateMedKit();
            return;
        }
        this.stateRunAroundItems();
    }

    protected void stateEngage() {
        boolean shooting = false;
        double distance = Double.MAX_VALUE;
        this.pursueCount = 0;
        if (this.enemy == null || !this.enemy.isVisible()) {
            this.enemy = this.players.getNearestVisiblePlayer(this.players.getVisibleEnemies().values());
            if (this.enemy == null) {
                this.log.info("Can't see any enemies... ???");
                return;
            }
        }
        if (!this.enemy.isVisible()) {
            if (this.info.isShooting().booleanValue() || this.info.isSecondaryShooting().booleanValue()) {
                this.getAct().act((CommandMessage)new StopShooting());
            }
            this.runningToPlayer = false;
        } else {
            distance = this.info.getLocation().getDistance(this.enemy.getLocation());
            if (this.shoot.shoot(this.weaponPrefs, (ILocated)this.enemy, new ItemType[0]) != null) {
                this.log.info("Shooting at enemy!!!");
                shooting = true;
            }
        }
        int decentDistance = Math.round(this.random.nextFloat() * 800.0f) + 200;
        if (!this.enemy.isVisible() || !shooting || (double)decentDistance < distance) {
            if (!this.runningToPlayer) {
                this.navigation.navigate(this.enemy);
                this.runningToPlayer = true;
            }
        } else {
            this.runningToPlayer = false;
            this.navigation.stopNavigation();
        }
        this.item = null;
    }

    protected void stateHit() {
        this.bot.getBotName().setInfo("HIT");
        if (this.navigation.isNavigating()) {
            this.navigation.stopNavigation();
            this.item = null;
        }
        this.getAct().act((CommandMessage)new Rotate().setAmount(Integer.valueOf(32000)));
    }

    protected void statePursue() {
        ++this.pursueCount;
        if (this.pursueCount > 30) {
            this.reset();
        }
        if (this.enemy != null) {
            this.bot.getBotName().setInfo("PURSUE");
            this.navigation.navigate(this.enemy);
            this.item = null;
        } else {
            this.reset();
        }
    }

    protected void stateMedKit() {
        Item item = this.items.getPathNearestSpawnedItem(ItemType.Category.HEALTH);
        if (item == null) {
            this.log.warning("NO HEALTH ITEM TO RUN TO => ITEMS");
            this.stateRunAroundItems();
        } else {
            this.bot.getBotName().setInfo("MEDKIT");
            this.navigation.navigate((ILocated)item);
            this.item = item;
        }
    }

    protected void stateRunAroundItems() {
        Item item;
        if (this.navigation.isNavigatingToItem()) {
            return;
        }
        ArrayList interesting = new ArrayList();
        for (ItemType itemType : ItemType.Category.WEAPON.getTypes()) {
            if (this.weaponry.hasLoadedWeapon(itemType)) continue;
            interesting.addAll(this.items.getSpawnedItems(itemType).values());
        }
        for (ItemType itemType : ItemType.Category.ARMOR.getTypes()) {
            interesting.addAll(this.items.getSpawnedItems(itemType).values());
        }
        interesting.addAll(this.items.getSpawnedItems((ItemType)UT2004ItemType.U_DAMAGE_PACK).values());
        if (this.info.getHealth() < 100) {
            interesting.addAll(this.items.getSpawnedItems((ItemType)UT2004ItemType.HEALTH_PACK).values());
        }
        if ((item = (Item)MyCollections.getRandom((Collection)this.tabooItems.filter(interesting))) == null) {
            this.log.warning("NO ITEM TO RUN FOR!");
            if (this.navigation.isNavigating()) {
                return;
            }
            this.bot.getBotName().setInfo("RANDOM NAV");
            this.navigation.navigate((ILocated)this.navPoints.getRandomNavPoint());
        } else {
            this.item = item;
            this.log.info("RUNNING FOR: " + item.getType().getName());
            this.bot.getBotName().setInfo("ITEM: " + item.getType().getName() + "");
            this.navigation.navigate((ILocated)item);
        }
    }

    public void botKilled(BotKilled event) {
        this.reset();
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(HunterBot.class, "Hunter").setMain(true).setLogLevel(Level.INFO).startAgents(2);
    }
}

