/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.responsivebot;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Bumped;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;

@AgentScoped
public class ResponsiveBot
extends UT2004BotModuleController {
    protected boolean wasCloseBefore = false;
    IWorldEventListener<BotDamaged> botDamagedListener = new IWorldEventListener<BotDamaged>(){

        public void notify(BotDamaged event) {
            NavPoint secondNav = (NavPoint)DistanceUtils.getSecondNearest(ResponsiveBot.this.getWorldView().getAll(NavPoint.class).values(), (ILocated)ResponsiveBot.this.info.getLocation());
            if (secondNav == null) {
                ResponsiveBot.this.move.turnVertical(30);
            } else {
                ResponsiveBot.this.move.moveTo((ILocated)secondNav);
            }
        }
    };

    @EventListener(eventClass=Bumped.class)
    protected void bumped(Bumped event) {
        Location v = event.getLocation().sub(this.bot.getLocation()).scale(5.0);
        Location target = this.bot.getLocation().sub(v);
        this.move.strafeTo((ILocated)target, (ILocated)event.getLocation());
    }

    @ObjectClassEventListener(eventClass=WorldObjectAppearedEvent.class, objectClass=Player.class)
    protected void playerAppeared(WorldObjectAppearedEvent<Player> event) {
        this.body.getCommunication().sendGlobalTextMessage("Hello " + ((Player)event.getObject()).getName() + "!");
    }

    @ObjectClassEventListener(eventClass=WorldObjectUpdatedEvent.class, objectClass=Player.class)
    protected void playerUpdated(WorldObjectUpdatedEvent<Player> event) {
        Player player = (Player)event.getObject();
        if (player.getLocation() == null || this.info.getLocation() == null) {
            return;
        }
        if (player.getLocation().getDistance(this.info.getLocation()) < 250.0) {
            if (!this.wasCloseBefore) {
                this.body.getCommunication().sendGlobalTextMessage("What do you want " + player.getName() + "?");
                this.wasCloseBefore = true;
            }
        } else {
            this.wasCloseBefore = false;
        }
    }

    @ObjectListener(idClass=UnrealId.class, objectId="GameInfoId")
    public void gameInfo1(IWorldObjectEvent<GameInfo> gameInfoEvent) {
        this.log.warning("GAME INFO EVENT =1=: " + gameInfoEvent);
    }

    @ObjectEventListener(idClass=UnrealId.class, objectId="GameInfoId", eventClass=WorldObjectUpdatedEvent.class)
    public void gameInfo2(WorldObjectUpdatedEvent<GameInfo> gameInfoEvent) {
        this.log.warning("GAME INFO EVENT =2=: " + gameInfoEvent);
    }

    @ObjectClassListener(objectClass=Player.class)
    public void playerEvent(IWorldObjectEvent<Player> playerEvent) {
        this.log.warning("PLAYER EVENT: " + playerEvent);
    }

    public void prepareBot(UT2004Bot bot) {
        this.getWorldView().addEventListener(BotDamaged.class, this.botDamagedListener);
    }

    public Initialize getInitializeCommand() {
        return new Initialize();
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.body.getCommunication().sendGlobalTextMessage("I am alive!");
    }

    public void beforeFirstLogic() {
    }

    public void logic() throws PogamutException {
    }

    public void botKilled(BotKilled event) {
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(ResponsiveBot.class, "ResponsiveBot").setMain(true).startAgent();
    }
}

