package cz.cuni.amis.pogamut.ut2004.examples.sposhpraybot;

import java.util.Collection;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.sposh.UT2004Behaviour;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

/**
 * Behaviour definition for prey bot.
 * 
 * @author Honza
 */
public class PreyBehaviour extends UT2004Behaviour<UT2004Bot> {	
	
    public PreyBehaviour(String name, UT2004Bot bot) {
        super(name, bot);
        // IMPORTANT: modules won't work without call of this method.
        initializeBehaviour(bot);
    }

    @Override
    protected void prepareBehaviour(UT2004Bot bot) {
    	// initialize your custom data structures here
    }
    
    @Override
    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
        // TODO called after the bot was initialized
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        // TODO bot is spawned for the first time in the environment
        // examine 'self' to examine current bot's location and other stuff, initialize things 
    	// dependent on that
    }
    
    @Override
	public void botKilled(BotKilled event) {
    	// TODO bot was killed, clean up your data structures
	}
    
    /*
     * hitWall sense, used when bot bumps into wall due to
     * errors in pathfinding (like railing)
     */
    @SPOSHSense
    public boolean hitWall() {
        //return senses.isColliding(); TODO: Implement senses
        return false;
    }

    /**
     * Get health of bot
     * @return how many points of health does bot have
     */
    @SPOSHSense
    public int health() {
        int health = info.getHealth();
        user.info("Health is " + health);
        return info.getHealth();
    }

    private int currentVialIndex=0;

    /**
     * Run from one health vial to another using list of health vials. 
     * No intelligence involved, doesn't matter if they are spawned or far away.
     * @return
     */
    @SPOSHAction
    public boolean runMedkits() {
        if (pathExecutor.isExecuting()) {
            return true;
        }
        
        if (!pathExecutor.isExecuting()) {
            Item[] healthVials = items.getKnownPickups(ItemType.MINI_HEALTH_PACK).values().toArray(new Item[]{});
            if (healthVials.length == 0) {
            	user.severe("There is no health item to run to!");
            	return false;
            }
            pathExecutor.followPath(pathPlanner.computePath(bot, healthVials[currentVialIndex % healthVials.length].getLocation()));
            currentVialIndex++;
        }
        return true;
    }

    /**
     * Get closest item (in euclidian metric) from the reference point.
     * @param reference center, from which is the distance measured
     * @param items list of items
     * @return closest item or null if no such thing exists.
     */
    private Item getClosestItem(Location reference, Collection<Item> items) {
        Item closestItem = null;
        double closestDistance = Double.MAX_VALUE;

        for (Item item : items) {
            double distance = Location.getDistance(reference, item.getLocation());
            if (distance < closestDistance) {
                closestDistance = distance;
                closestItem = item;
            }
        }
        return closestItem;
    }

    @SPOSHAction
    public boolean jump() {
        move.jump();
        return true;
    }
}
