/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.hunterbot;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionHistoryStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Rotate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

@AgentScoped
public class HunterBot
extends UT2004BotModuleController<UT2004Bot> {
    @JProp
    public boolean shouldEngage = true;
    @JProp
    public boolean shouldPursue = true;
    @JProp
    public boolean shouldRearm = true;
    @JProp
    public boolean shouldCollectItems = true;
    @JProp
    public boolean shouldCollectHealth = true;
    @JProp
    public int healthLevel = 90;
    @JProp
    public int frags = 0;
    @JProp
    public int deaths = 0;
    protected Player enemy = null;
    protected TabooSet<Item> tabooItems = null;
    protected State previousState = State.OTHER;
    protected int notMoving = 0;
    protected boolean runningToPlayer = false;
    protected int pursueCount = 0;
    protected Item item = null;
    protected List<Item> itemsToRunAround = null;

    @EventListener(eventClass=PlayerKilled.class)
    public void playerKilled(PlayerKilled event) {
        if (event.getKiller().equals((Object)this.info.getId())) {
            ++this.frags;
        }
        if (this.enemy == null) {
            return;
        }
        if (this.enemy.getId().equals((Object)event.getId())) {
            this.previousState = State.OTHER;
            this.enemy = null;
        }
    }

    public void prepareBot(UT2004Bot bot) {
        this.tabooItems = new TabooSet(bot);
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(bot, 3.0, 10.0));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionHistoryStuckDetector(bot));
        this.pathExecutor.getState().addListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                switch (changedValue.getState()) {
                    case STUCK: {
                        if (HunterBot.this.item != null) {
                            HunterBot.this.tabooItems.add((Object)HunterBot.this.item, 10.0);
                        }
                        HunterBot.this.reset();
                        break;
                    }
                    case TARGET_REACHED: {
                        HunterBot.this.reset();
                    }
                }
            }
        });
        this.weaponPrefs.addGeneralPref(ItemType.MINIGUN, false);
        this.weaponPrefs.addGeneralPref(ItemType.MINIGUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.LINK_GUN, false);
        this.weaponPrefs.addGeneralPref(ItemType.LIGHTNING_GUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.SHOCK_RIFLE, true);
        this.weaponPrefs.addGeneralPref(ItemType.ROCKET_LAUNCHER, true);
        this.weaponPrefs.addGeneralPref(ItemType.LINK_GUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.ASSAULT_RIFLE, true);
        this.weaponPrefs.addGeneralPref(ItemType.FLAK_CANNON, false);
        this.weaponPrefs.addGeneralPref(ItemType.FLAK_CANNON, true);
        this.weaponPrefs.addGeneralPref(ItemType.BIO_RIFLE, true);
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName("Hunter").setDesiredSkill(Integer.valueOf(5));
    }

    protected void reset() {
        this.previousState = State.OTHER;
        this.notMoving = 0;
        this.enemy = null;
        this.pathExecutor.stop();
        this.itemsToRunAround = null;
        this.item = null;
    }

    public void logic() {
        if (!this.info.isMoving().booleanValue()) {
            ++this.notMoving;
            if (this.notMoving > 4) {
                this.reset();
                return;
            }
        }
        if (this.shouldEngage && this.players.canSeeEnemies() && this.weaponry.hasLoadedWeapon()) {
            this.stateEngage();
            return;
        }
        if (this.info.isShooting().booleanValue() || this.info.isSecondaryShooting().booleanValue()) {
            this.getAct().act((CommandMessage)new StopShooting());
        }
        if (this.senses.isBeingDamaged()) {
            this.stateHit();
            return;
        }
        if (this.enemy != null && this.shouldPursue && this.weaponry.hasLoadedWeapon()) {
            this.statePursue();
            return;
        }
        if (this.info.getHealth() < this.healthLevel && this.canRunAlongMedKit()) {
            this.stateMedKit();
            return;
        }
        if (this.shouldCollectItems && !this.items.getVisibleItems().isEmpty()) {
            this.stateSeeItem();
            this.previousState = State.GRAB;
            return;
        }
        this.stateRunAroundItems();
    }

    protected void stateEngage() {
        this.log.info("Decision is: ENGAGE");
        this.config.setName("Hunter [ENGAGE]");
        boolean shooting = false;
        double distance = Double.MAX_VALUE;
        if (this.previousState != State.ENGAGE || this.enemy == null || !this.enemy.isVisible()) {
            this.enemy = this.players.getNearestVisiblePlayer(this.players.getVisibleEnemies().values());
            if (this.enemy == null) {
                this.log.info("Can't see any enemies... ???");
                return;
            }
            if (this.info.isShooting().booleanValue()) {
                this.getAct().act((CommandMessage)new StopShooting());
            }
            this.runningToPlayer = false;
        }
        if (this.enemy != null) {
            distance = this.info.getLocation().getDistance(this.enemy.getLocation());
            if (this.shoot.shoot(this.weaponPrefs, (ILocated)this.enemy, new ItemType[0]) != null) {
                this.log.info("Shooting at enemy!!!");
                shooting = true;
            }
        }
        int decentDistance = Math.round(this.random.nextFloat() * 800.0f) + 200;
        if (!this.enemy.isVisible() || !shooting || (double)decentDistance < distance) {
            if (!this.runningToPlayer) {
                this.pathExecutor.followPath(this.pathPlanner.computePath((Object)this.bot, (Object)this.enemy));
                this.runningToPlayer = true;
            }
        } else {
            this.runningToPlayer = false;
            this.pathExecutor.stop();
            this.getAct().act((CommandMessage)new Stop());
        }
        this.previousState = State.ENGAGE;
    }

    protected void stateHit() {
        this.log.info("Decision is: HIT");
        this.getAct().act((CommandMessage)new Rotate().setAmount(Integer.valueOf(32000)));
        this.previousState = State.OTHER;
    }

    protected void statePursue() {
        this.log.info("Decision is: PURSUE");
        this.config.setName("Hunter [PURSUE]");
        if (this.previousState != State.PURSUE) {
            this.pursueCount = 0;
            this.pathExecutor.followPath(this.pathPlanner.computePath((Object)this.bot, (Object)this.enemy));
        }
        ++this.pursueCount;
        if (this.pursueCount > 30) {
            this.reset();
        } else {
            this.previousState = State.PURSUE;
        }
    }

    protected void stateMedKit() {
        this.log.info("Decision is: MEDKIT");
        this.config.setName("Hunter [MEDKIT]");
        if (this.previousState != State.MEDKIT) {
            Set okHealths;
            LinkedList healths = new LinkedList();
            healths.addAll(this.items.getSpawnedItems(ItemType.HEALTH_PACK).values());
            if (healths.size() == 0) {
                healths.addAll(this.items.getSpawnedItems(ItemType.MINI_HEALTH_PACK).values());
            }
            if ((okHealths = this.tabooItems.filter(healths)).size() == 0) {
                this.log.log(Level.WARNING, "No suitable health to run for.");
                this.stateRunAroundItems();
                return;
            }
            this.item = (Item)DistanceUtils.getNearest((Collection)okHealths, (ILocated)this.info.getLocation());
            this.pathExecutor.followPath(this.pathPlanner.computePath((Object)this.bot, (Object)this.item));
        }
        this.previousState = State.MEDKIT;
    }

    protected void stateSeeItem() {
        this.log.info("Decision is: SEE ITEM");
        this.config.setName("Hunter [SEE ITEM]");
        if (this.item != null && this.item.getLocation().getDistance(this.info.getLocation()) < 100.0) {
            this.reset();
        }
        if (this.previousState != State.GRAB) {
            this.item = (Item)DistanceUtils.getNearest(this.items.getVisibleItems().values(), (ILocated)this.info.getLocation());
            if (this.item.getLocation().getDistance(this.info.getLocation()) < 300.0) {
                this.getAct().act((CommandMessage)new Move().setFirstLocation(this.item.getLocation()));
            } else {
                this.pathExecutor.followPath(this.pathPlanner.computePath((Object)this.bot, (Object)this.item));
            }
        }
    }

    protected boolean canRunAlongMedKit() {
        boolean result = !this.items.getSpawnedItems(ItemType.HEALTH_PACK).isEmpty() || !this.items.getSpawnedItems(ItemType.MINI_HEALTH_PACK).isEmpty();
        return result;
    }

    protected void stateRunAroundItems() {
        this.log.info("Decision is: ITEMS");
        this.config.setName("Hunter [ITEMS]");
        if (this.previousState != State.ITEMS) {
            this.itemsToRunAround = new LinkedList(this.items.getSpawnedItems().values());
            Set items = this.tabooItems.filter(this.itemsToRunAround);
            if (items.size() == 0) {
                this.log.log(Level.WARNING, "No item to run for...");
                this.reset();
                return;
            }
            this.item = (Item)items.iterator().next();
            this.pathExecutor.followPath(this.pathPlanner.computePath((Object)this.bot, (Object)this.item));
        }
        this.previousState = State.ITEMS;
    }

    public void botKilled(BotKilled event) {
        this.itemsToRunAround = null;
        this.enemy = null;
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(HunterBot.class, "Hunter").setMain(true).startAgents(3);
    }

    protected static enum State {
        OTHER,
        ENGAGE,
        PURSUE,
        MEDKIT,
        GRAB,
        ITEMS;

    }
}

