/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.context;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.sposh.context.Context;
import cz.cuni.amis.pogamut.sposh.context.IUSAR2004Context;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.StateMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.state.SuperState;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class USAR2004Context<BOT extends USAR2004Bot>
extends Context<BOT>
implements IUSAR2004Context<BOT> {
    protected Random random = new Random(System.currentTimeMillis());
    protected LogCategory log = null;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected IWorldView world;
    protected IAct act;
    protected StateMasterModule stateModule;

    public USAR2004Context(String name, BOT bot) {
        super(name, bot);
        this.log = bot.getLogger().getCategory("User");
        this.log.setLevel(Level.ALL);
    }

    protected void initialize() {
        this.initializeModules((USAR2004Bot)this.bot);
        this.initializeListeners((USAR2004Bot)this.bot);
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, this.getWorldView(), (Logger)bot.getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializeModules(BOT bot) {
        this.world = this.getWorldView();
        this.act = this.getAct();
        this.stateModule = StateMasterModule.getModuleInstance(bot);
        System.out.println("initModules-from init");
    }

    protected void prepareBehaviour(BOT bot) {
        System.out.println("prepareBeh");
    }

    @Override
    public void finishInitialization() {
        System.out.println("finishInit");
    }

    public void logicIteration() {
        System.out.println("logicIter");
    }

    public StateMasterModule getStateModule() {
        return this.stateModule;
    }

    public int getBatteryLeft() {
        if (!this.stateModule.isReady().booleanValue()) {
            return -1;
        }
        List states = this.stateModule.getStatesByClass(SuperState.class);
        return ((SuperState)states.get(0)).getBattery();
    }

    public double getTime() {
        if (!this.stateModule.isReady().booleanValue()) {
            return -1.0;
        }
        List states = this.stateModule.getStatesByClass(SuperState.class);
        return ((SuperState)states.get(0)).getTime();
    }

    public IWorldView getWorldView() {
        return ((USAR2004Bot)this.bot).getWorldView();
    }

    public IAct getAct() {
        return ((USAR2004Bot)this.bot).getAct();
    }

    public Random getRandom() {
        return this.random;
    }

    public LogCategory getLog() {
        return this.log;
    }

    public AnnotationListenerRegistrator getListenerRegistrator() {
        return this.listenerRegistrator;
    }

    public IWorldView getWorld() {
        return this.world;
    }
}

