package cz.cuni.amis.pogamut.usar2004.examples.aiboersrobot;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.usar2004.agent.*;
import cz.cuni.amis.pogamut.usar2004.agent.module.logic.USAR2004BotLogicController;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.*;
import cz.cuni.amis.pogamut.usar2004.agent.module.nfo.NfoStartPoses;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorHelper;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.TraceColor;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.utils.*;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;


/**
 * Let this website guide You through further usage of this robot:
 * http://digilander.libero.it/windflow/index.htm This sample is Intended for
 * the DM-spqrSoccer2006_250 map.
 *
 * @author vejmanm
 */
@AgentScoped
public class AiboERSRobot extends USAR2004BotLogicController<USAR2004Bot>
{
    /**
     * Method triggered after Game is initialized and STARTPOSES obtained. Tt
     * will spawn the robot into the environment.
     *
     * @param nfom NfoMessge containing STARTPOSES
     */
    @Override
    public void robotInitialized(NfoMessage nfom)
    {
        super.robotInitialized(nfom);
        logicInitialize(logicModule);
//        getAct().act(new GetStartPoses());
        //initModule = new InitializeOnceOnStartPoses(bot, "USARBot.ERS", "ERS - legged sample robot");
        bot.getAct().act(new Initialize("USARBot.ERS", "ERS - legged sample robot", "PlayerStart", "RED", null));//"UnitLoader1", "RED", null));//
        bot.getAct().act(new Trace(true, 2, TraceColor.YELLOW));
        System.out.println(logicModule.isRunning());
    }

    @Override
    public void initializeController(USAR2004Bot bot)
    {
        super.initializeController(bot);


        //startPoses = new NfoStartPoses(bot);
        //begin = new NfoBeginMapInfo(bot);
    }
    private final double descendingLatch = 0.05f;//how fast should it drop the level while descending
    private final double descendingRate = 0.5f;//how much severly should it correct the level by steering the sternPlane
    private final double steerRate = 0.4f;//how much should it steer
    private final int submarineLevel = 4;//how far from the bottom of the sea should it try to keep the sub.
    //properties needed for logic run:
    private boolean parametersObtained = false;
    private double maxRudderAngle = 0;
    private double maxSternPlaneAngle = 0;
    private double maxPropellerSpeed = 0;
    private double cameraMaxFov = 0;
    private double cameraMinFov = 0;
    private double cameraActFov = 0;
    private double cameraInc = 0.01f;
    private String cameraName = "";
    private String cameraType = "";
    private double laserRange = 0;
    private double laserTime = 0;
    private double previousLaserRange = 0;
    private double previousLaserTime = 0;
    private double cameraRotationSpeed = 0;
    private double cameraTilt = 0;
    private double cameraTiltInc = cameraInc;
    private double cameraMaxTilt = 0;
    private double cameraMinTilt = 0;
    private String mispkgName = "";
    private double time = 0;
    //works till the battery is dead

    /**
     * this method is triggered by receipt of STA message. This is where all
     * behaviour is controlled
     *
     * @throws PogamutException
     */
    @Override
    public void logic() throws PogamutException
    {
        super.logic();

        if(!helperSensor.isReady())
        {
            return;
        }
//        if(!parametersObtained)
//        {
//            getConfig();
//            return;
//        }
//        else
//        {
//            //zoomCamera();
//            //rotateCamera();
//        }
        //run();
        //walk();

        if(helperSensor.getModule().isVisible())
        {
            turnHead(helperSensor.getModule().getPos2D().y);
        }
        else
        {
            headTilt = 0;//straighten head
            turnHead(0);
        }

        if(helperSensor.getModule().getPos2D().x > 100)
        {
            turn(0);
        }
        else
        {
            turn(1);
        }
    }
    private double headTilt = 0;

    /**
     * Turns head a bit down if value is less than 100 and moves it a bit up
     * when the value is greater.
     *
     * @param value
     */
    private void turnHead(double value)
    {
        if(value < 100)
        {
            headTilt += 0.05f;
        }
        else
        {
            headTilt -= 0.05f;
        }
        bot.getAct().act(new Multidrive("HA", String.valueOf(headTilt)));
    }
    private int runCount = 0;

    /**
     * Unused method to make the robot run.
     */
    private void run()
    {
        runCount++;
        String[] names;
        String[] values;

        //noha když se hejbe směrem dopředu, tak je ohnutá v koleni.

        switch(runCount)
        {
            case 1:
                names = new String[]
                {
                    "LRA", "LRB", "LRC", "RRA", "RRB", "RRC", "LFA", "LFB", "LFC", "RFA", "RFB", "RFC"
                };
                values = new String[]
                {
                    "0.1", "0.1", "0.5", "0.1", "0.1", "0.5", "0.1", "0.1", "0.4", "0.1", "0.1", "0.4"
                };
                break;
            case 2:
                names = new String[]
                {
                    "LRA", "LRB", "LRC", "RRA", "RRB", "RRC", "LFA", "LFB", "LFC", "RFA", "RFB", "RFC"
                };
                values = new String[]
                {
                    "-0.2", "0.3", "-0.6", "-0.2", "0.3", "-0.6", "-0.4", "0.2", "-0.3", "-0.4", "0.2", "-0.3"
                };
                break;

            default:
                names = new String[]
                {
                    "LFA"
                };
                values = new String[]
                {
                    "0"
                };
                break;
        }
        bot.getAct().act(new Multidrive(names, values));
        if(runCount > 1)
        {
            runCount = 0;
        }
    }
    private int turnCount = 0;

    /**
     * The robot walks in circles according to direction on the input.
     *
     * @param dir 1= walk left; 0 = walk right; otherwise go forward
     */
    private void turn(int dir)
    {
        String[] lv = new String[]
        {
            "-0.1", "0.1", "-0.3", "-0.6"
        };
        String[] rv = new String[]
        {
            "0.1", "-0.1", "-0.6", "-0.3"
        };
        String[] sv = new String[]
        {
            "-0.1", "-0.1", "-0.3", "-0.3"
        };
        String[] av;
        if(dir == 0)
        {
            av = lv;//turn right
        }
        else if(dir == 1)
        {
            av = rv;//turn left
        }
        else
        {
            av = sv;//go forward
        }
        turnCount++;
        String[] names;
        String[] values;

        switch(turnCount)
        {
            case 2:
            case 1:
                names = new String[]
                {
                    "LRA", "LRB", "LRC", "RFA", "RFB", "RFC", "RRB"
                };
                values = new String[]
                {
                    "0.1", av[0], "0.5", "-0.4", "0.2", av[3], "-0.1"
                };
                break;
            case 6:
            case 5:
                names = new String[]
                {
                    "LFA", "LFB", "LFC", "RRA", "RRB", "RRC", "LRB"
                };
                values = new String[]
                {
                    "-0.4", "0.2", av[2], "0.1", av[1], "0.5", "-0.1"
                };
                break;
            case 4:
            case 3:
                names = new String[]
                {
                    "LRA", "LRB", "LRC", "RFA", "RFB", "RFC", "LFA", "LFB", "LFC"
                };
                values = new String[]
                {
                    "-0.2", "0.3", "-0.6", "0.1", "0.1", "0.4", "0", "0", "0"
                };
                break;
            case 8:
            case 7:
                names = new String[]
                {
                    "LFA", "LFB", "LFC", "RRA", "RRB", "RRC", "RFA", "RFB", "RFC"
                };
                values = new String[]
                {
                    "0.1", "0.1", "0.4", "-0.2", "0.3", "-0.6", "0", "0", "0"
                };
                break;

            default:
                names = new String[]
                {
                    "LFA"
                };
                values = new String[]
                {
                    "0"
                };
                break;
        }
        bot.getAct().act(new Multidrive(names, values));
        if(turnCount > 7)
        {
            turnCount = 0;
        }
    }
    private int walkCount = 0;

    /**
     * Unused method to make the robot walk.
     */
    private void walk()
    {
        walkCount++;
        String[] names;
        String[] values;

        //TODO: noha když se hejbe směrem dopředu, tak je ohnutá v koleni.

        switch(walkCount)
        {
            case 2:
            case 1:
                names = new String[]
                {
                    "LRA", "LRB", "LRC", "RFA", "RFB", "RFC", "RRB"
                };
                values = new String[]
                {
                    "0.1", "0.1", "0.5", "-0.4", "0.2", "-0.3", "-0.1"
                };
                break;
            case 6:
            case 5:
                names = new String[]
                {
                    "LFA", "LFB", "LFC", "RRA", "RRB", "RRC", "LRB"
                };
                values = new String[]
                {
                    "-0.4", "0.2", "-0.3", "0.1", "0.1", "0.5", "-0.1"
                };
                break;
            case 4:
            case 3:
                names = new String[]
                {
                    "LRA", "LRB", "LRC", "RFA", "RFB", "RFC", "LFA", "LFB", "LFC"
                };
                values = new String[]
                {
                    "-0.2", "0.3", "-0.6", "0.1", "0.1", "0.4", "0", "0", "0"
                };
                break;
            case 8:
            case 7:
                names = new String[]
                {
                    "LFA", "LFB", "LFC", "RRA", "RRB", "RRC", "RFA", "RFB", "RFC"
                };
                values = new String[]
                {
                    "0.1", "0.1", "0.4", "-0.2", "0.3", "-0.6", "0", "0", "0"
                };
                break;

            default:
                names = new String[]
                {
                    "LFA"
                };
                values = new String[]
                {
                    "0"
                };
                break;
        }
        bot.getAct().act(new Multidrive(names, values));
        if(walkCount > 7)
        {
            walkCount = 0;
        }
    }

    /**
     * Sets constant speed of camera roatation and repeatedly tilts the camera
     * from min angle to max.
     */
    private void rotateCamera()
    {
        if(cameraTilt >= cameraMaxTilt || cameraTilt <= cameraMinTilt)
        {
            cameraTiltInc *= -1;
        }
        cameraTilt += cameraTiltInc;
        //{Order int} ‘int’ is optional (0 by default) and indicates the control mode. ‘0’ means angle control, ‘1’ means speed control, and ‘2’ means torque control. 
        //also not in manual  10 - relative angle, 11-relative speed, 12 relative torque
        int[] links = new int[]
        {
            1, 2
        };
        double[] values = new double[]
        {
            cameraRotationSpeed, cameraTilt
        };
        int[] orders = new int[]
        {
            1, 0
        };
        bot.getAct().act(new MissionPackage(mispkgName, links, values, orders));
    }

    /**
     * Repeatedly sets the FOV of the camera from one extreme to another.
     */
    private void zoomCamera()
    {
        if(cameraActFov >= cameraMaxFov || cameraActFov <= cameraMinFov)
        {
            cameraInc *= -1;
        }
        cameraActFov += cameraInc;
        bot.getAct().act(new SetCamera(cameraType, cameraName, cameraActFov));
    }

    /**
     * Initialization of modules used within this robot.
     *
     * @param bot Necessary parameter for hooking listeners and for sending
     * commands
     */
    @Override
    public void prepareBot(USAR2004Bot bot)
    {
        super.prepareBot(bot);

        //getWorldView().addEventListener(StateMessage.class, statList);

        //senModule = SensorMasterModule.getModuleInstance(bot);
        geoModule = GeometryMasterModule.getModuleInstance(bot);
        confModule = ConfigMasterModule.getModuleInstance(bot);
        resModule = ResponseModule.getModuleInstance(bot);
        staModule = StateMasterModule.getModuleInstance(bot);

        helperSensor = new SensorSpecificModule<SensorHelper>(bot, SensorHelper.class);

        //getWorldView().addEventListener(SensorMessage.class, sensorList);
        //getWorldView().addEventListener(NfoMessage.class, nfoList);

        //Map<Class, Map<WorldObjectId, IViewable>> allVisible = getWorldView().getAllVisible();
    }
    //private NfoBeginMapInfo begin;
    private NfoStartPoses startPoses;
    private SensorLaser laserSensor;
    //private InitializeOnceOnStartPoses initModule;
    //private SensorMasterModule senModule;
    private GeometryMasterModule geoModule;
    private ConfigMasterModule confModule;
    private ResponseModule resModule;
    private StateMasterModule staModule;
    private SensorSpecificModule<SensorHelper> helperSensor;

    public static void main(String[] args)
    {
        new USAR2004BotRunner(AiboERSRobot.class, "PogamutBotBot", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.OFF).startAgent();
    }
}