/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

public class ScanAreaAnalysis {
    private boolean singleFlight = true;
    public static final Location destCenter = new Location(11.0, -50.0);
    public static final double destWidth = 174.0;
    public static final double destHeight = 174.0;
    public final boolean shouldWriteDatFile = true;
    public final double seaLevel = 3.0;
    private static final double multipleMargin = 10.0;
    private static final double minDensity = 15.0;
    Location destination = destCenter;
    double dWidth = 174.0;
    double dHeight = 174.0;
    Location longStep;
    Location shortStep;
    int cycle = 0;
    int cycleStop = 0;

    public ScanAreaAnalysis() {
        boolean bl = this.singleFlight = !ScanAreaAnalysis.isLargeSpace();
        if (!this.singleFlight) {
            this.initMultipleRun();
        }
        this.setupSteps(this.destination);
    }

    public Location getClosestCorner(Location actual) {
        Location closest = new Location(this.destination.x - this.dWidth / 2.0, this.destination.y + this.dHeight / 2.0);
        Location rt = new Location(this.destination.x + this.dWidth / 2.0, this.destination.y + this.dHeight / 2.0);
        Location lb = new Location(this.destination.x - this.dWidth / 2.0, this.destination.y - this.dHeight / 2.0);
        Location rb = new Location(this.destination.x + this.dWidth / 2.0, this.destination.y - this.dHeight / 2.0);
        if (Location.getDistance2D((Location)closest, (Location)actual) > Location.getDistance2D((Location)rt, (Location)actual)) {
            closest = rt;
        }
        if (Location.getDistance2D((Location)closest, (Location)actual) > Location.getDistance2D((Location)lb, (Location)actual)) {
            closest = lb;
        }
        if (Location.getDistance2D((Location)closest, (Location)actual) > Location.getDistance2D((Location)rb, (Location)actual)) {
            closest = rb;
        }
        return closest;
    }

    public void setNextDestination(int multipleRunNo) {
        switch (multipleRunNo) {
            case 0: {
                return;
            }
            case 1: {
                this.destination = new Location(ScanAreaAnalysis.destCenter.x - this.dWidth / 2.0 - 10.0, ScanAreaAnalysis.destCenter.y + this.dHeight / 2.0 + 10.0);
                break;
            }
            case 2: {
                this.destination = new Location(ScanAreaAnalysis.destCenter.x - this.dWidth / 2.0 - 10.0, ScanAreaAnalysis.destCenter.y - this.dHeight / 2.0 - 10.0);
                break;
            }
            case 3: {
                this.destination = new Location(ScanAreaAnalysis.destCenter.x + this.dWidth / 2.0 + 10.0, ScanAreaAnalysis.destCenter.y - this.dHeight / 2.0 - 10.0);
                break;
            }
            default: {
                this.destination = Location.ZERO;
                return;
            }
        }
        this.cycle = 0;
        this.setupSteps(this.destination);
    }

    public static boolean isLargeSpace() {
        return true;
    }

    private void initMultipleRun() {
        this.dWidth = 77.0;
        this.dHeight = 77.0;
        this.destination = new Location(ScanAreaAnalysis.destCenter.x + this.dWidth / 2.0 + 10.0, ScanAreaAnalysis.destCenter.y + this.dHeight / 2.0 + 10.0);
    }

    private void setupSteps(Location center) {
        Location corner = this.getClosestCorner(Location.ZERO);
        if (this.dHeight > this.dWidth) {
            double density = this.dWidth / Math.ceil(this.dWidth / 15.0);
            this.longStep = new Location(0.0, this.dHeight * Math.signum(center.y - corner.y));
            this.shortStep = new Location(density * Math.signum(center.x - corner.x), 0.0);
            this.cycleStop = (int)(this.dWidth / density);
        } else {
            double density = this.dHeight / Math.ceil(this.dHeight / 15.0);
            this.longStep = new Location(this.dWidth * Math.signum(center.x - corner.x), 0.0);
            this.shortStep = new Location(0.0, density * Math.signum(center.y - corner.y));
            this.cycleStop = (int)(this.dHeight / density);
        }
    }
}

