package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

/**
 * Action that triggers events that causes robot to return back to base for a
 * recharge.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "TerminateEvadingProcedure", description = "Causes the robot to return for a recharge.")
public class TerminateEvadingProcedure extends StateAction<AirRobotContext>
{
    public TerminateEvadingProcedure(AirRobotContext ctx)
    {
        super("TerminateEvadingProcedure", ctx);
    }

    @Override
    public void init(VariableContext params)
    {
        //before the run() call.
    }

    @Override
    public void done(VariableContext params)
    {
        //after last call - a new rule applied.
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("terminate");
        setTempStallState();
        ctx.setRechargePoint();
        return ActionResult.FINISHED;
    }
    
    
    /**
     * This will save the state and location of initial goal.
     */
    public void setTempStallState()
    {
        if(ctx.tempState == null)
        {
            System.out.println("tempState == null");
        }
        else
        {
            ctx.stallState = ctx.tempState;
            System.out.println("setTempStallState");
            System.out.println(ctx.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getTime());
        }
        //tempState = null;
        ctx.stallNextLoc = ctx.tempNextLoc;
        //tempNextLoc = null;
        ctx.stallActLoc = (Location.getDistance2D(ctx.actLoc, ctx.stallNextLoc) < 15)?ctx.stallNextLoc:ctx.actLoc;//close enough to the next goal
    }
}
