package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Action that issue the risk count and norisk count values and eventually
 * releases the diversion if evading.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "NoRiskAction", description = "Robot will eventually release the diversion if avoiding.")
public class NoRiskAction extends StateAction<AirRobotContext>
{
    public NoRiskAction(AirRobotContext ctx)
    {
        super("NoRiskAction", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("NoRisk");
        ctx.issueNoRisk();
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
}
