package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

/**
 * This support class offers some helping methods to initialize and compute
 * Scanning area, its boundaries, and related atributes.
 *
 * @author vejmanm
 */
public class ScanAreaAnalysis
{
    private boolean singleFlight = true;

    /**
     * Ctor will setup atributes for the path planning support based on the size
     * of the area to be scanned.
     */
    public ScanAreaAnalysis()
    {
        //prepare variables for the flight.
        singleFlight = !isLargeSpace();
        if(!singleFlight)
        {
            initMultipleRun();
        }
        setupSteps(destination);
    }
    //-------------------------------------------------
    /*
     * This is the place to change the scanning area
     */
    //-------------------------------------------------
    public static final Location destCenter = new Location(11,-50);//(12,3);//(11,-50);//(-49, -255);
    public static final double destWidth = 174;//30;//174;//774;
    public static final double destHeight = 174;//50;//174;//774;    
    public final boolean shouldWriteDatFile = true;
    public final double seaLevel = 3;
    
    
    //no need to change this
    private static final double multipleMargin = 10;
    private static final double minDensity = 15;// how far will the next row be    
    //ready for single run
    Location destination = destCenter;
    double dWidth = destWidth;
    double dHeight = destHeight;

    /**
     * Takes a rectangle described by the <b>center</b>, <b>width</b> and
     * <b>height</b> parameters and computes the nearest corner from
     * <b>actual</b> location.
     *
     * @param actual Subject of the measurement.
     * @return Returns a Location representing the closest corner relative to
     * the rectangle and actual location.
     */
    public Location getClosestCorner(Location actual)
    {
        Location closest = new Location(destination.x - dWidth / 2, destination.y + dHeight / 2);//LeftTop
        Location rt = new Location(destination.x + dWidth / 2, destination.y + dHeight / 2);//RightTop
        Location lb = new Location(destination.x - dWidth / 2, destination.y - dHeight / 2);//LeftBottom
        Location rb = new Location(destination.x + dWidth / 2, destination.y - dHeight / 2);//RightBottom

        if(Location.getDistance2D(closest, actual) > Location.getDistance2D(rt, actual))
        {
            closest = rt;
        }
        if(Location.getDistance2D(closest, actual) > Location.getDistance2D(lb, actual))
        {
            closest = lb;
        }
        if(Location.getDistance2D(closest, actual) > Location.getDistance2D(rb, actual))
        {
            closest = rb;
        }
        return closest;
    }

    /**
     * Based on the number of the multiple run it decides which destination is
     * next in line to scan.
     *
     * @param multipleRunNo Number of multiple scan cycle.
     * @return
     */
    public void setNextDestination(int multipleRunNo)
    {
        switch(multipleRunNo)
        {
            case 0:
                return;
            case 1:
                destination = new Location(destCenter.x - dWidth / 2 - multipleMargin, destCenter.y + dHeight / 2 + multipleMargin);
                break;
            case 2:
                destination = new Location(destCenter.x - dWidth / 2 - multipleMargin, destCenter.y - dHeight / 2 - multipleMargin);
                break;
            case 3:
                destination = new Location(destCenter.x + dWidth / 2 + multipleMargin, destCenter.y - dHeight / 2 - multipleMargin);
                break;
            default:
                destination = Location.ZERO;
                return;
        }
        cycle = 0;
        setupSteps(destination);
    }
    Location longStep; //bude se muset vypočítat je to max(width,height) a směr se určí podle destination-(nejbližší z rohů obdélníka) samozřejmě se odečítají souřadnice podle max(width,height)
    Location shortStep; //je vypočítán z density a směr je podle nejbližšího z rohů obdélníka
    int cycle = 0;
    int cycleStop = 0;

    /**
     * Decides wether the scanning area is large enough to perform multiple run
     * or not.
     *
     * @return Returns true if the scanning area is large, false otherwise.
     */
    public static boolean isLargeSpace()
    {
        return ((destHeight > 150) || (destWidth > 150));
    }

    /**
     * We want to scan large space, therefore we use multiple run that will
     * devide the space into quarters. On these quarters it will perform the
     * same technique as if it was a single run. Also we dont need to scan
     * exactly the quarters computed from the large area. We know that every two
     * quarters have one neighboring side. Therefore we can reduce the desired
     * quarter area by some margin at this neighboring sides. In other words we
     * can cover the initial large space by scaning four small areas separated
     * by a margin cross.
     */
    private void initMultipleRun()
    {
        dWidth = destWidth / 2 - multipleMargin;// Math.abs(destination.x * 2);
        dHeight = destHeight / 2 - multipleMargin; //Math.abs(destination.y * 2);
        destination = new Location(destCenter.x + dWidth / 2 + multipleMargin, destCenter.y + dHeight / 2 + multipleMargin);
    }

    /**
     * Based on the rectangle size and dimensions and respective to the
     * <b>center</b> location it computes how long will be the lines, how many
     * and how dense they will be.
     *
     * @param center Center of the rectangle that is about to be scanned
     */
    private void setupSteps(Location center)
    {
        //set direction towards the center and pick the longer side every time!
        //the small step has the oposite coordinate and points to the center as well.
        //finally set the Stop to numbher of rows made.

        Location corner = getClosestCorner(Location.ZERO);
        if(dHeight > dWidth)
        {
            double density = dWidth / Math.ceil(dWidth / minDensity);
            longStep = new Location(0, dHeight * Math.signum(center.y - corner.y));
            shortStep = new Location(density * Math.signum(center.x - corner.x), 0);
            cycleStop = (int) (dWidth / density);
        }
        else
        {
            double density = dHeight / Math.ceil(dHeight / minDensity);
            longStep = new Location(dWidth * Math.signum(center.x - corner.x), 0);
            shortStep = new Location(0, density * Math.signum(center.y - corner.y));
            cycleStop = (int) (dHeight / density);
        }
    }
}
