package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Sense for initial configuration, We need to make sure that the form is
 * initialized in order to star the procedure that involves handling the preview
 * Form.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "PreviewFormVisible", description = "Is the form ready to recieve data?")
public class PreviewFormVisible extends StateSense<AirRobotContext, Boolean>
{
    public PreviewFormVisible(AirRobotContext ctx)
    {
        super("PreviewFormVisible", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("previewFormReady?");
        //to prevent falling we have to have initialized preview form to proceed.
        return !(ctx.previewForm == null || ctx.previewForm.isActive() == false);//|| !ctx.previewForm.isShowing())
    }
}