package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveAerial;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Action that takes the robot to operational altitude.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "Rise", description = "Robot will fly upwards.")
public class Rise extends StateAction<AirRobotContext>
{
    public Rise(AirRobotContext ctx)
    {
        super("Rise", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("rise");
        rise();
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
    
    /**
     * This will cause the robot to ascend to optimal scanning altitude.
     */
    public void rise()
    {
        if(ctx.altitude == 0)
        {
            return;
        }
        ctx.actAlt = ctx.laser.getNMidAvg(10);//nemusíme počítat s odchylkou, když soupá kolmo
        //musíme stoupat pomalu, aby se nezbláznila odchylka
        ctx.getAct().act(new DriveAerial(ctx.maxAltitudeVelocity / 4, 0, 0, 0, false));
        if(ctx.altitude - ctx.actAlt < 0)
        {
            ctx.risen = true;
            ctx.getAct().act(new DriveAerial(0, 0, 0, 0, false));
        }
    }
}
