package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.configuration.ConfigAerial;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.*;
import cz.cuni.amis.pogamut.usar2004.agent.module.geometry.GeoSensorEffecter;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.*;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.SensorMount;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveAerial;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.SetSensorEffecter;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.*;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

/**
 * Context is a class that funsions like a shared object between all primitives.
 * You may use default {@link UT2004Context} or create custom one, that is
 * extended to fulfill needs of your bot (extended memory, custom map planner
 * and other stuff).
 *
 * Remmeber to call method {@link UT2004Context#initialize() }, otherwise you
 * will end up with uninitialized modules and very likely with {@link NullPointerException}.
 *
 * @author vejmanm
 */
public class AirRobotContext extends USAR2004Context<USAR2004Bot>
{
    public AirRobotContext(USAR2004Bot bot)
    {
        super("AirRobotContext", bot);
        // IMPORTANT: Various modules of context must be initialized.
        initialize();
        initForm();
        initModules();
    }

    //<editor-fold defaultstate="collapsed" desc="Initialization of modules and prevForm">
    /**
     * Each module that is used within this project gets its own singleton.
     * Individual sensors are extracted from the sensorModule here for the first
     * time to be availible.
     */
    public void initModules()
    {
        senModule = SensorMasterModuleQueued.getModuleInstance(bot);
        geoModule = GeometryMasterModule.getModuleInstance(bot);
        confModule = ConfigMasterModule.getModuleInstance(bot);
        resModule = ResponseModule.getModuleInstance(bot);
        staModule = StateMasterModule.getModuleInstance(bot);
    }
    //various modules:
    public SensorMasterModuleQueued senModule;
    public GeometryMasterModule geoModule;
    public ConfigMasterModule confModule;
    public ResponseModule resModule;
    public StateMasterModule staModule;
    //preview jForm:
    public ScanPreview previewForm = null;
    //support objects:
    public ScanAreaAnalysis scanHelper = new ScanAreaAnalysis();

    /**
     * This method tries to invoke new jForm which is used to show sensor data
     * and the scanning process.
     */
    public void initForm()
    {
        SwingUtilities.invokeLater(new Runnable()
        {
            @Override
            public void run()
            {
                try
                {
                    previewForm = new ScanPreview();
                    previewForm.runScanPreview();
                }
                catch(Exception e)
                {
                    System.out.println(e.getMessage());
                }
            }
        });
        System.out.println("Form set to be initialized.");
    }
    //each sensor has its own property wrapper.
    public SensorLaser laser;
    public SensorGroundTruth truth;
    public SensorINS ins;
    public SensorRange sonar;
    //</editor-fold>    
    //<editor-fold defaultstate="collapsed" desc="Get Configuration from the server">
    /*
     * variables acquired from the server at startup. They are used as
     * informative factors to determine robots capabilities
     */
    public double maxLateralVelocity;
    public double maxLinearVelocity;
    public double maxAltitudeVelocity;
    public double maxRotationalVelocity;
    public Location startLoc;
    public List<SensorMount> sonarGeo;
    public long startTime;
    
    //</editor-fold>
    //int cycle = 0;
    public State state = State.DEFAULT;
    public State tempState = null;
    public State stallState = null;
    public final double scanAltitude = 6;
    public double altitude = scanAltitude;
    public int multipleRunCount = 0;

    //<editor-fold defaultstate="collapsed" desc="Quarter - multiple - run related setup methods">
    /**
     * According to the <b>multipleRunCount</b> it recomputes the attributes
     * helping the construction of the robots path. It also resets the robots
     * variables to be able to start with fresh values and measurements.
     *
     * @param multipleRunCount Quarter number to be scanned.
     */
    public void setupMultiple(int multipleRunCount)
    {
        scanHelper.setNextDestination(multipleRunCount);
        if(multipleRunCount < 4)
        {
            resetINS();
            nextLoc = scanHelper.getClosestCorner(Location.ZERO);
            state = State.DEFAULT;
            this.multipleRunCount++;
            prepareForTakeof();
        }
        else
        {
            altitude = 0;
        }
    }

    /**
     * Resets necessary atributes to its initial values for the robot to be able
     * to start over. Atributes such as battery used, trip, altitude properties.
     */
    public void prepareForTakeof()
    {
        risen = false;
        battFills++;

        double battUsed = battFull - staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        double range = (battLife - battUsed) * (trip / battUsed);
        System.out.println("range left: " + range + " trip odometer: " + trip + " battery used: " + battUsed);

        battFull = staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();//reset batteryMeter
        trip = 0; //reset odometer
        altitude = scanAltitude;
        Wait.resetTime();
    }

    /**
     * Takes data from the Ground truth sensor and according to these, it issues
     * a command that sets the INS location and orientation to simulate reset of
     * some drift.
     */
    public void resetINS()
    {
        try
        {
            Location truthLoc = truth.getLocation();
            Rotation truthRot = truth.getOrientation();
            previewForm.setStartLocation(Location.sub(startLoc, truthLoc.getLocation()));
            StringBuilder sb = new StringBuilder();
            sb.append(truthLoc.x).append(',').append(truthLoc.y).append(',').append(truthLoc.z).append(',');
            sb.append(truthRot.roll).append(',').append(truthRot.pitch).append(',').append(truthRot.yaw);
            bot.getAct().act(new SetSensorEffecter("INS", "INS", "POSE", sb.toString()));
        }
        catch(Exception e)
        {
            System.out.println("Error reseting INS");
        }
    }
    //</editor-fold>
    //repetitevly changed variables - battery related
    public final int battLife = 500;
    public int battFills = 0;
   public  int battFull;
    public Location actLoc; //Location of the robot.
    public Location prevLoc; //Location used to compute distance traveled during one cycle.
    public Location nextLoc; //goal being pursued by the robot at any time.
    public Location stallActLoc; //used for saving its position to know where to continue after charging.
    public Location stallNextLoc; //used for saving its original goal when going for a charge.
    public Location tempNextLoc; //used for saving its original goal when avoiding.
    public double minDev = 0.9d; //deviation tollerated when reaching the next location.
    public double actAlt = 0;
    public Rotation actRot;
    public double trip = 0;
    //variables used by senses
    public boolean parametersObtained = false;
    public boolean risen = false;

   
    //<editor-fold defaultstate="collapsed" desc="Battery watch and actions">
    public final double rangeCoeficient = 0.85d;

    
    /**
     * Method for saving the state and goal location when dodging obstacles.
     */
    public void setStallState()
    {
        stallState = state;
        stallNextLoc = nextLoc;
        //if the robot is very close to the next checkpoint it will not return to actual location but skip to this next checkpoint
        stallActLoc = (Location.getDistance2D(actLoc, nextLoc) < 15)?nextLoc:actLoc;
    }
    
    /**
     * Helper method for seting a goal to robot's base.
     */
    public void setRechargePoint()
    {
        state = State.CHARGE;
        nextLoc = Location.ZERO;
        minDev = 1.5d;//lets tollerate larger space - better for smoother landing
        previewForm.setRechargeBreakPoint(actLoc);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="Sonar related methods">
    
    /**
     * *
     * Computes an angle in degrees of the aircraft relative to next Location
     * that the robot is heading to.
     *
     * @param actual Tells the method whether it should be considering temporary
     * next Location (true) or not (false). Temporary next Location is greater
     * goal that the robot is not pursuing when avoiding an obstacle.
     * @return Returns angle in degrees relative to next Location or temp. next
     * Location based on <B>actual</B>
     */
    public double getTargetAngle(boolean actual)
    {
        //v1 is vector from actual location to next location
        double v1x;
        double v1y;
        if(actual && state == State.AVOIDING && tempNextLoc != null)
        {
            v1x = tempNextLoc.x - actLoc.x;
            v1y = tempNextLoc.y - actLoc.y;
        }
        else
        {
            v1x = nextLoc.x - actLoc.x;
            v1y = nextLoc.y - actLoc.y;

        }
        double v1l = Math.sqrt(v1x * v1x + v1y * v1y);

        double sinv1 = v1y / v1l;
        double cosv1 = v1x / v1l;

        double v1Theta = (ToolBox.getAngle(sinv1, cosv1) + 180) % 360;//requiered angle
        double v2Theta = actRot.yaw * 180 / Math.PI;//robot actual angle
        double diff = v2Theta - v1Theta;//(Math.abs(v2Theta - v1Theta) < Math.abs(v1Theta - v2Theta))?v2Theta - v1Theta:v1Theta - v2Theta;
        if(diff > 180)
        {
            diff = diff - 360;
        }
        else if(diff < -180)
        {
            diff = diff + 360;
        }
        return diff;
    }
    

    /**
     * If the robot is in no danger for a few iterations it releases its diversion point.
     */
    public void issueNoRisk()
    {
        noriskCount++;
        if(noriskCount > 3)
        {
            tryReleaseDiversion();
        }
        if(noriskCount > 15)
        {
            riskCount = 0;
        }
    }

    

    /**
     * If the robot is avoiding this will release its diversion point.
     */
    public void tryReleaseDiversion()
    {
        if(state == State.AVOIDING || state == State.AVOIDED)
        {
            if(tempState == null)
            {
                System.out.println("tempState == null");
            }
            else
            {
                state = tempState;
                //System.out.println("releaseDiversion");
                //System.out.println(staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getTime());
            }
            nextLoc = tempNextLoc;
            //tempNextLoc = null;            
            //tempState = null;
        }
    }

    /**
     * Gets risk level from each sonar from the Map sonars and returns the name
     * that is exposed to the greatest risk.
     *
     * @param sonars Map acquired from the sensor module.
     * @return returns the name of the sensor thats exposure is most dangerous.
     */
    public String getGreatestRiskSensor(Map<String, Double> sonars)
    {
        RiskLevel globalRisk = RiskLevel.NORISK;
        double riskValue = sonarThreashold;
        String riskName = null;
        //order of entrys does not matter at this point
        for(Map.Entry<String, Double> entry : sonars.entrySet())
        {
            RiskLevel risk = getRiskLevel(entry.getKey(), entry.getValue());
            //due to nonequal conditions for each sonar, we have to get the urgency first(greater urgency at one could be further than no urgency at other)
            //and than ask the distance. We want to determine the greatest risk and than the nearest sonar at this risk level

            if(risk.isGreaterRisk(globalRisk))
            {
                globalRisk = risk;
                riskValue = entry.getValue();
                riskName = entry.getKey();
            }
            else if(risk == globalRisk)
            {
                if(entry.getValue() < riskValue)
                {
                    riskValue = entry.getValue();
                    riskName = entry.getKey();
                }
            }
        }
        return riskName;
    }

    /**
     * Decides the risk individually based on the name of the sonar and static
     * arrays with Low Risk and High Risk Threasholds. (Side sonars have grater
     * tollerance than the front ones.)
     *
     * @param sonar Name of the sonar sensor.
     * @param value Value of the sonar sensor.
     * @return Returns the risk based on the name of the sonar.
     */
    public RiskLevel getRiskLevel(String sonar, double value)
    {
        if(value < highRisk.get(sonar))
        {
            return RiskLevel.HIGHRISK;
        }
        if(value < lowRisk.get(sonar))
        {
            return RiskLevel.LOWRISK;
        }
        return RiskLevel.NORISK;
    }
    public int noriskCount = 0;
    public int riskCount = 0;
    public boolean hoverAvoiding = true;
    public final double sonarThreashold = 4.91d;//value beyond this threashold is eqal to infinity
    
    public final Map<String, Double> highRisk = new HashMap<String, Double>()
    {
        
        {
            put("L4", 0.47d);
            put("R4", 0.47d);
            put("L3", 0.61d);
            put("R3", 0.61d);
            put("L2", 0.86d);
            put("R2", 0.86d);
            put("L1", 1.22d);
            put("R1", 1.22d);
            put("M0", 1.5d);
        }
    };
    public final Map<String, Double> lowRisk = new HashMap<String, Double>()
    {
        
        {
            put("L4", 1.57d);
            put("R4", 1.57d);
            put("L3", 1.91d);
            put("R3", 1.91d);
            put("L2", 2.72d);
            put("R2", 2.72d);
            put("L1", 3.5d);
            put("R1", 3.5d);
            put("M0", 4.2d);
        }
    };
    public final String[] sonarOrder = new String[]
    {
        "L4", "L3", "L2", "L1", "M0", "R1", "R2", "R3", "R4"
    };
    //</editor-fold>
    public boolean scanning = false; //not scanning-no need for slow motion
    public final double scanningSpeed = 0.2d;//0.18d;//0.3d;//
    public final double flyingSpeed = 0.35d;
    public double speed = 0;
    public double rotSpeed = 0;

    //<editor-fold defaultstate="collapsed" desc="Movement handling">
    public boolean isScanning(State state)
    {
        return (state == State.LONGFORTH || state == State.SHORTFORTH || state == State.LONGBACK || state == State.SHORTBACK);
    }

    /**
     * Checks if the robot is at the floor.
     * @return Returns true if the robot is charging or is landed.
     */
    public boolean isLanding()
    {
        return (state == State.CHARGING || state == State.LAND);
    }
    public final int dockWaitPenalty = 8;
    public final int numOfRays = 10;//number of rays used to measure the avg. altitude of the robot from the range scanner

    

    /**
     * Chosing of action to do next if goal is reached.
     * @param state 
     */
    public void computeNext(State state)
    {
        switch(state)
        {
            case DEFAULT:
            case LONGFORTH:
                nextLoc = nextLoc.add(scanHelper.longStep);//add long Step
                break;
            case SHORTFORTH:
            case SHORTBACK:
                //add shortStep or end it if sufficient steps were accomplished
                nextLoc = nextLoc.add(scanHelper.shortStep);
                if(scanHelper.cycle >= scanHelper.cycleStop)
                {
                    this.state = State.TERMINATE;
                    nextLoc = new Location(0, 0, 0);
                }
                scanHelper.cycle++;
                break;
            case LONGBACK:
                nextLoc = nextLoc.sub(scanHelper.longStep);//subtract long Step
                break;
            case TERMINATE://do nothing
                break;
            case LAND:
            case CHARGING:
                altitude = 0;//land an aircraft
                break;
            case CONTINUED:
                continueScanning();//waited enough->reset and continue
                break;
            case AVOIDED:
                tryReleaseDiversion();//reached the diversion point
                break;
            default:
                System.out.println("Unexpected STATE");
        }
    }

    /**
     * If the robot is charged and is establishing the scanning procedure this will set the initial goal and state.
     */
    public void continueScanning()
    {
        if(stallState == null)
        {
            return;
        }
        this.state = stallState;
        //stallState = null;
        nextLoc = stallNextLoc;
        //stallNextLoc = null;
        minDev = 0.9d;
    }

    public final int jammedLimit = 17; //ment for flying speed
    
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="Perform sensor and preview form update">
    
    /**
     * This computes the avarage height from ten rays from Range scanner that
     * aim directly below the robot.
     */
    public void checkAltitudeFromLaser()
    {
        //SensorLaser laser = (SensorLaser) (senModule.getSensorsBySensorType(SensorType.LASER_SENSOR).get(0));
        //half of the FOV + actRotation to degrees + 90° gives us the angle of a ray that is aiming vertically
        //máme v paměti, že jeden paprsek = 1°
        //a taky že rotace je mezi 0 a 6.28, resp. že když se nakloní doprava tak se k nule přičítá a když doleva, tak se od 6.28 odečítá
        int offset = (int) ((actRot.roll >= Math.PI)?(360 - (actRot.roll * 180 / Math.PI)):(-actRot.roll * 180 / Math.PI));
        double avgRange = laser.getNMidAvg(numOfRays, offset);
        actAlt = Math.cos(actRot.pitch) * avgRange;
        previewForm.setOffset(offset);
    }
    //</editor-fold>
}
