/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.sposh.context.Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.SensorMount;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.RiskLevel;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;
import java.util.Map;

@PrimitiveInfo(name="ComputeDiversion", description="Robot will try to get away from obstacle.")
public class ComputeDiversion
extends StateAction<AirRobotContext> {
    public ComputeDiversion(AirRobotContext ctx) {
        super("ComputeDiversion", (Context)ctx);
    }

    public ActionResult run(VariableContext vc) {
        this.issueLowRisk();
        return ActionResult.FINISHED;
    }

    public void init(VariableContext vc) {
    }

    public void done(VariableContext vc) {
    }

    public void issueLowRisk() {
        if (((AirRobotContext)this.ctx).hoverAvoiding) {
            this.computeDiversion(((AirRobotContext)this.ctx).sonar.getRanges());
            ((AirRobotContext)this.ctx).noriskCount = 0;
            ((AirRobotContext)this.ctx).previewForm.setLowRiskPoint(((AirRobotContext)this.ctx).actLoc);
        }
        ++((AirRobotContext)this.ctx).riskCount;
    }

    public void computeDiversion(Map<String, Double> sonars) {
        RiskLevel targetRiskLevel;
        boolean leftSide = true;
        double leftWM = 0.0;
        double rightWM = 0.0;
        double leftFittest = 0.0;
        double rightFittest = 0.0;
        int leftFindex = 0;
        int rightFindex = 0;
        String greatestThreat = ((AirRobotContext)this.ctx).getGreatestRiskSensor(sonars);
        int greatestRiskIndex = -1;
        for (int i = 0; i < sonars.size(); ++i) {
            Double entry = sonars.get(((AirRobotContext)this.ctx).sonarOrder[i]);
            if (((AirRobotContext)this.ctx).sonarOrder[i].equals(greatestThreat)) {
                greatestRiskIndex = i;
                leftSide = false;
                continue;
            }
            if (leftSide) {
                leftWM += entry * entry;
                if (!(leftFittest < entry) && !(entry > ((AirRobotContext)this.ctx).sonarThreashold)) continue;
                leftFittest = entry;
                leftFindex = i;
                continue;
            }
            rightWM += entry * entry;
            if (!(rightFittest < entry) || !(rightFittest < ((AirRobotContext)this.ctx).sonarThreashold)) continue;
            rightFittest = entry;
            rightFindex = i;
        }
        if (leftWM < rightWM) {
            RiskLevel righterRisk;
            if (rightFindex < 7 && sonars.get(((AirRobotContext)this.ctx).sonarOrder[rightFindex - 1]) < 2.5) {
                RiskLevel righterRisk2 = ((AirRobotContext)this.ctx).getRiskLevel(((AirRobotContext)this.ctx).sonarOrder[rightFindex + 2], sonars.get(((AirRobotContext)this.ctx).sonarOrder[rightFindex + 2]));
                if (righterRisk2 == RiskLevel.NORISK) {
                    rightFindex += 2;
                }
            } else if (rightFindex < 8 && (righterRisk = ((AirRobotContext)this.ctx).getRiskLevel(((AirRobotContext)this.ctx).sonarOrder[rightFindex + 1], sonars.get(((AirRobotContext)this.ctx).sonarOrder[rightFindex + 1]))) == RiskLevel.NORISK) {
                ++rightFindex;
            }
            int targetIndex = this.getSonarTargetIndex();
            if (targetIndex > rightFindex && targetIndex < 8 && (targetRiskLevel = ((AirRobotContext)this.ctx).getRiskLevel(((AirRobotContext)this.ctx).sonarOrder[targetIndex], sonars.get(((AirRobotContext)this.ctx).sonarOrder[targetIndex]))) == RiskLevel.NORISK) {
                rightFindex = targetIndex;
                ((AirRobotContext)this.ctx).tryReleaseDiversion();
                return;
            }
            this.setDiversionPoint(rightFindex, rightFittest);
        } else {
            RiskLevel lefterRisk;
            if (leftFindex > 1 && sonars.get(((AirRobotContext)this.ctx).sonarOrder[leftFindex + 1]) < 1.5) {
                RiskLevel lefterRisk2 = ((AirRobotContext)this.ctx).getRiskLevel(((AirRobotContext)this.ctx).sonarOrder[leftFindex - 2], sonars.get(((AirRobotContext)this.ctx).sonarOrder[leftFindex - 2]));
                if (lefterRisk2 == RiskLevel.NORISK) {
                    leftFindex -= 2;
                }
            } else if (leftFindex > 0 && (lefterRisk = ((AirRobotContext)this.ctx).getRiskLevel(((AirRobotContext)this.ctx).sonarOrder[leftFindex - 1], sonars.get(((AirRobotContext)this.ctx).sonarOrder[leftFindex - 1]))) == RiskLevel.NORISK) {
                --leftFindex;
            }
            int targetIndex = this.getSonarTargetIndex();
            if (targetIndex < leftFindex && targetIndex > 0 && (targetRiskLevel = ((AirRobotContext)this.ctx).getRiskLevel(((AirRobotContext)this.ctx).sonarOrder[targetIndex], sonars.get(((AirRobotContext)this.ctx).sonarOrder[targetIndex]))) == RiskLevel.NORISK) {
                leftFindex = targetIndex;
                ((AirRobotContext)this.ctx).tryReleaseDiversion();
                return;
            }
            this.setDiversionPoint(leftFindex, leftFittest);
        }
    }

    public int getSonarTargetIndex() {
        int sonarIndex = -1;
        int count = 0;
        double v1Theta = ((AirRobotContext)this.ctx).getTargetAngle(true) / 180.0 * Math.PI;
        double minDiv = 7.0;
        for (SensorMount sensorMount : ((AirRobotContext)this.ctx).sonarGeo) {
            if (minDiv > Math.abs(v1Theta - sensorMount.getOrientation().yaw)) {
                minDiv = Math.abs(v1Theta - sensorMount.getOrientation().yaw);
                sonarIndex = count;
            }
            ++count;
        }
        return sonarIndex;
    }

    public void setDiversionPoint(int index, double fittest) {
        Rotation sonarRot = ((AirRobotContext)this.ctx).sonarGeo.get(index).getOrientation();
        String greatestThreat = ((AirRobotContext)this.ctx).getGreatestRiskSensor(((AirRobotContext)this.ctx).sonar.getRanges());
        double angle = 1.5707963267948966 - (sonarRot.yaw + ((AirRobotContext)this.ctx).actRot.yaw) + (greatestThreat.charAt(0) == 'L' ? -0.3 : (greatestThreat.charAt(0) == 'R' ? 0.3 : 0.0));
        Location actDiv = new Location(-Math.sin(angle) * fittest, -Math.cos(angle) * fittest);
        Location diversion = ((AirRobotContext)this.ctx).actLoc.add(actDiv);
        ((AirRobotContext)this.ctx).previewForm.setDivPoint(diversion);
        if (((AirRobotContext)this.ctx).state != State.AVOIDING) {
            ((AirRobotContext)this.ctx).tempState = ((AirRobotContext)this.ctx).state;
            ((AirRobotContext)this.ctx).tempNextLoc = ((AirRobotContext)this.ctx).nextLoc;
        }
        ((AirRobotContext)this.ctx).state = State.AVOIDING;
        ((AirRobotContext)this.ctx).nextLoc = diversion;
    }
}

