package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Sense for initial configuration, We need to recieve geometry message from the
 * server(requires GetGeo command) to be able to proceed. We're asking about the
 * geometry of sonars to be able to establish correct angle and vector related
 * calculations.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "GeometryMessageRecieved", description = "Has the geometry module recieved a message yet?")
public class GeometryMessageRecieved extends StateSense<AirRobotContext, Boolean>
{
    public GeometryMessageRecieved(AirRobotContext ctx)
    {
        super("GeometryMessageRecieved", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("GotGeo?");
        //isReady returns false if there are no messages to get from the module
        return ctx.geoModule.isReady();
    }
}
