package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.agent.module.configuration.ConfigAerial;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ConfigType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.agent.module.geometry.GeoSensorEffecter;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorGroundTruth;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorINS;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorRange;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.ScanAreaAnalysis;

/**
 * Action that sets initial values, start positions and scanning plan. Using
 * POSH to do this in combination of collecting configuration and geometry data
 * is "spot on". We need to issue just one query at a time for the server not to
 * ignore multiple tasks.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "SetUpRobot", description = "Sets up basic and initial values.")
public class SetUpRobot extends StateAction<AirRobotContext>
{
    public SetUpRobot(AirRobotContext ctx)
    {
        super("SetUpRobot", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("setup");
        setUpRobot();
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
    
    /**
     * An order of messages recieved from the server can not be determined.
     * Thus, we have to check the availibility of all sensors we want to read.
     * Typically the order of the messages recieved could look like this:
     *
     * SEN laser; SEN ins; STA robot; SEN Ground; SEN Range;..
     *
     * Which would result in availibility of only two first sensors(laser and
     * ins) as the logic (and potentialy this method) is triggered with receipt
     * of the STA message.
     *
     * @return Returns true or false depending on the success of acquiring
     * complete sensor information.
     */
    public boolean acceptSensorMessage()
    {
        try
        {
            if(!ctx.senModule.isSensorReady(SensorType.LASER_SENSOR)
                    || !ctx.senModule.isSensorReady(SensorType.INS_SENSOR)
                    || !ctx.senModule.isSensorReady(SensorType.GROUND_TRUTH)
                    || !ctx.senModule.isSensorReady(SensorType.RANGE_SENSOR))
            {
                return false;
            }
            ctx.laser = (SensorLaser) ctx.senModule.getSensorsBySensorType(SensorType.LASER_SENSOR).get(0);
            ctx.ins = (SensorINS) ctx.senModule.getSensorsBySensorType(SensorType.INS_SENSOR).get(0);
            ctx.sonar = (SensorRange) ctx.senModule.getSensorsBySensorType(SensorType.RANGE_SENSOR).get(0);
            ctx.truth = (SensorGroundTruth) ctx.senModule.getSensorsBySensorType(SensorType.GROUND_TRUTH).get(0);
            return true;
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
            return false;
        }
    }
    
    /**
     * This obtains information about the robots maximal speeds, it computes the robot path according to the input scanning area.
     */
    public void setUpRobot()
    {
        acceptSensorMessage();
        ConfigAerial robotCfg = (ConfigAerial) ctx.confModule.getConfigurationsByConfigType(ConfigType.AERIAL_VEHICLE).get(0);
        //getParameters
        ctx.maxLateralVelocity = Double.parseDouble(robotCfg.getFeatureValueBy("MaxLateralVelocity"));
        ctx.maxLinearVelocity = Double.parseDouble(robotCfg.getFeatureValueBy("MaxLinearVelocity"));
        ctx.maxAltitudeVelocity = Double.parseDouble(robotCfg.getFeatureValueBy("MaxAltitudeVelocity"));
        ctx.maxRotationalVelocity = Double.parseDouble(robotCfg.getFeatureValueBy("MaxRotationalVelocity"));
        //set startLoc
        ctx.startLoc = ctx.ins.getLocation();
        //lets say that the start location will be our origin
        ctx.actLoc = Location.ZERO;
        ctx.prevLoc = Location.ZERO;
        ctx.previewForm.setStartLocation(Location.ZERO);        
        ctx.previewForm.setDatFile(ctx.scanHelper.shouldWriteDatFile);
        //get the closest Corner to begin the scan.
        ctx.nextLoc = ctx.scanHelper.getClosestCorner(Location.ZERO);
        if(ScanAreaAnalysis.isLargeSpace())
        {
            ctx.setupMultiple(ctx.multipleRunCount);
        }
        else
        {
            ctx.prepareForTakeof();
        }
        //lets set the initial parameters
        ctx.battFull = ctx.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        ctx.startTime = System.currentTimeMillis();//staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getTime();
        //saveGeometryOfSonars
        ctx.sonarGeo = ((GeoSensorEffecter) ctx.geoModule.getGeometriesByGeometryType(GeometryType.SENSOR_EFFECTER).get(0)).getSensorMountCollection();

        ctx.parametersObtained = true;
    }
}
