package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Sense for initial configuration, We need to recieve sensor message from the
 * server(requires time - few ticks - sometimes) to be able to proceed. The
 * sensor module works in a little different way than the geo and conf modules.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "SensorModuleReady", description = "Is the sensorModuel prepared and has the sensor module recieved a message yet?")
public class SensorModuleReady extends StateSense<AirRobotContext, Boolean>
{
    public SensorModuleReady(AirRobotContext ctx)
    {
        super("SensorModuleReady", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("SensorModuleReady");
        return ctx.senModule.isReady();
    }
}
