package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Action that issues a Command to the server asking about gemetry data of the
 * sonar sensor. This involves orientation and location. Using POSH to do this
 * in combination of collecting configuration and sensor data is "spot on". We
 * need to issue just one query at a time for the server not to ignore multiple
 * tasks.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "GetSonarGeometry", description = "Asks the server about postition and orientation of each sonar.")
public class GetSonarGeometry extends StateAction<AirRobotContext>
{
    public GetSonarGeometry(AirRobotContext ctx)
    {
        super("GetSonarGeometry", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("GetSonar");
        ctx.geoModule.queryGeometryByType("Sonar");
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
}
