package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveAerial;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

/**
 * Action that makes the robot go towards destination.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "PursueGoal", description = "Robot will go towards its detination.")
public class PursueGoal extends StateAction<AirRobotContext>
{
    public PursueGoal(AirRobotContext ctx)
    {
        super("PursueGoal", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("pursuegoal");
        ctx.issueNoRisk();
        pursueGoal();
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
    
     /**
     * System of setting lateral, linear, altitude and rotational speeds takes
     * place here. If the robot is close to the base, it has to slow down not to
     * descend out of desired location. Also when it is close to goal it stops
     * the forward movement for better dexterity.
     */
    public void pursueGoal()
    {
        ctx.scanning = (ctx.state == State.AVOIDING)?ctx.isScanning(ctx.tempState):ctx.isScanning(ctx.state);
        ctx.speed = (ctx.scanning)?ctx.scanningSpeed:ctx.flyingSpeed;
        ctx.rotSpeed = (ctx.scanning)?ctx.scanningSpeed:ctx.flyingSpeed * 2 / 3;

        double rotVel;
        double altVel;
        double linVel = ctx.maxLinearVelocity * ctx.speed;

        double diff = ctx.getTargetAngle(false);
        //směr zatáčení musí bejt ne podle dot, ale podle toho, jestli je úhel s osou menší než úhel s osou co svírá ten druhej vektor!!!
        rotVel = Math.signum(-diff) * Math.min(Math.abs((double) (ctx.maxRotationalVelocity * (-diff / 90))), ctx.rotSpeed);

        if(ctx.actLoc.z < ctx.scanHelper.seaLevel + 1 && ctx.actAlt > ctx.scanAltitude)//1 as a tolerance
        {
            altVel = (double) (ctx.maxAltitudeVelocity * (ctx.scanHelper.seaLevel - ctx.actLoc.z) / 6);
        }
        else
        {
            altVel = (double) (ctx.maxAltitudeVelocity * (ctx.altitude - ctx.actAlt) / 5);
        }
        //altVel = (double) ((actLoc.z < seaLevel)?(maxAltitudeVelocity * (seaLevel - actLoc.z) / 5):(maxAltitudeVelocity * (altitude - actAlt) / 5));//we don't want to go lower than some minimum value
        //altVel = Math.min(altVel, maxAltitudeVelocity / 4);//make sure that it wont take off too quickly
        if(ctx.state == State.AVOIDING || Location.getDistance2D(ctx.actLoc, ctx.nextLoc) < 2.7)
        {
            linVel = (Math.abs(rotVel) >= ctx.rotSpeed)?0:linVel;
        }
        else
        {
            linVel = (Math.abs(rotVel) >= ctx.rotSpeed)?linVel * 3 / 5:linVel;
        }
        ctx.hoverAvoiding = true;
        if(Math.abs(rotVel) >= ctx.rotSpeed)
        {
            ctx.noriskCount = Math.max(0, ctx.noriskCount - 1);
            if(ctx.state == State.AVOIDING)
            {
                ctx.hoverAvoiding = false;
            }
        }
        //landing - we have to slow down before falling
        if(ctx.state == State.TERMINATE || ctx.state == State.CHARGE)
        {
            linVel *= Math.min((Location.getDistance2D(ctx.actLoc, ctx.nextLoc)) / 6, 1);
        }
        altVel = (Math.abs(rotVel) >= ctx.rotSpeed)?0:altVel;
        ctx.getAct().act(new DriveAerial(altVel, linVel, 0, rotVel, false));
    }
}
