/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot;

/**
 * This class is best used for empty calls of the logic method. The wait metod
 * will remember the time of the firs call and every other call it will check if
 * the time passed since the first call is greater than the timeSpan defined.
 * Once the timeSpan is exceeded it will return true. There is resetTime method
 * to reset the remembered time, so it can be used again.
 *
 * @author vejmanm
 */
public class Wait
{
    static double timeStart = -1;

    /**
     * Once the method is called it uses inner variable to determine when it was
     * called for the first time and every other call it checks if the time
     * passed from the beginning is greater than the input variable timeSpan.
     *
     * @param time - actual time from the USARSim server.
     * @param timeSpan - time interval that should pass from the first calling
     * of this method to its last call
     * @return returns false if the time passed is less than timeSpan and true
     * if it is greater.
     */
    public static boolean wait(double time, double timeSpan)
    {
        if(timeStart == -1)
        {
            timeStart = time;
        }
        else if(time - timeStart > timeSpan)
        {
            return true;
        }
        return false;
    }

    /**
     * Resets this classes properties for the wait method to be used again.
     */
    public static void resetTime()
    {
        timeStart = -1;
    }

    /**
     * Once the wait method has been called this method will return false. If
     * resetTime() is called this will return true again;
     *
     * @return Returns true if a wait metod has been called more than once and
     * resetTime was not called since.
     */
    public static boolean isInUse()
    {
        return timeStart > -1;
    }
}
