package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Sense that tells us wether the robot is near enough to its destination or
 * not.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "TargetReached", description = "Has the robot reached its destination?")
public class TargetReached extends StateSense<AirRobotContext, Boolean>
{
    public TargetReached(AirRobotContext ctx)
    {
        super("TargetReached", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("targetReached");
        return hasReachedTarget(ctx.actLoc, ctx.nextLoc);
    }
    
    /**
     * We use minimal deviation constant to allow robot to be just near its
     * goal. The INS noise would cause the robot to spin around when the
     * acceptable distance was too close.
     *
     * @param actual Actual position of the robot
     * @param target Goal position.
     * @return Returns true if the robot is within acceptable distance from its
     * target.
     */
    public boolean hasReachedTarget(Location actual, Location target)
    {
        if(Location.getDistance2D(actual, target) > ctx.minDev)
        {
            return false;
        }
        return true;
    }
}
