package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.*;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.Record;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.ToolBox;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Sense for initial configuration, geometry and sensor data receipt. The
 * logic/plan has to be executed several times before complte information is
 * acquired
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "RobotReady", description = "Is there enough battery to continue?")
public class RobotReady extends StateSense<AirRobotContext, Boolean>
{
    public RobotReady(AirRobotContext ctx)
    {
        super("RobotReady", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("RobotReady");
        boolean robotReady = ctx.parametersObtained;
        if(robotReady)
        {
            acceptSensorMessages();
        }
        return robotReady;
    }
    
     /**
     * Gets all sensor messages queued from the last logic call.
     
     * @return Returns true false if the sensor messages ain't ready. False otherwise.
     */
    public boolean acceptSensorMessages()
    {
        List<SuperSensor> lasers;
        List<SuperSensor> inses;
        List<SuperSensor> sonars;
        List<SuperSensor> truths;
        int minIndex;
        lasers = ctx.senModule.getSensorsBySensorType(SensorType.LASER_SENSOR);
        inses = ctx.senModule.getSensorsBySensorType(SensorType.INS_SENSOR);
        sonars = ctx.senModule.getSensorsBySensorType(SensorType.RANGE_SENSOR);
        truths = ctx.senModule.getSensorsBySensorType(SensorType.GROUND_TRUTH);

        minIndex = ToolBox.getMin(lasers.size(), inses.size(), sonars.size(), truths.size());
        if(minIndex < 1)
        {
            return false;
        }

        //if there's more of 'em in the queue due to slow update cycles
        for(int i = 0; i < minIndex; i++)
        {
            ctx.laser = (SensorLaser) lasers.get(i);
            ctx.truth = (SensorGroundTruth) truths.get(i);
            ctx.ins = (SensorINS) inses.get(i);
            ctx.sonar = (SensorRange) sonars.get(i);
            refreshScanProcedure();
        }


        //don't need to update theese with such quality
        setSonarPreview(ctx.sonar.getRanges());
        setInfos();//update form
        issueInfos();//suck new data
        return true;
    }
    
     /**
     * Each cycle some data is passed to the preview form to be shown and some
     * to be saved along with scan image.
     */
    public void issueInfos()
    {
        if(ctx.state == null)
        {
            return;
        }
        addInfoToShow("Robot State", ctx.state.toString());
        addInfoToShow("Time Elapsed", ToolBox.getTime(System.currentTimeMillis() - ctx.startTime));
        addInfoToShow("\nnoRiskCount", String.valueOf(ctx.noriskCount));
        addInfoToShow("riskCount", String.valueOf(ctx.riskCount));
        //battery related stuff

        double battUsed = ctx.battFull - ctx.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        double range = (ctx.battLife - battUsed) * (ctx.trip / battUsed);
        double distanceFromHome = Location.getDistance2D(ctx.actLoc, Location.ZERO);
        addInfoToShow("\nBatteryLife", String.valueOf(ctx.battLife));
        addInfoToShow("BatteryUsed", String.valueOf(battUsed));
        addInfoToShow("Battery Cycles", String.valueOf(ctx.battFills));
        addInfoToShow("\nDistance From Home", ToolBox.getTwoDecimalPlaces(distanceFromHome));
        addInfoToShow("Distance From Next", ToolBox.getTwoDecimalPlaces(Location.getDistance2D(ctx.actLoc, ctx.nextLoc)));
        addInfoToShow("Range", ToolBox.getTwoDecimalPlaces(range));
        //to save along with a scan preview image
        addInfoToSave("Elapsed: ", ToolBox.getTime(System.currentTimeMillis() - ctx.startTime));
        addInfoToSave("Battery Cycles", String.valueOf(ctx.battFills));

    }
    
    /**
     * Helper method for preview of sonar states in corret order.
     *
     * @param sonars Sonar data from sensor module.
     */
    public void setSonarPreview(Map<String, Double> sonars)
    {
        List<Double> sonarValues = new LinkedList<Double>();
        for(int i = 0; i < sonars.size(); i++)
        {
            sonarValues.add(sonars.get(ctx.sonarOrder[i]));
        }
        ctx.previewForm.setSonars(sonarValues);
    }

    /**
     * Helper mehtod for transfering info about scanning to preview form.
     */
    public void setInfos()
    {
        ctx.previewForm.setInfo(infoToShow.toString());
        ctx.previewForm.setPostInfo(infoToSave.toString());
        infoToShow.delete(0, Math.max(infoToShow.length(), 0));
        infoToSave.delete(0, Math.max(infoToSave.length(), 0));
    }

    /**
     * Transfers sensor data and invalidates the preview JForm.
     */
    public void refreshScanProcedure()
    {
        ctx.actLoc = Location.sub(ctx.startLoc, ctx.ins.getLocation());//Location.sub(startLoc, truth.getLocation());//
        ctx.actRot = ctx.ins.getOrientation();//truth.getOrientation();//

        ctx.checkAltitudeFromLaser();

        ctx.previewForm.setRecord(new Record(ctx.laser.getRanges(), null, ctx.laser.getFOV()));
        ctx.previewForm.setLocation(ctx.actLoc);
        ctx.previewForm.setOrientation(ctx.actRot);
        ctx.previewForm.refreshGraphics();
    }
    
    /**
     * Helper method for queuing information to show on the preview form.
     *
     * @param name Name of some property.
     * @param value Value of the property.
     */
    public void addInfoToShow(String name, String value)
    {
        infoToShow.append("\n").append(name).append(": ").append(value);
    }

    /**
     * Helper method for queuing information to save along with scan image by
     * the preview form.
     *
     * @param name Name of some property.
     * @param value Value of the property.
     */
    public void addInfoToSave(String name, String value)
    {
        infoToSave.append("\n").append(name).append(": ").append(value);
    }

    StringBuilder infoToShow = new StringBuilder();
    StringBuilder infoToSave = new StringBuilder();
}
