package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.SensorMount;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.RiskLevel;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.ToolBox;
import java.util.Map;

/**
 * Action that directs the robot away from an obstacle. This action is a reponse
 * to Low risk level thread.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "ComputeDiversion", description = "Robot will try to get away from obstacle.")
public class ComputeDiversion extends StateAction<AirRobotContext>
{
    public ComputeDiversion(AirRobotContext ctx)
    {
        super("ComputeDiversion", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
//        System.out.println("IssueLow");
        issueLowRisk();
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }

    /**
     * This will cause the robot to compute a diversion point in the most open
     * direction.
     */
    public void issueLowRisk()
    {
        if(ctx.hoverAvoiding)
        {
            computeDiversion(ctx.sonar.getRanges());
            ctx.noriskCount = 0;
            ctx.previewForm.setLowRiskPoint(ctx.actLoc);
        }
        ctx.riskCount++;
    }

    /**
     * Triggered by robot being close to an obstacle. Computes the most
     * advantageous direction based on sonar ring.
     */
    public void computeDiversion(Map<String, Double> sonars)
    {
        //kounknout kde všude jsou překážky a vypočítat bod, kterej je vedle překážky a kam se robot ještě vejde aniž by se dostal do HighRisk
        //mám paprsek, kde je místa nejmíň, tak kouknu na ty od něj doleva a od něj doprava, sečtu všechny hodnoty a podělim je počtem senzorů a 
        //vyberu potom bod, kde je první volenj, ale asi taky se skreslením-udělám váženej průměr totiž!
        boolean leftSide = true;
        double leftWM = 0;//left weighted mean
        double rightWM = 0;//right weighted mean
        double leftFittest = 0;
        double rightFittest = 0;
        int leftFindex = 0;
        int rightFindex = 0;
        String greatestThreat = ctx.getGreatestRiskSensor(sonars);

        //int targetIndex=getSonarTargetIndex(); //computes the index of the sonar that is closest to target direction
        //targetIndex ensures that the robot wont be influenced by minor disturbances

        int greatestRiskIndex = -1;
        for(int i = 0; i < sonars.size(); i++)
        {
            Double entry = sonars.get(ctx.sonarOrder[i]);//order of entries does matter at this point
            if(ctx.sonarOrder[i].equals(greatestThreat))
            {
                greatestRiskIndex = i;
                leftSide = false;
                continue;
            }

            //computes the odds left and right from the sonar with greatest risk
            if(leftSide)
            {
                leftWM += entry * entry;//lets get the mean from the second power - it will ensure, that one inf.(>4.8) ray is valued better than six finite.(<4.8)
                if(leftFittest < entry || entry > ctx.sonarThreashold)//we want the closest open direction to the occupied as possible
                {
                    leftFittest = entry;
                    leftFindex = i;
                }
            }
            else
            {
                rightWM += entry * entry;
                //we want the first open direction or the best possible
                if(rightFittest < entry && rightFittest < ctx.sonarThreashold)
                {
                    rightFittest = entry;
                    rightFindex = i;
                }
            }
        }
        if(leftWM < rightWM)
        {
            if(rightFindex < 7 && sonars.get(ctx.sonarOrder[rightFindex - 1]) < 2.5d)
            {
                RiskLevel righterRisk = ctx.getRiskLevel(ctx.sonarOrder[rightFindex + 2], sonars.get(ctx.sonarOrder[rightFindex + 2]));
                if(righterRisk == RiskLevel.NORISK)
                {
                    rightFindex += 2;
                }
            }
            //když to neni na kraji, tak to bere druhej nejlepší paprsek, ještě by se dal dát
            else if(/*
                     * rightFindex - greatestRiskIndex == 1 &&
                     */rightFindex < 8)
            {//ale musíme se ujistit, že tím dalším směrem nás nečeká žádná překážka
                RiskLevel righterRisk = ctx.getRiskLevel(ctx.sonarOrder[rightFindex + 1], sonars.get(ctx.sonarOrder[rightFindex + 1]));
                if(righterRisk == RiskLevel.NORISK)
                {
                    rightFindex++;
                }
            }
            int targetIndex = getSonarTargetIndex();
            if(targetIndex > rightFindex && targetIndex < 8)
            {
                RiskLevel targetRiskLevel = ctx.getRiskLevel(ctx.sonarOrder[targetIndex], sonars.get(ctx.sonarOrder[targetIndex]));
                if(targetRiskLevel == RiskLevel.NORISK)
                {
                    //vlastně nepotřebujem měnit směr
                    rightFindex = targetIndex;
                    ctx.tryReleaseDiversion();
                    return;
                }
            }
            setDiversionPoint(rightFindex, rightFittest);
        }
        else
        {
            if(leftFindex > 1 && sonars.get(ctx.sonarOrder[leftFindex + 1]) < 1.5d)
            {
                RiskLevel lefterRisk = ctx.getRiskLevel(ctx.sonarOrder[leftFindex - 2], sonars.get(ctx.sonarOrder[leftFindex - 2]));
                if(lefterRisk == RiskLevel.NORISK)
                {
                    leftFindex -= 2;
                }
            }
            else if(/*
                     * greatestRiskIndex - leftFindex == 1 &&
                     */leftFindex > 0)
            {
                RiskLevel lefterRisk = ctx.getRiskLevel(ctx.sonarOrder[leftFindex - 1], sonars.get(ctx.sonarOrder[leftFindex - 1]));
                if(lefterRisk == RiskLevel.NORISK)
                {
                    leftFindex--;
                }
            }
            int targetIndex = getSonarTargetIndex();
            if(targetIndex < leftFindex && targetIndex > 0)
            {
                RiskLevel targetRiskLevel = ctx.getRiskLevel(ctx.sonarOrder[targetIndex], sonars.get(ctx.sonarOrder[targetIndex]));
                if(targetRiskLevel == RiskLevel.NORISK)
                {
                    leftFindex = targetIndex;
                    ctx.tryReleaseDiversion();
                    return;
                }
            }
            setDiversionPoint(leftFindex, leftFittest);
        }
    }

    /**
     * If the robot faces the goal this gets the index of sonar that points
     * closest to this direction.
     *
     * @return returns a sonar index, that points to goal direction.
     */
    public int getSonarTargetIndex()
    {
        int sonarIndex = -1;
        int count = 0;
        double v1Theta = ctx.getTargetAngle(true) / 180 * Math.PI;
        double minDiv = 7;//2*PI
        for(SensorMount sensorMount : ctx.sonarGeo)
        {
            if(minDiv > Math.abs(v1Theta - sensorMount.getOrientation().yaw))
            {
                minDiv = Math.abs(v1Theta - sensorMount.getOrientation().yaw);
                sonarIndex = count;
            }
            count++;
        }
        return sonarIndex;
    }

    /**
     * Sets a diversion point in a direction of the fittest sonar based on its
     * index.
     *
     * @param index index of the sonar sensor.
     * @param fittest fittest value obtained from sonar sensor.
     */
    public void setDiversionPoint(int index, double fittest)
    {
        Rotation sonarRot = ctx.sonarGeo.get(index).getOrientation();
        String greatestThreat = ctx.getGreatestRiskSensor(ctx.sonar.getRanges());
        //if its left side sonar give it +0.3 rad to go further from an obstacle. if it is right lets give it -0.3 for the same reason
        double angle = Math.PI / 2 - (sonarRot.yaw + ctx.actRot.yaw) + ((greatestThreat.charAt(0) == 'L')?-0.3:(greatestThreat.charAt(0) == 'R')?0.3:0);
        Location actDiv = new Location(-Math.sin(angle) * fittest, -Math.cos(angle) * fittest);
        Location diversion = ctx.actLoc.add(actDiv);
        ctx.previewForm.setDivPoint(diversion);
        if(ctx.state != State.AVOIDING)
        {
            ctx.tempState = ctx.state;
            ctx.tempNextLoc = ctx.nextLoc;
        }

        ctx.state = State.AVOIDING;
        ctx.nextLoc = diversion;
    }
}
