/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ConfigMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.GeometryMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ResponseModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.SensorMasterModuleQueued;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.StateMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorGroundTruth;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorINS;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorRange;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.SensorMount;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.SetSensorEffecter;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.ScanAreaAnalysis;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.Wait;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.RiskLevel;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.ScanPreview;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.ToolBox;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class AirRobotContext
extends USAR2004Context<USAR2004Bot> {
    public SensorMasterModuleQueued senModule;
    public GeometryMasterModule geoModule;
    public ConfigMasterModule confModule;
    public ResponseModule resModule;
    public StateMasterModule staModule;
    public ScanPreview previewForm = null;
    public ScanAreaAnalysis scanHelper = new ScanAreaAnalysis();
    public SensorLaser laser;
    public SensorGroundTruth truth;
    public SensorINS ins;
    public SensorRange sonar;
    public double maxLateralVelocity;
    public double maxLinearVelocity;
    public double maxAltitudeVelocity;
    public double maxRotationalVelocity;
    public Location startLoc;
    public List<SensorMount> sonarGeo;
    public long startTime;
    public State state = State.DEFAULT;
    public State tempState = null;
    public State stallState = null;
    public final double scanAltitude = 6.0;
    public double altitude = 6.0;
    public int multipleRunCount = 0;
    public final int battLife = 500;
    public int battFills = 0;
    public int battFull;
    public Location actLoc;
    public Location prevLoc;
    public Location nextLoc;
    public Location stallActLoc;
    public Location stallNextLoc;
    public Location tempNextLoc;
    public double minDev = 0.9;
    public double actAlt = 0.0;
    public Rotation actRot;
    public double trip = 0.0;
    public boolean parametersObtained = false;
    public boolean risen = false;
    public final double rangeCoeficient = 0.85;
    public int noriskCount = 0;
    public int riskCount = 0;
    public boolean hoverAvoiding = true;
    public final double sonarThreashold = 4.91;
    public final Map<String, Double> highRisk = new HashMap<String, Double>(){
        {
            this.put("L4", 0.47);
            this.put("R4", 0.47);
            this.put("L3", 0.61);
            this.put("R3", 0.61);
            this.put("L2", 0.86);
            this.put("R2", 0.86);
            this.put("L1", 1.22);
            this.put("R1", 1.22);
            this.put("M0", 1.5);
        }
    };
    public final Map<String, Double> lowRisk = new HashMap<String, Double>(){
        {
            this.put("L4", 1.57);
            this.put("R4", 1.57);
            this.put("L3", 1.91);
            this.put("R3", 1.91);
            this.put("L2", 2.72);
            this.put("R2", 2.72);
            this.put("L1", 3.5);
            this.put("R1", 3.5);
            this.put("M0", 4.2);
        }
    };
    public final String[] sonarOrder = new String[]{"L4", "L3", "L2", "L1", "M0", "R1", "R2", "R3", "R4"};
    public boolean scanning = false;
    public final double scanningSpeed = 0.2;
    public final double flyingSpeed = 0.35;
    public double speed = 0.0;
    public double rotSpeed = 0.0;
    public final int dockWaitPenalty = 8;
    public final int numOfRays = 10;
    public final int jammedLimit = 17;

    public AirRobotContext(USAR2004Bot bot) {
        super("AirRobotContext", bot);
        this.initialize();
        this.initForm();
        this.initModules();
    }

    public void initModules() {
        this.senModule = SensorMasterModuleQueued.getModuleInstance((USAR2004Bot)((USAR2004Bot)this.bot));
        this.geoModule = GeometryMasterModule.getModuleInstance((USAR2004Bot)((USAR2004Bot)this.bot));
        this.confModule = ConfigMasterModule.getModuleInstance((USAR2004Bot)((USAR2004Bot)this.bot));
        this.resModule = ResponseModule.getModuleInstance((USAR2004Bot)((USAR2004Bot)this.bot));
        this.staModule = StateMasterModule.getModuleInstance((USAR2004Bot)((USAR2004Bot)this.bot));
    }

    public void initForm() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AirRobotContext.this.previewForm = new ScanPreview();
                    AirRobotContext.this.previewForm.runScanPreview();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        System.out.println("Form set to be initialized.");
    }

    public void setupMultiple(int multipleRunCount) {
        this.scanHelper.setNextDestination(multipleRunCount);
        if (multipleRunCount < 4) {
            this.resetINS();
            this.nextLoc = this.scanHelper.getClosestCorner(Location.ZERO);
            this.state = State.DEFAULT;
            ++this.multipleRunCount;
            this.prepareForTakeof();
        } else {
            this.altitude = 0.0;
        }
    }

    public void prepareForTakeof() {
        this.risen = false;
        ++this.battFills;
        double battUsed = this.battFull - this.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        double range = (500.0 - battUsed) * (this.trip / battUsed);
        System.out.println("range left: " + range + " trip odometer: " + this.trip + " battery used: " + battUsed);
        this.battFull = this.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        this.trip = 0.0;
        this.altitude = 6.0;
        Wait.resetTime();
    }

    public void resetINS() {
        try {
            Location truthLoc = this.truth.getLocation();
            Rotation truthRot = this.truth.getOrientation();
            this.previewForm.setStartLocation(Location.sub((Location)this.startLoc, (Location)truthLoc.getLocation()));
            StringBuilder sb = new StringBuilder();
            sb.append(truthLoc.x).append(',').append(truthLoc.y).append(',').append(truthLoc.z).append(',');
            sb.append(truthRot.roll).append(',').append(truthRot.pitch).append(',').append(truthRot.yaw);
            ((USAR2004Bot)this.bot).getAct().act((CommandMessage)new SetSensorEffecter("INS", "INS", "POSE", sb.toString()));
        }
        catch (Exception e) {
            System.out.println("Error reseting INS");
        }
    }

    public void setStallState() {
        this.stallState = this.state;
        this.stallNextLoc = this.nextLoc;
        this.stallActLoc = Location.getDistance2D((Location)this.actLoc, (Location)this.nextLoc) < 15.0 ? this.nextLoc : this.actLoc;
    }

    public void setRechargePoint() {
        this.state = State.CHARGE;
        this.nextLoc = Location.ZERO;
        this.minDev = 1.5;
        this.previewForm.setRechargeBreakPoint(this.actLoc);
    }

    public double getTargetAngle(boolean actual) {
        double v1y;
        double v1x;
        if (actual && this.state == State.AVOIDING && this.tempNextLoc != null) {
            v1x = this.tempNextLoc.x - this.actLoc.x;
            v1y = this.tempNextLoc.y - this.actLoc.y;
        } else {
            v1x = this.nextLoc.x - this.actLoc.x;
            v1y = this.nextLoc.y - this.actLoc.y;
        }
        double v1l = Math.sqrt(v1x * v1x + v1y * v1y);
        double sinv1 = v1y / v1l;
        double cosv1 = v1x / v1l;
        double v1Theta = (ToolBox.getAngle((double)sinv1, (double)cosv1) + 180.0) % 360.0;
        double v2Theta = this.actRot.yaw * 180.0 / Math.PI;
        double diff = v2Theta - v1Theta;
        if (diff > 180.0) {
            diff -= 360.0;
        } else if (diff < -180.0) {
            diff += 360.0;
        }
        return diff;
    }

    public void issueNoRisk() {
        ++this.noriskCount;
        if (this.noriskCount > 3) {
            this.tryReleaseDiversion();
        }
        if (this.noriskCount > 15) {
            this.riskCount = 0;
        }
    }

    public void tryReleaseDiversion() {
        if (this.state == State.AVOIDING || this.state == State.AVOIDED) {
            if (this.tempState == null) {
                System.out.println("tempState == null");
            } else {
                this.state = this.tempState;
            }
            this.nextLoc = this.tempNextLoc;
        }
    }

    public String getGreatestRiskSensor(Map<String, Double> sonars) {
        RiskLevel globalRisk = RiskLevel.NORISK;
        double riskValue = 4.91;
        String riskName = null;
        for (Map.Entry<String, Double> entry : sonars.entrySet()) {
            RiskLevel risk = this.getRiskLevel(entry.getKey(), entry.getValue());
            if (risk.isGreaterRisk(globalRisk)) {
                globalRisk = risk;
                riskValue = entry.getValue();
                riskName = entry.getKey();
                continue;
            }
            if (risk != globalRisk || !(entry.getValue() < riskValue)) continue;
            riskValue = entry.getValue();
            riskName = entry.getKey();
        }
        return riskName;
    }

    public RiskLevel getRiskLevel(String sonar, double value) {
        if (value < this.highRisk.get(sonar)) {
            return RiskLevel.HIGHRISK;
        }
        if (value < this.lowRisk.get(sonar)) {
            return RiskLevel.LOWRISK;
        }
        return RiskLevel.NORISK;
    }

    public boolean isScanning(State state) {
        return state == State.LONGFORTH || state == State.SHORTFORTH || state == State.LONGBACK || state == State.SHORTBACK;
    }

    public boolean isLanding() {
        return this.state == State.CHARGING || this.state == State.LAND;
    }

    public void computeNext(State state) {
        switch (state) {
            case DEFAULT: 
            case LONGFORTH: {
                this.nextLoc = this.nextLoc.add(this.scanHelper.longStep);
                break;
            }
            case SHORTFORTH: 
            case SHORTBACK: {
                this.nextLoc = this.nextLoc.add(this.scanHelper.shortStep);
                if (this.scanHelper.cycle >= this.scanHelper.cycleStop) {
                    this.state = State.TERMINATE;
                    this.nextLoc = new Location(0.0, 0.0, 0.0);
                }
                ++this.scanHelper.cycle;
                break;
            }
            case LONGBACK: {
                this.nextLoc = this.nextLoc.sub(this.scanHelper.longStep);
                break;
            }
            case TERMINATE: {
                break;
            }
            case LAND: 
            case CHARGING: {
                this.altitude = 0.0;
                break;
            }
            case CONTINUED: {
                this.continueScanning();
                break;
            }
            case AVOIDED: {
                this.tryReleaseDiversion();
                break;
            }
            default: {
                System.out.println("Unexpected STATE");
            }
        }
    }

    public void continueScanning() {
        if (this.stallState == null) {
            return;
        }
        this.state = this.stallState;
        this.nextLoc = this.stallNextLoc;
        this.minDev = 0.9;
    }

    public void checkAltitudeFromLaser() {
        int offset = (int)(this.actRot.roll >= Math.PI ? 360.0 - this.actRot.roll * 180.0 / Math.PI : -this.actRot.roll * 180.0 / Math.PI);
        double avgRange = this.laser.getNMidAvg(10, offset);
        this.actAlt = Math.cos(this.actRot.pitch) * avgRange;
        this.previewForm.setOffset(offset);
    }
}

