package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveAerial;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.ScanAreaAnalysis;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.Wait;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

/**
 * Action that makes the robot go towards ground wait and reset.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "DockRobot", description = "Robot will go straight down.")
public class DockRobot extends StateAction<AirRobotContext>
{
    public DockRobot(AirRobotContext ctx)
    {
        super("DockRobot", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        try
        {
            //System.out.println("Dock");
            ctx.issueNoRisk();
            dockRobot();
            return ActionResult.FINISHED;
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
            return ActionResult.FAILED;
        }
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
    
    /**
     * This will cause the robot to land and to charge its battery and reset the INS sensor.
     */
    public void dockRobot()
    {
        double altVel;
        //System.out.println("altVehicle");
        altVel = (double) (ctx.maxAltitudeVelocity * (ctx.altitude - ctx.actAlt) / 5);
        //landed - we don't need to correct the position while falling
        if(ctx.isLanding())
        {
            ctx.getAct().act(new DriveAerial(altVel, 0, 0, 0, false));
        }
        //System.out.println("after isLanding");
        //scanning = (state == State.AVOIDING)?isScanning(tempState):isScanning(state);
        double time = ctx.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getTime();
        //System.out.println("altTime");
        if(Wait.wait(time, ctx.dockWaitPenalty))
        {            
            //System.out.println("waited");
            if(ctx.state == State.CHARGING)
            {
                setResumeState();
                //System.out.println("altsetResume");
            }
            else if(ScanAreaAnalysis.isLargeSpace())
            {
                ctx.setupMultiple(ctx.multipleRunCount);
            }
        }
        //System.out.println("altDocked");
    }
    
     /**
     * sets up necessary variables to resume scan procedure Resets INS position
     * and rotation according to groundTruth - simulation of recharging and
     * sensor reset.
     *
     */
    public void setResumeState()
    {
        ctx.resetINS();
        System.out.println("afterINSReset");
        ctx.state = State.CONTINUE;
        if(ctx.stallActLoc == null)
        {
            return;
        }
        ctx.nextLoc = ctx.stallActLoc;
        if(ctx.tempState != null)
        {
            System.out.println("stallActLoc: " + ctx.stallActLoc.toString());
            System.out.println("tempState: " + ctx.tempState.toString());
        }
        else
        {
            System.out.println("stallActLoc: " + ctx.stallActLoc.toString());
            System.out.println("tempState is null");
        }
        System.out.println("afterInfoIssued");
        //stallActLoc = null;
        //tempState = null;
        ctx.prepareForTakeof();
        System.out.println("altPrepareForTakeof");
    }
}
