/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.submarinerobot;

import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.configuration.ConfigMissionPackage;
import cz.cuni.amis.pogamut.usar2004.agent.module.configuration.ConfigNautic;
import cz.cuni.amis.pogamut.usar2004.agent.module.configuration.ConfigSensor;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ConfigType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.agent.module.logic.USAR2004BotLogicController;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ConfigMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.SensorMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.StateMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.agent.module.state.SuperState;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveNautic;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.MissionPackage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.SetCamera;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.utils.USAR2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;

@AgentScoped
public class SubmarineRobot
extends USAR2004BotLogicController<USAR2004Bot> {
    private final double descendingLatch = 0.05f;
    private final double descendingRate = 0.5;
    private final double steerRate = 0.4f;
    private final int submarineLevel = 4;
    private double maxRudderAngle = 0.0;
    private double maxSternPlaneAngle = 0.0;
    private double maxPropellerSpeed = 0.0;
    private double cameraMaxFov = 0.0;
    private double cameraMinFov = 0.0;
    private double cameraActFov = 0.0;
    private double cameraInc = 0.01f;
    private String cameraName = "";
    private String cameraType = "";
    private double laserRange = 0.0;
    private double laserTime = 0.0;
    private double previousLaserRange = 0.0;
    private double previousLaserTime = 0.0;
    private double cameraRotationSpeed = 0.0;
    private double cameraTilt = 0.0;
    private double cameraTiltInc = this.cameraInc;
    private double cameraMaxTilt = 0.0;
    private double cameraMinTilt = 0.0;
    private String mispkgName = "";
    private double time = 0.0;
    private SensorMasterModule senModule;
    private ConfigMasterModule confModule;
    private StateMasterModule staModule;

    public void robotInitialized(NfoMessage nfom) {
        super.robotInitialized(nfom);
        this.logicInitialize((LogicModule)this.logicModule);
        this.initRobot();
        System.out.println(this.logicModule.isRunning());
    }

    public void initializeController(USAR2004Bot bot) {
        super.initializeController(bot);
    }

    private void initRobot() {
        Location startLoc = new Location(229.31, -651.48, 12.42);
        Initialize init = new Initialize("USARBot.Submarine", "Submarine sample robot", startLoc, Rotation.ZERO);
        this.bot.getAct().act((CommandMessage)init);
    }

    public void logic() throws PogamutException {
        super.logic();
        this.obtainLaserRange();
        double steer = 0.0;
        steer = this.time % 200.0 < 100.0 ? (double)0.4f : (double)-0.4f;
        if (this.laserRange > 4.0) {
            double desc = 0.0;
            if (this.previousLaserRange - this.laserRange < (double)0.05f) {
                desc = 0.5;
                steer = 0.0;
            }
            this.bot.getAct().act((CommandMessage)new DriveNautic(this.maxPropellerSpeed, this.maxRudderAngle * steer, this.maxSternPlaneAngle * desc, false, false));
        } else {
            double desc = 0.0;
            if (this.previousLaserRange - this.laserRange > 0.0) {
                desc = 0.5;
                steer = 0.0;
            }
            if (this.laserRange < 0.5) {
                this.bot.getAct().act((CommandMessage)new DriveNautic(this.maxPropellerSpeed, this.maxRudderAngle * -Math.signum(steer), -this.maxSternPlaneAngle, false, false));
            } else {
                this.bot.getAct().act((CommandMessage)new DriveNautic(this.maxPropellerSpeed, this.maxRudderAngle * steer, -this.maxSternPlaneAngle * desc, false, false));
            }
        }
        System.out.println(this.laserRange);
        System.out.println(this.previousLaserRange);
        System.out.println(this.time);
        this.time = ((SuperState)this.staModule.getStatesByClass(SuperState.class).get(0)).getTime();
        if (!this.getConfig()) {
            return;
        }
        this.zoomCamera();
        this.rotateCamera();
    }

    private void rotateCamera() {
        if (this.cameraTilt >= this.cameraMaxTilt || this.cameraTilt <= this.cameraMinTilt) {
            this.cameraTiltInc *= -1.0;
        }
        this.cameraTilt += this.cameraTiltInc;
        int[] links = new int[]{1, 2};
        double[] values = new double[]{this.cameraRotationSpeed, this.cameraTilt};
        int[] orders = new int[]{1, 0};
        this.bot.getAct().act((CommandMessage)new MissionPackage(this.mispkgName, links, values, orders));
    }

    private void zoomCamera() {
        if (this.cameraActFov >= this.cameraMaxFov || this.cameraActFov <= this.cameraMinFov) {
            this.cameraInc *= -1.0;
        }
        this.cameraActFov += this.cameraInc;
        this.bot.getAct().act((CommandMessage)new SetCamera(this.cameraType, this.cameraName, Double.valueOf(this.cameraActFov)));
    }

    private void obtainLaserRange() {
        if (!this.senModule.isReady().booleanValue()) {
            return;
        }
        if (this.senModule.getSensorsBySensorType(SensorType.LASER_SENSOR).size() > 0) {
            SensorLaser range = (SensorLaser)this.senModule.getSensorsBySensorType(SensorType.LASER_SENSOR).get(0);
            this.previousLaserTime = this.laserTime;
            this.laserTime = range.getTime();
            if (this.previousLaserTime != this.laserTime) {
                this.previousLaserRange = this.laserRange;
            }
            this.laserRange = range.getRangeAt(0);
        }
    }

    private boolean getConfig() {
        if (!this.confModule.isReady().booleanValue()) {
            this.confModule.queryConfigurationByType("Robot");
            return false;
        }
        if (this.confModule.getNonEmptyDescription().size() < 2) {
            this.confModule.queryConfigurationByType("Camera");
            return false;
        }
        if (this.confModule.getNonEmptyDescription().size() < 3) {
            this.confModule.queryConfigurationByType("MisPkg");
            return false;
        }
        ConfigNautic robotCfg = (ConfigNautic)this.confModule.getConfigurationsByConfigType(ConfigType.NAUTIC_VEHICLE).get(0);
        for (String feature : robotCfg.getFeatureNames()) {
            System.out.println(feature + ": " + robotCfg.getFeatureValueBy(feature));
        }
        ConfigSensor cameraCfg = (ConfigSensor)this.confModule.getConfigurationsByType("Camera").get(0);
        for (String feature : cameraCfg.getFeatureNames()) {
            System.out.println(feature + ": " + cameraCfg.getFeatureValueBy(feature));
        }
        ConfigMissionPackage mispkgConfig = (ConfigMissionPackage)this.confModule.getConfigurationsByConfigType(ConfigType.MISSION_PACKAGE).get(0);
        this.maxRudderAngle = Float.parseFloat(robotCfg.getFeatureValueBy("MaxRudderAngle"));
        this.maxSternPlaneAngle = Float.parseFloat(robotCfg.getFeatureValueBy("MaxSternPlaneAngle"));
        this.maxPropellerSpeed = Float.parseFloat(robotCfg.getFeatureValueBy("MaxPropellerSpinSpeed"));
        this.cameraMaxFov = Float.parseFloat(cameraCfg.getFeatureValueBy("CameraMaxFov"));
        this.cameraMinFov = Float.parseFloat(cameraCfg.getFeatureValueBy("CameraMinFov"));
        this.cameraActFov = Float.parseFloat(cameraCfg.getFeatureValueBy("CameraDefFov"));
        this.cameraName = cameraCfg.getName();
        this.cameraType = cameraCfg.getType();
        this.mispkgName = mispkgConfig.getName();
        this.cameraRotationSpeed = mispkgConfig.getMaxSpeedAt(0);
        this.cameraMaxTilt = mispkgConfig.getMaxRangeAt(1);
        this.cameraMinTilt = mispkgConfig.getMinRangeAt(1);
        return true;
    }

    public void prepareBot(USAR2004Bot bot) {
        super.prepareBot(bot);
        this.senModule = SensorMasterModule.getModuleInstance((USAR2004Bot)bot);
        this.confModule = ConfigMasterModule.getModuleInstance((USAR2004Bot)bot);
        this.staModule = StateMasterModule.getModuleInstance((USAR2004Bot)bot);
    }

    public static void main(String[] args) {
        new USAR2004BotRunner(SubmarineRobot.class, "PogamutBotBot", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.WARNING).startAgent();
    }
}

