package actions;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.examples.sposhp2dxrobot.P2DXContext;

/**
 * Action that causes robot to move to the side.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "DriveLeft", description = "The robot will drive left.")
public class DriveLeft extends StateAction<P2DXContext>
{
    public DriveLeft(P2DXContext ctx)
    {
        super("DriveLeft", ctx);
    }

    @Override
    public void init(VariableContext params)
    {
    }

    @Override
    public ActionResult run(VariableContext params)
    {
        ctx.getAct().act(new DriveSkid(ctx.speedTurn, ctx.speedSlow, false, false, false));
        return ActionResult.FINISHED;
    }

    @Override
    public void done(VariableContext params)
    {
    }
}
