package actions;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.examples.sposhp2dxrobot.P2DXContext;

/**
 * Action that causes robot to move straight.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "DriveBackwards", description = "The robot will drive forward.")
public class DriveBackwards extends StateAction<P2DXContext>
{
    public DriveBackwards(P2DXContext ctx)
    {
        super("DriveForward", ctx);
    }
    
    private int duration = 0;

    @Override
    public void init(VariableContext params)
    {
        duration = 0;
    }

    @Override
    public ActionResult run(VariableContext params)
    {
        ctx.getAct().act(new DriveSkid(-ctx.speedSlow, -ctx.speedSlow, false, false, false));
        duration++;
        return ActionResult.RUNNING;
    }

    @Override
    public void done(VariableContext params)
    {
        duration = 0;
    }
}
