package senses;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.DriveDirection;
import cz.cuni.amis.pogamut.usar2004.examples.sposhp2dxrobot.P2DXContext;

/**
 * Sense for deciding wether the robot should back out or not.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "IsInDanger", description = "Is there no free space to move forward??")
public class IsInDanger extends StateSense<P2DXContext, Boolean>
{
    public IsInDanger(P2DXContext ctx)
    {
        super("IsInDanger", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        return ctx.getDriveDirection() == DriveDirection.BACKWARD;
    }
}
