package cz.cuni.amis.pogamut.usar2004.examples.sposhp2dxrobot;

import cz.cuni.amis.pogamut.sposh.usar2004.StateSposhLogicController;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.GetStartPoses;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.utils.USAR2004BotRunner;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import java.io.IOException;
import java.util.logging.Level;


import cz.cuni.amis.utils.exception.PogamutException;

/**
 * Create simple bot that is standing still and when its health falls under 90,
 * it runs around the map, looking for medkits.
 *
 * @see IUT2004BotController Controller for various methods called during
 * construction of bot.
 * @author vejmanm
 */
public class P2DXLogic extends StateSposhLogicController<USAR2004Bot, P2DXContext>
{
    private String SPOSH_PLAN_RESOURCE = "sposh/plan/BotPlan_New.lap";

    @Override
    protected String getPlan() throws IOException
    {
        return getPlanFromResource(SPOSH_PLAN_RESOURCE);
    }

    /**
     * Create context that can be accessed in every state primitive.
     *
     * @return new context of this bot.
     */
    @Override
    protected P2DXContext createContext()
    {
        return new P2DXContext(bot);
    }

    @Override
    public void robotInitialized(NfoMessage nfom)
    {
        getAct().act(new Initialize("USARBot.P2DX", "P2DX POSH sample robot", nfom.getStartPoses().get(0).getName()));
    }

    @Override
    public void prepareBot(USAR2004Bot bot)
    {
        super.prepareBot(bot);
    }

    /**
     * Create an {@link ExternalBot} with custom made logic and try to connect
     * to Unreal Server at localhost:3000
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) throws PogamutException
    {
        new USAR2004BotRunner(P2DXLogic.class, "SPOSH-P2DX-ROBOT", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.OFF).startAgent();
    }
}
