package cz.cuni.amis.pogamut.usar2004.examples.sposhp2dxrobot;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ClosestObstacle;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.DriveDirection;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.SensorSpecificModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;

/**
 * Context is a class that funsions like a shared object between all primitives.
 * You may use default {@link UT2004Context} or create custom one, that is
 * extended to fulfill needs of your bot (extended memory, custom map planner
 * and other stuff).
 *
 * Remmeber to call method {@link UT2004Context#initialize() }, otherwise you
 * will end up with uninitialized modules and very likely with {@link NullPointerException}.
 *
 * @author Honza
 */
public class P2DXContext extends USAR2004Context<USAR2004Bot>
{
    public P2DXContext(USAR2004Bot bot)
    {
        super("P2DXContext", bot);
        // IMPORTANT: Various modules of context must be initialized.
        initialize();
        initModules();

        // INITIALIZE CUSTOM MODULES
    }

    private void initModules()
    {
        laserModule = new SensorSpecificModule<SensorLaser>(bot, SensorLaser.class);
    }

    public DriveDirection getDriveDirection()
    {
        if(!laserModule.isReaded())
        {
            direction = laserModule.getModule().getMostOpenDirection(100);
        }
        return direction;
    }
    public SensorSpecificModule<SensorLaser> laserModule;
    public DriveDirection direction;
    public final int speedSlow = 10;
    public final int speedFast = 15;
    public final int speedTurn = 5;
}
