package actions;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.examples.sposhp2dxrobot.P2DXContext;

/**
 * Action that causes robot to move straight.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "DriveForward", description = "The robot will drive forward.")
public class DriveForward extends StateAction<P2DXContext>
{
    public DriveForward(P2DXContext ctx)
    {
        super("DriveForward", ctx);
    }

    @Override
    public void init(VariableContext params)
    {
    }

    @Override
    public ActionResult run(VariableContext params)
    {
        ctx.getAct().act(new DriveSkid(ctx.speedFast, ctx.speedFast, false, false, false));
        return ActionResult.FINISHED;
    }

    @Override
    public void done(VariableContext params)
    {
    }
}
