/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.AbstractRandomMapGenerator;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.ButtonDefinition;
import cz.cuni.amis.utils.collections.MyCollections;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class RandomMapGenerator
extends AbstractRandomMapGenerator {
    int numKeyPoints;
    double doorOpenDensity;
    double doorCloseDensity;

    public RandomMapGenerator(long seed, int width, int height, int numKeyPoints, double doorOpenDensity, double doorCloseDensity) {
        super(seed, width, height);
        this.numKeyPoints = numKeyPoints;
        this.doorOpenDensity = doorOpenDensity;
        this.doorCloseDensity = doorCloseDensity;
    }

    public Collection<ButtonDefinition> createRandomMapDefinition() {
        Point buttonLocation;
        Point randomFrom;
        int numDoorOpens = 0;
        int numDoorClose = 0;
        int desiredOpenDoorCount = (int)((double)this.getMaximumNumberOfButtons() * this.doorOpenDensity);
        int desiredCloseDoorCount = (int)((double)this.getMaximumNumberOfButtons() * this.doorCloseDensity);
        this.buttonDefinitions = new HashMap();
        ArrayList<Point> path = new ArrayList<Point>();
        path.add(new Point(0, 0));
        for (int i = 0; i < this.numKeyPoints; ++i) {
            int keyPointX = this.rnd.nextInt(this.width);
            int keyPointY = this.rnd.nextInt(this.height);
            while (keyPointX == this.width - 1 && keyPointY == this.height - 1) {
                keyPointX = this.rnd.nextInt(this.width);
                keyPointY = this.rnd.nextInt(this.height);
            }
            this.appendPathToKeyPoint(path, keyPointX, keyPointY);
        }
        this.appendPathToKeyPoint(path, this.width - 1, this.height - 1);
        for (Point p : path) {
            System.out.println(p);
        }
        Integer[] ensureIndices = new Integer[path.size() - 1];
        for (int i = path.size() - 1; i > 0; --i) {
            int ensureIndex = i > 1 ? (int)Math.sqrt(this.rnd.nextInt(i * i - 1)) : 0;
            ensureIndices[i - 1] = ensureIndex;
            this.addButtonInteractionToLocation((Point)path.get(ensureIndex), (Point)path.get(i - 1), (Point)path.get(i), true);
            ++numDoorOpens;
        }
        if (numDoorOpens > desiredOpenDoorCount) {
            double newDensity = (double)numDoorOpens / (double)this.getMaximumNumberOfButtons();
            System.out.println("Needed more than desired number of interactions to reach the target. The doorOpenDensity is " + newDensity + ", should have been " + this.doorOpenDensity);
        }
        while (numDoorOpens < desiredOpenDoorCount) {
            boolean addedNew = false;
            while (!addedNew) {
                Point randomTo = this.getRandomPoint();
                randomFrom = (Point)MyCollections.getRandom(this.getNeighbouringPoints(randomTo));
                buttonLocation = this.getRandomPoint();
                addedNew = this.addButtonInteractionToLocation(buttonLocation, randomFrom, randomTo, true);
            }
            ++numDoorOpens;
        }
        while (numDoorClose < desiredCloseDoorCount) {
            boolean addedNew = false;
            while (!addedNew) {
                Point randomTo = this.getRandomPoint();
                randomFrom = (Point)MyCollections.getRandom(this.getNeighbouringPoints(randomTo));
                buttonLocation = this.getRandomPoint();
                if (this.threatensGuaranteedPath(path, ensureIndices, buttonLocation, randomFrom, randomTo)) continue;
                addedNew = this.addButtonInteractionToLocation(buttonLocation, randomFrom, randomTo, false);
            }
            ++numDoorClose;
        }
        return this.buttonDefinitions.values();
    }

    protected boolean threatensGuaranteedPath(List<Point> path, Integer[] ensureIndices, Point buttonLocation, Point from, Point to) {
        if (!(path.contains(to) && path.contains(from) && path.contains(buttonLocation))) {
            return false;
        }
        for (int i = 0; i < path.size(); ++i) {
            if (!path.get(i).equals(buttonLocation) || !ArrayUtils.contains((Object[])ensureIndices, (Object)i)) continue;
            for (int j = path.size() - 1; j > 0; --j) {
                if ((!path.get(j).equals(to) || !path.get(j - 1).equals(from)) && (!path.get(j).equals(from) || !path.get(j - 1).equals(to)) || ensureIndices[j - 1] > i) continue;
                return true;
            }
        }
        return false;
    }

    protected void appendPathToKeyPoint(List<Point> targetPath, int keyPointX, int keyPointY) {
        Point lastPathPoint = targetPath.get(targetPath.size() - 1);
        Point targetPoint = new Point(keyPointX, keyPointY);
        while (!lastPathPoint.equals(targetPoint)) {
            boolean moveX;
            int distanceX = Math.abs(lastPathPoint.x - keyPointX);
            int distanceY = Math.abs(lastPathPoint.y - keyPointY);
            if (distanceX == 0) {
                moveX = false;
            } else if (distanceY == 0) {
                moveX = true;
            } else {
                int totalDistance = distanceX + distanceY;
                double moveXProbability = (double)distanceX / (double)totalDistance;
                moveX = this.rnd.nextDouble() < moveXProbability;
            }
            int nextPointX = lastPathPoint.x;
            int nextPointY = lastPathPoint.y;
            if (moveX) {
                nextPointX = keyPointX > lastPathPoint.x ? ++nextPointX : --nextPointX;
            } else {
                nextPointY = keyPointY > lastPathPoint.y ? ++nextPointY : --nextPointY;
            }
            lastPathPoint = new Point(nextPointX, nextPointY);
            targetPath.add(lastPathPoint);
        }
    }
}

