/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.ButtonMatineeData;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.DoorMatineeData;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.DoorStateChangedAction;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.ExternalDoorStateChangedEvent;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.Generator;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.DefaultT3dGenerator;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.SequenceNamingFactory;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.KismetLinkTarget;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.StaticReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.UnrealReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.AbstractKismetObject;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.DelayAction;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.FinishSequenceAction;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.MatineeData;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.MatineeMover;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.ObjectVariable;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.Sequence;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.SequenceActivatedEvent;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.TriggerUsedEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class KismetGenerator {
    private static final String INTERP_ACTOR = "InterpActor";
    private static final String TRIGGER = "Trigger";
    private SequenceNamingFactory emulatedEditorNameDesignation;
    private String lastDoorName;
    private Generator generator;
    List<AbstractKismetObject> generatedObjects = new ArrayList<AbstractKismetObject>();

    public KismetGenerator(Generator generator) {
        this.generator = generator;
        this.emulatedEditorNameDesignation = new SequenceNamingFactory();
    }

    private List<AbstractKismetObject> createButtonHandler(String buttonActorName, String triggerName, String outputLinkName, MatineeData buttonMatineeData, int baseX, int baseY) {
        ArrayList<AbstractKismetObject> handlerObjects = new ArrayList<AbstractKismetObject>();
        ObjectVariable buttonMoverVar = new ObjectVariable((UnrealReference)new StaticReference(INTERP_ACTOR, buttonActorName));
        buttonMoverVar.setPositionForGUI(baseX + 250, baseY + 300);
        handlerObjects.add((AbstractKismetObject)buttonMoverVar);
        MatineeMover matinee = new MatineeMover(buttonMatineeData, buttonMoverVar);
        matinee.setPositionForGUI(baseX + 200, baseY + 100);
        handlerObjects.add((AbstractKismetObject)matinee);
        DelayAction delay = new DelayAction(Float.valueOf(0.5f), Boolean.FALSE);
        delay.setPositionForGUI(baseX + 200, baseY - 50);
        handlerObjects.add((AbstractKismetObject)delay);
        TriggerUsedEvent triggerUsedEvent = new TriggerUsedEvent((UnrealReference)new StaticReference(TRIGGER, triggerName));
        triggerUsedEvent.setAimToInteract(Boolean.FALSE);
        triggerUsedEvent.setInteractDistance(Float.valueOf(256.0f));
        triggerUsedEvent.setMaxTriggerCount(Integer.valueOf(0));
        triggerUsedEvent.setPositionForGUI(baseX, baseY);
        handlerObjects.add((AbstractKismetObject)triggerUsedEvent);
        FinishSequenceAction finishAction = new FinishSequenceAction(outputLinkName);
        finishAction.setPositionForGUI(baseX + 500, baseY);
        handlerObjects.add((AbstractKismetObject)finishAction);
        triggerUsedEvent.addOutputLinkTarget("Used", new KismetLinkTarget((AbstractKismetObject)matinee, "Play"));
        matinee.addOutputLinkTarget("Completed", new KismetLinkTarget((AbstractKismetObject)delay, "Start"));
        matinee.addOutputLinkTarget("Completed", new KismetLinkTarget((AbstractKismetObject)finishAction, "In"));
        delay.addOutputLinkTarget("Finished", new KismetLinkTarget((AbstractKismetObject)matinee, "Reverse"));
        return handlerObjects;
    }

    public Sequence addCorridorSequence(String corridorName, String doorFrom, String doorTo, int corridorLocX, int corridorLocY) {
        this.lastDoorName = this.emulatedEditorNameDesignation.getName(INTERP_ACTOR);
        String firstButtonName = this.emulatedEditorNameDesignation.getName(INTERP_ACTOR);
        String firstTriggerName = corridorName + this.generator.BUTTON1_TRIGGER_SUFFIX;
        String secondButtonName = this.emulatedEditorNameDesignation.getName(INTERP_ACTOR);
        String secondTriggerName = corridorName + this.generator.BUTTON2_TRIGGER_SUFFIX;
        Sequence seq = new Sequence(new String[]{"Open", "Close"}, new String[]{"Button1", "Button2"}, new String[0]);
        seq.setName(corridorName + "_sequence");
        seq.getOutputLink("Button1").setDrawY(Integer.valueOf(0));
        seq.getOutputLink("Button2").setDrawY(Integer.valueOf(32));
        DoorMatineeData doorMovementMatineeData = new DoorMatineeData();
        doorMovementMatineeData.setPositionForGUI(200, 200);
        ObjectVariable doorVariable = new ObjectVariable((UnrealReference)new StaticReference(INTERP_ACTOR, this.lastDoorName));
        doorVariable.setPositionForGUI(250, 200);
        MatineeMover doorMatinee = new MatineeMover((MatineeData)doorMovementMatineeData, doorVariable);
        doorMatinee.setPositionForGUI(200, 0);
        seq.addSequenceObject((AbstractKismetObject)doorMovementMatineeData);
        seq.addSequenceObject((AbstractKismetObject)doorVariable);
        seq.addSequenceObject((AbstractKismetObject)doorMatinee);
        SequenceActivatedEvent openEvent = new SequenceActivatedEvent("Open");
        KismetLinkTarget openDoorLinkTarget = new KismetLinkTarget((AbstractKismetObject)doorMatinee, "Play");
        openEvent.addOutputLinkTarget("Out", openDoorLinkTarget);
        openEvent.setPositionForGUI(-300, 0);
        seq.addSequenceObject((AbstractKismetObject)openEvent);
        SequenceActivatedEvent closeEvent = new SequenceActivatedEvent("Close");
        KismetLinkTarget closeDoorLinkTarget = new KismetLinkTarget((AbstractKismetObject)doorMatinee, "Reverse");
        closeEvent.addOutputLinkTarget("Out", closeDoorLinkTarget);
        closeEvent.setPositionForGUI(-300, 200);
        seq.addSequenceObject((AbstractKismetObject)closeEvent);
        ExternalDoorStateChangedEvent externalDoorEvent = new ExternalDoorStateChangedEvent(doorFrom, doorTo);
        externalDoorEvent.addOutputLinkTarget("Open", openDoorLinkTarget);
        externalDoorEvent.addOutputLinkTarget("Close", closeDoorLinkTarget);
        externalDoorEvent.setPositionForGUI(-80, 0);
        seq.addSequenceObject((AbstractKismetObject)externalDoorEvent);
        DoorStateChangedAction doorStateChanged = new DoorStateChangedAction(doorFrom, doorTo);
        doorMatinee.addOutputLinkTarget("Completed", new KismetLinkTarget((AbstractKismetObject)doorStateChanged, "Open"));
        doorMatinee.addOutputLinkTarget("Reversed", new KismetLinkTarget((AbstractKismetObject)doorStateChanged, "Close"));
        doorStateChanged.setPositionForGUI(430, 0);
        seq.addSequenceObject((AbstractKismetObject)doorStateChanged);
        ButtonMatineeData buttonMatineeData = new ButtonMatineeData();
        buttonMatineeData.setPositionForGUI(700, 250);
        seq.addSequenceObject((AbstractKismetObject)buttonMatineeData);
        seq.addSequenceObjects(this.createButtonHandler(firstButtonName, firstTriggerName, "Button1", buttonMatineeData, 700, 0));
        seq.addSequenceObjects(this.createButtonHandler(secondButtonName, secondTriggerName, "Button2", buttonMatineeData, 700, 500));
        seq.setObjComment(corridorName);
        int gridSize = 128;
        seq.setPositionForGUI(gridSize * corridorLocX, gridSize * corridorLocY);
        this.generatedObjects.add((AbstractKismetObject)seq);
        return seq;
    }

    public void saveToFile(File file) {
        try {
            FileWriter out = new FileWriter(file);
            DefaultT3dGenerator gen = new DefaultT3dGenerator();
            gen.generateT3d(this.generatedObjects, (OutputStreamWriter)out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getLastDoorName() {
        return this.lastDoorName;
    }
}

