/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import com.thoughtworks.xstream.XStream;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.ButtonDefinition;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.Corridor;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.Direction;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.KismetGenerator;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.PrefabDefinition;
import cz.cuni.amis.pogamut.spyvsspy.metadata.Button;
import cz.cuni.amis.pogamut.spyvsspy.metadata.Door;
import cz.cuni.amis.pogamut.spyvsspy.metadata.Room;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.DefaultT3dGenerator;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.T3dElementHelper;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.KismetLinkTarget;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Point3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Rotation3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.AbstractKismetObject;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.Sequence;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.PathNode;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.PlayerStart;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.Trigger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class Generator {
    public final String BUTTON1_PATHNODE_SUFFIX = "_Button1";
    public final String BUTTON1_TRIGGER_SUFFIX = "_Button1Trigger";
    public final String BUTTON2_PATHNODE_SUFFIX = "_Button2";
    public final String BUTTON2_TRIGGER_SUFFIX = "_Button2Trigger";
    Iterable<ButtonDefinition> buttonDefinitions;
    int[][] horizontalCorridorPresence;
    int[][] verticalCorridorPresence;
    int levelWidth;
    int levelHeight;
    boolean generatePlayerStarts;

    public Generator(Iterable<ButtonDefinition> buttonDefinitions, boolean generatePlayerStarts) {
        this(buttonDefinitions, generatePlayerStarts, false);
    }

    public Generator(Iterable<ButtonDefinition> buttonDefinitions, boolean generatePlayerStarts, boolean forceAllRooms) {
        this.generatePlayerStarts = generatePlayerStarts;
        this.buttonDefinitions = buttonDefinitions;
        this.levelWidth = 0;
        this.levelHeight = 0;
        for (ButtonDefinition buttonDef : buttonDefinitions) {
            for (Corridor c : buttonDef.getAllCorridor()) {
                if (c.getDestinationX() + 1 > this.levelWidth) {
                    this.levelWidth = c.getDestinationX() + 1;
                }
                if (c.getDestinationY() + 1 <= this.levelHeight) continue;
                this.levelHeight = c.getDestinationY() + 1;
            }
        }
        this.horizontalCorridorPresence = new int[this.levelWidth - 1][this.levelHeight];
        this.verticalCorridorPresence = new int[this.levelWidth][this.levelHeight - 1];
        if (forceAllRooms) {
            int i;
            for (i = 0; i < this.levelWidth - 1; ++i) {
                for (int j = 0; j < this.levelHeight; ++j) {
                    this.horizontalCorridorPresence[i][j] = 1;
                }
            }
            for (i = 0; i < this.levelWidth; ++i) {
                for (int j = 0; j < this.levelHeight - 1; ++j) {
                    this.verticalCorridorPresence[i][j] = 1;
                }
            }
        } else {
            for (ButtonDefinition buttonDef : buttonDefinitions) {
                boolean buttonOutOfLevel = false;
                if (buttonDef.getLocX() < 0 || buttonDef.getLocY() < 0 || buttonDef.getLocX() >= this.levelWidth || buttonDef.getLocY() >= this.levelHeight) {
                    buttonOutOfLevel = true;
                } else {
                    switch (buttonDef.getDirection()) {
                        case NORTH: {
                            if (buttonDef.getLocY() <= 0) {
                                buttonOutOfLevel = true;
                                break;
                            }
                            this.verticalCorridorPresence[buttonDef.getLocX()][buttonDef.getLocY() - 1] = 1;
                            break;
                        }
                        case WEST: {
                            if (buttonDef.getLocX() <= 0) {
                                buttonOutOfLevel = true;
                                break;
                            }
                            this.horizontalCorridorPresence[buttonDef.getLocX() - 1][buttonDef.getLocY()] = 1;
                            break;
                        }
                        case SOUTH: {
                            if (buttonDef.getLocY() >= this.levelHeight - 1) {
                                buttonOutOfLevel = true;
                                break;
                            }
                            this.verticalCorridorPresence[buttonDef.getLocX()][buttonDef.getLocY()] = 1;
                            break;
                        }
                        case EAST: {
                            if (buttonDef.getLocX() >= this.levelWidth - 1) {
                                buttonOutOfLevel = true;
                                break;
                            }
                            this.horizontalCorridorPresence[buttonDef.getLocX()][buttonDef.getLocY()] = 1;
                        }
                    }
                }
                if (buttonOutOfLevel) {
                    throw new IllegalArgumentException("Inconsistent definition. Button at " + buttonDef.getLocX() + "," + buttonDef.getLocY() + " " + (Object)((Object)buttonDef.getDirection()) + " is out of level bounds");
                }
                for (Corridor c : buttonDef.getAllCorridor()) {
                    if (c.isHorizontal()) {
                        this.horizontalCorridorPresence[c.getOriginX()][c.getOriginY()] = 1;
                        continue;
                    }
                    this.verticalCorridorPresence[c.getOriginX()][c.getOriginY()] = 1;
                }
            }
        }
    }

    public String getRoomName(int x, int y) {
        return "" + (char)(65 + x) + y;
    }

    public String getCorridorName(int startX, int startY, int endX, int endY) {
        String smer = "";
        if (startX == endX) {
            smer = "_Vert";
        } else if (startY == endY) {
            smer = "_Horiz";
        }
        return "Corridor_" + this.getRoomName(startX, startY) + "_" + this.getRoomName(endX, endY) + smer;
    }

    protected int getNumSurrounded(int x, int y) {
        int numSurround = 0;
        for (Direction d : Direction.values()) {
            if (!this.isRoomSorrounded(x, y, d)) continue;
            ++numSurround;
        }
        return numSurround;
    }

    protected boolean isRoomSorrounded(int x, int y, Direction dir) {
        switch (dir) {
            case NORTH: {
                if (y <= 0) {
                    return false;
                }
                return this.verticalCorridorPresence[x][y - 1] != 0;
            }
            case EAST: {
                if (x >= this.levelWidth - 1) {
                    return false;
                }
                return this.horizontalCorridorPresence[x][y] != 0;
            }
            case SOUTH: {
                if (y >= this.levelHeight - 1) {
                    return false;
                }
                return this.verticalCorridorPresence[x][y] != 0;
            }
            case WEST: {
                if (x <= 0) {
                    return false;
                }
                return this.horizontalCorridorPresence[x - 1][y] != 0;
            }
        }
        throw new IllegalArgumentException("Unrecognized direction");
    }

    public void generate(File t3dFile, File metadataFile, File kismetFile) {
        ArrayList<Object> actors = new ArrayList<Object>();
        KismetGenerator kismetGenerator = new KismetGenerator(this);
        int gridSize = 2304;
        PrefabDefinition corner = new PrefabDefinition(new Point3D(256.0f, 0.0f, 0.0f), "SpyVsSpy.Corner");
        PrefabDefinition threeCross = new PrefabDefinition(new Point3D(256.0f, 0.0f, 0.0f), "SpyVsSpy.3Cross");
        PrefabDefinition fourCross = new PrefabDefinition(new Point3D(252.0f, 0.0f, 0.0f), "SpyVsSpy.4Cross");
        PrefabDefinition straight = new PrefabDefinition(new Point3D(256.0f, 0.0f, 0.0f), "SpyVsSpy.Straight");
        PrefabDefinition deadEnd = new PrefabDefinition(new Point3D(256.0f, 0.0f, 0.0f), "SpyVsSpy.DeadEnd");
        PrefabDefinition corridor = new PrefabDefinition(new Point3D(0.0f, -128.0f, 0.0f), "SpyVsSpy.Corridor");
        PrefabDefinition[][] roomsDefinitions = new PrefabDefinition[this.levelWidth][this.levelHeight];
        int[][] roomsRotations = new int[this.levelWidth][this.levelHeight];
        for (int x = 0; x < this.levelWidth; ++x) {
            block18: for (int y = 0; y < this.levelHeight; ++y) {
                switch (this.getNumSurrounded(x, y)) {
                    case 0: {
                        roomsDefinitions[x][y] = null;
                        continue block18;
                    }
                    case 1: {
                        roomsDefinitions[x][y] = deadEnd;
                        for (Direction d : Direction.values()) {
                            if (!this.isRoomSorrounded(x, y, d)) continue;
                            roomsRotations[x][y] = d.getYawRotation() + 1;
                            continue block18;
                        }
                        continue block18;
                    }
                    case 2: {
                        if (this.isRoomSorrounded(x, y, Direction.NORTH) == this.isRoomSorrounded(x, y, Direction.SOUTH)) {
                            roomsDefinitions[x][y] = straight;
                            if (this.isRoomSorrounded(x, y, Direction.NORTH)) {
                                roomsRotations[x][y] = 1;
                                continue block18;
                            }
                            roomsRotations[x][y] = 0;
                            continue block18;
                        }
                        roomsDefinitions[x][y] = corner;
                        if (this.isRoomSorrounded(x, y, Direction.NORTH)) {
                            if (this.isRoomSorrounded(x, y, Direction.EAST)) {
                                roomsRotations[x][y] = 1;
                                continue block18;
                            }
                            roomsRotations[x][y] = 0;
                            continue block18;
                        }
                        if (this.isRoomSorrounded(x, y, Direction.EAST)) {
                            roomsRotations[x][y] = 2;
                            continue block18;
                        }
                        roomsRotations[x][y] = -1;
                        continue block18;
                    }
                    case 3: {
                        roomsDefinitions[x][y] = threeCross;
                        for (Direction dir : Direction.values()) {
                            if (this.isRoomSorrounded(x, y, dir)) continue;
                            roomsRotations[x][y] = dir.getYawRotation() + 2;
                        }
                        continue block18;
                    }
                    case 4: {
                        roomsDefinitions[x][y] = fourCross;
                    }
                }
            }
        }
        Room[][] locationMetaData = new Room[this.levelWidth][this.levelHeight];
        for (int i = 0; i < this.levelWidth; ++i) {
            for (int j = 0; j < this.levelHeight; ++j) {
                if (roomsDefinitions[i][j] != null) {
                    Point3D location = new Point3D((float)(-j * gridSize), (float)(i * gridSize), 0.0f);
                    Rotation3D rotation = new Rotation3D(0, roomsRotations[i][j] * 16384, 0);
                    String name = "Room_" + this.getRoomName(i, j);
                    actors.add(roomsDefinitions[i][j].createPrefabInstance(location, rotation, name));
                    Point3D navigationPointLocation = location.add(new Point3D(0.0f, 0.0f, 25.0f));
                    Object navigationPoint = this.generatePlayerStarts ? new PlayerStart(navigationPointLocation) : new PathNode(navigationPointLocation);
                    navigationPoint.setName("PlayerStart_" + this.getRoomName(i, j));
                    actors.add(navigationPoint);
                    locationMetaData[i][j] = new Room(name, navigationPoint.getName());
                    continue;
                }
                locationMetaData[i][j] = null;
            }
        }
        Point3D button1TriggerLocation = new Point3D(-75.0f, -640.0f, 96.0f);
        float buttonTriggerCollisionHeight = 80.0f;
        float buttonTriggerCollisionRadius = 256.0f;
        Point3D button1PathNodeLocation = new Point3D(-15.0f, -640.0f, 25.0f);
        ArrayList<Door> doorMetadata = new ArrayList<Door>();
        Sequence[][] horizontalCorridorSequences = new Sequence[this.levelWidth - 1][this.levelHeight];
        for (int i = 0; i < this.horizontalCorridorPresence.length; ++i) {
            for (int j = 0; j < this.horizontalCorridorPresence[i].length; ++j) {
                if (this.horizontalCorridorPresence[i][j] == 0) continue;
                Point3D location = new Point3D((float)(-j * gridSize), (float)(i * gridSize + gridSize / 2), 0.0f);
                String name = this.getCorridorName(i, j, i + 1, j);
                actors.add(corridor.createPrefabInstance(location, new Rotation3D(0, 0, 0), name));
                Door door = new Door(locationMetaData[i][j], locationMetaData[i + 1][j]);
                doorMetadata.add(door);
                horizontalCorridorSequences[i][j] = kismetGenerator.addCorridorSequence(name, door.getFrom().getRoomName(), door.getTo().getRoomName(), i * 2 + 1, j * 2);
                PathNode button1Node = new PathNode(location.add(button1PathNodeLocation));
                button1Node.setNameForReferences(name + "_Button1");
                actors.add(button1Node);
                Trigger button1Trigger = new Trigger(location.add(button1TriggerLocation), buttonTriggerCollisionHeight, buttonTriggerCollisionRadius);
                button1Trigger.setNameForReferences(name + "_Button1Trigger");
                actors.add(button1Trigger);
                PathNode button2Node = new PathNode(location.add(button1PathNodeLocation.negateXandY()));
                button2Node.setNameForReferences(name + "_Button2");
                actors.add(button2Node);
                Trigger button2Trigger = new Trigger(location.add(button1TriggerLocation.negateXandY()), buttonTriggerCollisionHeight, buttonTriggerCollisionRadius);
                button2Trigger.setNameForReferences(name + "_Button2Trigger");
                actors.add(button2Trigger);
            }
        }
        Sequence[][] verticalCorridorSequences = new Sequence[this.levelWidth][this.levelHeight - 1];
        for (int i = 0; i < this.verticalCorridorPresence.length; ++i) {
            for (int j = 0; j < this.verticalCorridorPresence[i].length; ++j) {
                if (this.verticalCorridorPresence[i][j] == 0) continue;
                Point3D location = new Point3D((float)(-j * gridSize - gridSize / 2), (float)(i * gridSize), 0.0f);
                String name = this.getCorridorName(i, j, i, j + 1);
                actors.add(corridor.createPrefabInstance(location, new Rotation3D(0, 16384, 0), name));
                Door door = new Door(locationMetaData[i][j], locationMetaData[i][j + 1]);
                doorMetadata.add(door);
                verticalCorridorSequences[i][j] = kismetGenerator.addCorridorSequence(name, door.getFrom().getRoomName(), door.getTo().getRoomName(), i * 2, j * 2 + 1);
                PathNode button1Node = new PathNode(location.add(button1PathNodeLocation.switchXandY().negateX()));
                button1Node.setNameForReferences(name + "_Button1");
                actors.add(button1Node);
                Trigger button1Trigger = new Trigger(location.add(button1TriggerLocation.switchXandY().negateX()), buttonTriggerCollisionHeight, buttonTriggerCollisionRadius);
                button1Trigger.setNameForReferences(name + "_Button1Trigger");
                actors.add(button1Trigger);
                PathNode button2Node = new PathNode(location.add(button1PathNodeLocation.switchXandY().negateY()));
                button2Node.setNameForReferences(name + "_Button2");
                actors.add(button2Node);
                Trigger button2Trigger = new Trigger(location.add(button1TriggerLocation.switchXandY().negateY()), buttonTriggerCollisionHeight, buttonTriggerCollisionRadius);
                button2Trigger.setNameForReferences(name + "_Button2Trigger");
                actors.add(button2Trigger);
            }
        }
        ArrayList<Button> buttonMetadata = new ArrayList<Button>();
        for (ButtonDefinition def : this.buttonDefinitions) {
            Sequence targetSequence;
            String triggerName;
            String pathNodeName;
            String corridorName;
            int buttonId;
            Sequence sourceSequence;
            switch (def.getDirection()) {
                case NORTH: {
                    sourceSequence = verticalCorridorSequences[def.getLocX()][def.getLocY() - 1];
                    buttonId = 2;
                    corridorName = this.getCorridorName(def.getLocX(), def.getLocY() - 1, def.getLocX(), def.getLocY());
                    break;
                }
                case EAST: {
                    sourceSequence = horizontalCorridorSequences[def.getLocX()][def.getLocY()];
                    buttonId = 1;
                    corridorName = this.getCorridorName(def.getLocX(), def.getLocY(), def.getLocX() + 1, def.getLocY());
                    break;
                }
                case SOUTH: {
                    sourceSequence = verticalCorridorSequences[def.getLocX()][def.getLocY()];
                    buttonId = 1;
                    corridorName = this.getCorridorName(def.getLocX(), def.getLocY(), def.getLocX(), def.getLocY() + 1);
                    break;
                }
                case WEST: {
                    sourceSequence = horizontalCorridorSequences[def.getLocX() - 1][def.getLocY()];
                    buttonId = 2;
                    corridorName = this.getCorridorName(def.getLocX() - 1, def.getLocY(), def.getLocX(), def.getLocY());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized value of direction");
                }
            }
            if (sourceSequence == null) {
                throw new IllegalArgumentException("No corridor found for button: " + def);
            }
            String sourceLabel = "Button" + buttonId;
            if (buttonId == 1) {
                pathNodeName = corridorName + "_Button1";
                triggerName = corridorName + "_Button1Trigger";
            } else if (buttonId == 2) {
                pathNodeName = corridorName + "_Button2";
                triggerName = corridorName + "_Button2Trigger";
            } else {
                throw new IllegalStateException();
            }
            ArrayList<Door> opensDoor = new ArrayList<Door>();
            ArrayList<Door> closesDoor = new ArrayList<Door>();
            for (Corridor c : def.getOpens()) {
                targetSequence = this.findTargetSequence(c, horizontalCorridorSequences, verticalCorridorSequences);
                sourceSequence.addOutputLinkTarget(sourceLabel, new KismetLinkTarget((AbstractKismetObject)targetSequence, "Open"));
                opensDoor.add(new Door(locationMetaData[c.getOriginX()][c.getOriginY()], locationMetaData[c.getDestinationX()][c.getDestinationY()]));
            }
            for (Corridor c : def.getCloses()) {
                targetSequence = this.findTargetSequence(c, horizontalCorridorSequences, verticalCorridorSequences);
                sourceSequence.addOutputLinkTarget(sourceLabel, new KismetLinkTarget((AbstractKismetObject)targetSequence, "Close"));
                closesDoor.add(new Door(locationMetaData[c.getOriginX()][c.getOriginY()], locationMetaData[c.getDestinationX()][c.getDestinationY()]));
            }
            buttonMetadata.add(new Button(pathNodeName, locationMetaData[def.getLocX()][def.getLocY()], opensDoor, closesDoor, triggerName));
        }
        try {
            FileWriter out = new FileWriter(t3dFile);
            DefaultT3dGenerator gen = new DefaultT3dGenerator();
            gen.generateT3d((Object)T3dElementHelper.wrapActorsIntoMap((String)"Gen_Test", actors), (OutputStreamWriter)out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        kismetGenerator.saveToFile(kismetFile);
        ArrayList<Object> metaDataList = new ArrayList<Object>();
        for (int i = 0; i < this.levelWidth; ++i) {
            for (int j = 0; j < this.levelHeight; ++j) {
                if (locationMetaData[i][j] == null) continue;
                metaDataList.add(locationMetaData[i][j]);
            }
        }
        metaDataList.addAll(doorMetadata);
        metaDataList.addAll(buttonMetadata);
        try {
            FileWriter out = new FileWriter(metadataFile);
            XStream xstream = new XStream();
            out.write(xstream.toXML(metaDataList));
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Sequence findTargetSequence(Corridor c, Sequence[][] horizontalCorridorSequences, Sequence[][] verticalCorridorSequences) {
        Sequence targetSequence = c.isHorizontal() ? horizontalCorridorSequences[c.getOriginX()][c.getOriginY()] : verticalCorridorSequences[c.getOriginX()][c.getOriginY()];
        return targetSequence;
    }
}

