/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.Corridor;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.Direction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ButtonDefinition {
    private int locX;
    private int locY;
    private Direction direction;
    private List<Corridor> opens;
    private List<Corridor> closes;

    public ButtonDefinition(int locX, int locY, Direction direction, Corridor opens, Corridor closes) {
        Corridor[] corridorArray;
        Corridor[] corridorArray2;
        if (opens == null) {
            corridorArray2 = null;
        } else {
            Corridor[] corridorArray3 = new Corridor[1];
            corridorArray2 = corridorArray3;
            corridorArray3[0] = opens;
        }
        if (closes == null) {
            corridorArray = null;
        } else {
            Corridor[] corridorArray4 = new Corridor[1];
            corridorArray = corridorArray4;
            corridorArray4[0] = closes;
        }
        this(locX, locY, direction, corridorArray2, corridorArray);
    }

    public ButtonDefinition(int locX, int locY, Direction direction, Corridor[] opens, Corridor[] closes) {
        this.locX = locX;
        this.locY = locY;
        this.direction = direction;
        this.opens = opens == null ? new ArrayList<Corridor>() : new ArrayList<Corridor>(Arrays.asList(opens));
        this.closes = closes == null ? new ArrayList<Corridor>() : new ArrayList<Corridor>(Arrays.asList(closes));
    }

    public List<Corridor> getCloses() {
        return this.closes;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getLocX() {
        return this.locX;
    }

    public int getLocY() {
        return this.locY;
    }

    public List<Corridor> getOpens() {
        return this.opens;
    }

    public void addOpen(Corridor open) {
        if (this.closes.contains(open)) {
            throw new IllegalArgumentException("Open - close conflict");
        }
        this.opens.add(open);
    }

    public void addClose(Corridor close) {
        if (this.opens.contains(close)) {
            throw new IllegalArgumentException("Open - close conflict");
        }
        this.closes.add(close);
    }

    public Collection<Corridor> getAllCorridor() {
        ArrayList<Corridor> ret = new ArrayList<Corridor>(this.opens);
        ret.addAll(this.closes);
        return ret;
    }

    public String toString() {
        return "ButtonDefinition{locX=" + this.locX + ", locY=" + this.locY + ", direction=" + (Object)((Object)this.direction) + ", opens=" + this.opens + ", closes=" + this.closes + '}';
    }
}

