/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.DefaultT3dGenerator;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.IT3dGenerator;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.T3dElementHelper;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Point3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.AbstractUnrealActor;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.MapElement;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.PlayerStart;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.PointLight;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.StaticMeshActor;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class ExampleApp {

    public static void main(String[] args) {
        StaticMeshActor staticMesh1 = new StaticMeshActor("FoliageDemo.Mesh.S_PavingBlocks_01", new Point3D(0, -50, -40));
        StaticMeshActor staticMesh2 = new StaticMeshActor("FoliageDemo.Mesh.RockMesa_06", new Point3D(0, 0, 400));
        PlayerStart playerStart = new PlayerStart(new Point3D(0, 0, 0));
        PointLight light = new PointLight(new Point3D(0, 50, 100));

        List<AbstractUnrealActor> actors = new ArrayList<AbstractUnrealActor>();
        actors.add(staticMesh1);
        actors.add(staticMesh2);
        actors.add(playerStart);
        actors.add(light);

        MapElement map = T3dElementHelper.wrapActorsIntoMap("My_First_Map", actors);

        IT3dGenerator generator = new DefaultT3dGenerator();
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream("out.t3d"));
            generator.generateT3d(map, out);
            out.close();
        } catch (Exception ex) {
            System.out.println("Error writing to file" +  ex.getMessage());
        }
    }
}
