/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.AbstractRandomMapGenerator;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.ButtonDefinition;
import cz.cuni.amis.utils.collections.MyCollections;
import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RandomRelaxedMapGenerator
extends AbstractRandomMapGenerator {
    double doorOpenDensity;

    public RandomRelaxedMapGenerator(long seed, int width, int height, double doorOpenDensity) {
        super(seed, width, height);
        this.doorOpenDensity = doorOpenDensity;
    }

    protected void addPointIfNotReachable(Point point, Set<Point> target, Set<Point> reachablePoints) {
        if (!reachablePoints.contains(point)) {
            target.add(point);
        }
    }

    protected void addNeighbouringUnReachablePoints(Point point, Set<Point> target, Set<Point> reachablePoints) {
        for (Point neighbour : this.getNeighbouringPoints(point)) {
            this.addPointIfNotReachable(neighbour, target, reachablePoints);
        }
    }

    protected Set<Point> getNeighbouringReachablePoints(Point point, Set<Point> reachablePoints) {
        Set<Point> result = this.getNeighbouringPoints(point);
        result.retainAll(reachablePoints);
        return result;
    }

    public Collection<ButtonDefinition> createRandomMapDefinition() {
        this.buttonDefinitions = new HashMap();
        HashSet<Point> oneStepReachablePoints = new HashSet<Point>();
        HashSet<Point> reachablePoints = new HashSet<Point>();
        reachablePoints.add(new Point(0, 0));
        this.addNeighbouringUnReachablePoints(new Point(0, 0), oneStepReachablePoints, reachablePoints);
        Point targetPoint = new Point(this.width - 1, this.height - 1);
        int doorOpenCount = 0;
        int desiredOpenDoorCount = (int)((double)this.getMaximumNumberOfButtons() * this.doorOpenDensity);
        while (!reachablePoints.contains(targetPoint)) {
            Point nextReachable = (Point)MyCollections.getRandom(oneStepReachablePoints);
            Point reachFrom = (Point)MyCollections.getRandom(this.getNeighbouringReachablePoints(nextReachable, reachablePoints));
            Point buttonLocation = (Point)MyCollections.getRandom(reachablePoints);
            this.addButtonInteractionToLocation(buttonLocation, reachFrom, nextReachable, true);
            oneStepReachablePoints.remove(nextReachable);
            reachablePoints.add(nextReachable);
            this.addNeighbouringUnReachablePoints(nextReachable, oneStepReachablePoints, reachablePoints);
            ++doorOpenCount;
        }
        System.out.println("Final guaranteed path length: " + doorOpenCount);
        if (doorOpenCount > desiredOpenDoorCount) {
            double newDensity = (double)doorOpenCount / (double)this.getMaximumNumberOfButtons();
            System.out.println("Needed more than desired number of interactions to reach the target. The doorOpenDensity is " + newDensity + ", should have been " + this.doorOpenDensity);
        }
        while (doorOpenCount < desiredOpenDoorCount) {
            boolean addedNew = false;
            while (!addedNew) {
                Point randomTo = this.getRandomPoint();
                Point randomFrom = (Point)MyCollections.getRandom(this.getNeighbouringPoints(randomTo));
                Point buttonLocation = (Point)MyCollections.getRandom(reachablePoints);
                reachablePoints.add(randomTo);
                addedNew = this.addButtonInteractionToLocation(buttonLocation, randomFrom, randomTo, true);
            }
            ++doorOpenCount;
        }
        return this.buttonDefinitions.values();
    }
}

