/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Point3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Rotation3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.PrefabInstance;

/**
 *
 * @author Martin Cerny
 */
public class PrefabDefinition {
    private Point3D prePivot;
/*    private int width, height, depth;*/
    private String prefabName;

    public PrefabDefinition(Point3D prePivot, String prefabName) {
        this.prePivot = prePivot;
        this.prefabName = prefabName;
    }

    public Point3D getPrePivot() {
        return prePivot;
    }


    public String getPrefabName() {
        return prefabName;
    }
    
    public Point3D adjustLocation(Point3D location, int yawRotation){
        int sin;
        int cos;
        int correctedRotation = yawRotation;
        if(correctedRotation < 0) {
            correctedRotation += 65536 * (((-correctedRotation) / 65536) + 1);
        }
        if(correctedRotation >= 65536) {
            correctedRotation = correctedRotation % 65536;
        }
        if(correctedRotation == 0){
            sin = 0;
            cos = 1;
        } else if (correctedRotation == 16384){
            sin = 1;
            cos = 0;
        } else if (correctedRotation == 32768){
            sin = 0;
            cos = -1;
        } else if (correctedRotation == 49152){
            sin = -1;
            cos = 0;
        } else {
            throw new IllegalArgumentException("Generator supports only yaw rotation of multiplies of PI/2. Rotation submitted: " +  yawRotation + " rotation after correction: " + correctedRotation);
        }
        final double deltaX = cos * prePivot.getX() + (-sin) * prePivot.getY();
        final double deltaY = sin * prePivot.getX() + cos * prePivot.getY();

        Point3D delta = new Point3D( (float) deltaX, (float)deltaY, -prePivot.getZ());

        return location.add(delta);
    }


    public PrefabInstance createPrefabInstance(Point3D location, Rotation3D rotation){
        return createPrefabInstance(location, rotation, null);
    }

    public PrefabInstance createPrefabInstance(Point3D location, Rotation3D rotation, String name){
        //Point3D adjustedLocation = new Point3D
        PrefabInstance prefab = new PrefabInstance(getPrefabName(),  adjustLocation(location, rotation.getYaw()), rotation);
        if(name != null){
            prefab.setName(name);
        }
//        prefab.setProperty("PrePivot", prePivot);
        return prefab;
    }

}
