/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshCache;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshClearanceComputer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.INavMeshDraw;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.NavMeshDraw;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder.NavMeshDropGrounder;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.NavMeshAStarDistanceHeuristic;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.NavMeshAStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.utils.NullCheck;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class NavMeshModule {
    private IWorldView worldView;
    private Logger log;
    private boolean shouldReloadNavMesh = false;
    private GameInfo loadedForMap = null;
    private NavMesh navMesh;
    private NavMeshDraw navMeshDraw;
    private NavMeshDropGrounder dropGrounder;
    private NavMeshAStarDistanceHeuristic aStarDistanceHeuristic;
    private NavMeshAStarPathPlanner aStarPathPlanner;
    private NavMeshClearanceComputer clearanceComputer;
    private IWorldEventListener<MapPointListObtained> mapListEndListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            GameInfo info = (GameInfo)NavMeshModule.this.worldView.getSingle(GameInfo.class);
            if (info == null) {
                throw new RuntimeException("Null game info after MapPointLIstObtained event.");
            }
            NavMeshModule.this.load(info);
        }
    };

    public NavMeshModule(IUT2004ServerProvider serverProvider, IWorldView worldView, IAgentLogger logger) {
        this.log = logger == null ? new LogCategory("NavMesh") : logger.getCategory("NavMesh");
        this.worldView = worldView;
        NullCheck.check((Object)this.worldView, (String)"worldView");
        this.navMesh = new NavMesh(this.log);
        this.dropGrounder = new NavMeshDropGrounder(this.navMesh);
        this.aStarDistanceHeuristic = new NavMeshAStarDistanceHeuristic(this.navMesh);
        this.aStarPathPlanner = new NavMeshAStarPathPlanner(this.dropGrounder, this.navMesh, this.aStarDistanceHeuristic, this.log);
        this.clearanceComputer = new NavMeshClearanceComputer(this.dropGrounder);
        this.navMeshDraw = new NavMeshDraw(this.navMesh, this.log, serverProvider);
        GameInfo info = (GameInfo)worldView.getSingle(GameInfo.class);
        if (info != null) {
            this.load(info);
        } else {
            worldView.addEventListener(MapPointListObtained.class, this.mapListEndListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(GameInfo info) {
        try {
            if (info == null) {
                this.log.severe("Could not load for 'null' GameInfo!");
                return;
            }
            if (this.loadedForMap != null && this.loadedForMap.getLevel().equals(info.getLevel())) {
                return;
            }
            Map worldViewOfNavPoints = this.worldView.getAll(NavPoint.class);
            HashMap navGraph = Maps.newHashMap();
            Map map = worldViewOfNavPoints;
            synchronized (map) {
                for (NavPoint navPoint : worldViewOfNavPoints.values()) {
                    navGraph.put(navPoint.getId(), navPoint);
                }
            }
            if (this.shouldReloadNavMesh) {
                NavMeshCache.reloadNavMesh(this.navMesh, navGraph, info.getLevel());
            } else {
                NavMeshCache.loadNavMesh(this.navMesh, navGraph, info.getLevel());
            }
            this.loadedForMap = info;
        }
        catch (Exception e) {
            this.log.warning("Failed to load NavMesh...");
            this.loadedForMap = null;
        }
    }

    public boolean isInitialized() {
        return this.loadedForMap != null;
    }

    public boolean shouldReloadNavMesh() {
        return this.shouldReloadNavMesh;
    }

    public void setReloadNavMesh(boolean value) {
        this.shouldReloadNavMesh = value;
    }

    public NavMesh getNavMesh() {
        if (!this.isInitialized()) {
            throw new RuntimeException("NAVMESH IS NOT INITIALIZED; you are either calling this method too early or missing .navmesh file in the local directory of your bot! We expect navmesh to be stored within ./navmesh directory; NavMeshes can be downloaded from: https://github.com/kefik/Pogamut3/tree/master/Addons/UT2004/Map/UT2004NavMeshTools/04-NavMeshes");
        }
        return this.navMesh;
    }

    public NavMeshDropGrounder getDropGrounder() {
        return this.dropGrounder;
    }

    public NavMeshAStarDistanceHeuristic getAStarDistanceHeuristic() {
        return this.aStarDistanceHeuristic;
    }

    public NavMeshAStarPathPlanner getAStarPathPlanner() {
        return this.aStarPathPlanner;
    }

    public NavMeshClearanceComputer getClearanceComputer() {
        return this.clearanceComputer;
    }

    public INavMeshDraw getNavMeshDraw() {
        return this.navMeshDraw;
    }
}

