/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.astar;

import cz.cuni.amis.pathfinding.alg.astar.AStar;
import cz.cuni.amis.pathfinding.alg.astar.AStarResult;
import cz.cuni.amis.pathfinding.map.IPFMap;
import cz.cuni.amis.pathfinding.map.IPFMapView;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.astar.UT2004PFGoal;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.astar.UT2004PFMap;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.List;

public class UT2004AStar
extends AStar<NavPoint>
implements IPathPlanner<NavPoint> {
    public UT2004AStar(UT2004Bot bot) {
        this(new UT2004PFMap((IWorldView)bot.getWorldView()));
    }

    public UT2004AStar(UT2004Bot bot, IPFMapView<NavPoint> view) {
        this(new UT2004PFMap((IWorldView)bot.getWorldView()), view);
    }

    public UT2004AStar(UT2004PFMap map) {
        this(map, (IPFMapView<NavPoint>)new IPFMapView.DefaultView());
    }

    public UT2004AStar(UT2004PFMap map, IPFMapView<NavPoint> view) {
        super((IPFMap)map, view);
    }

    public UT2004PFMap getMap() {
        return (UT2004PFMap)super.getMap();
    }

    public synchronized AStarResult<NavPoint> findPath(NavPoint from, NavPoint to, IPFMapView<NavPoint> mapView) {
        return this.findPath(new UT2004PFGoal(from, to), mapView);
    }

    public IPathFuture<NavPoint> computePath(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return new PrecomputedPathFuture((Object)from, (Object)to, null);
        }
        if (from == to) {
            return new PrecomputedPathFuture((Object)from, (Object)to, MyCollections.toList((Object[])new NavPoint[]{from}));
        }
        AStarResult<NavPoint> result = this.findPath(from, to);
        if (result == null) {
            return new PrecomputedPathFuture((Object)from, (Object)to, null);
        }
        return new PrecomputedPathFuture((Object)from, (Object)to, result.getPath());
    }

    public double getDistance(NavPoint from, NavPoint to) {
        IPathFuture<NavPoint> path = this.computePath(from, to);
        if (path.isDone()) {
            List list = path.get();
            if (list.size() == 0) {
                return 0.0;
            }
            double result = 0.0;
            NavPoint np = (NavPoint)list.get(0);
            int i = 1;
            while (i < list.size()) {
                NavPoint next = (NavPoint)list.get(i);
                result += np.getLocation().getDistance(next.getLocation());
                np = next;
                ++i;
            }
            return result;
        }
        return Double.POSITIVE_INFINITY;
    }

    public synchronized AStarResult<NavPoint> findPath(NavPoint from, NavPoint to) {
        return this.findPath(new UT2004PFGoal(from, to));
    }

    public void mapChanged() {
        this.getMap().mapChanged();
    }
}

