/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ManualControlWindow
extends JFrame {
    public boolean forward;
    public boolean backward;
    public boolean left;
    public boolean right;
    public IManualControlCallback callback;
    private JLabel label1;
    private JLabel label2;

    public ManualControlWindow() {
        this.setBounds(10, 10, 370, 90);
        this.setVisible(true);
        this.setLayout(null);
        this.label1 = new JLabel("Find bot in UT2004; focus this window and press 'h' for help.");
        this.label1.setBounds(5, 5, 400, 20);
        this.add(this.label1);
        this.label2 = new JLabel("ACTIVE");
        this.label2.setBounds(5, 25, 400, 20);
        this.add(this.label2);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case 'w': {
                        ManualControlWindow.this.forward = true;
                        break;
                    }
                    case 'a': {
                        ManualControlWindow.this.left = true;
                        break;
                    }
                    case 's': {
                        ManualControlWindow.this.backward = true;
                        break;
                    }
                    case 'd': {
                        ManualControlWindow.this.right = true;
                        break;
                    }
                    case ' ': {
                        ManualControlWindow.this.jump();
                        break;
                    }
                    case 'r': {
                        ManualControlWindow.this.raycast();
                        break;
                    }
                    case 't': {
                        ManualControlWindow.this.raycastNavmesh();
                        break;
                    }
                    case 'l': {
                        ManualControlWindow.this.drawLevelGeometry();
                        break;
                    }
                    case 'b': {
                        ManualControlWindow.this.drawLevelGeometryBSP();
                        break;
                    }
                    case 'v': {
                        ManualControlWindow.this.drawNavPointVisibility();
                        break;
                    }
                    case 'g': {
                        ManualControlWindow.this.drawNavPointVisibilityWorldView();
                        break;
                    }
                    case 'i': {
                        ManualControlWindow.this.drawItemsVisibility();
                        break;
                    }
                    case 'c': {
                        ManualControlWindow.this.drawClear();
                        break;
                    }
                    case 'n': {
                        ManualControlWindow.this.drawNavMesh();
                        break;
                    }
                    case 'm': {
                        ManualControlWindow.this.drawNavMeshWithLinks();
                        break;
                    }
                    case 'h': {
                        ManualControlWindow.this.help();
                        break;
                    }
                    case 'e': {
                        ManualControlWindow.this.toggleActive();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case 'w': {
                        ManualControlWindow.this.forward = false;
                        break;
                    }
                    case 'a': {
                        ManualControlWindow.this.left = false;
                        break;
                    }
                    case 's': {
                        ManualControlWindow.this.backward = false;
                        break;
                    }
                    case 'd': {
                        ManualControlWindow.this.right = false;
                    }
                }
            }
        });
    }

    protected void raycastNavmesh() {
        if (this.callback == null) {
            return;
        }
        this.callback.raycastNavMesh();
    }

    protected void toggleActive() {
        if (this.callback == null) {
            return;
        }
        this.callback.toggleActive();
        if (this.callback.isActive()) {
            this.callback.sendGlobalMessage("MANUAL CONTROL ACTIVATED");
            this.label2.setText("ACTIVE");
        } else {
            this.callback.sendGlobalMessage("MANUAL CONTROL DEACTIVATED");
            this.label2.setText("DEACTIVATED");
        }
    }

    protected void help() {
        if (this.callback == null) {
            return;
        }
        this.callback.sendGlobalMessage("Control: WSAD+Space, E - De/Activate");
        this.callback.sendGlobalMessage("Level geom - L; Level geom BSP - B; Raycast - R; I - items visibility");
        this.callback.sendGlobalMessage("NavMesh - N; NavMesh+Links - M; Raycast NavMesh - T; Clear - C");
    }

    protected void drawClear() {
        if (this.callback == null) {
            return;
        }
        this.callback.drawClear();
    }

    protected void drawLevelGeometryBSP() {
        if (this.callback == null) {
            return;
        }
        this.callback.drawLevelGeometryBSP();
    }

    protected void drawLevelGeometry() {
        if (this.callback == null) {
            return;
        }
        this.callback.drawLevelGeometry();
    }

    private void raycast() {
        if (this.callback == null) {
            return;
        }
        this.callback.raycast();
    }

    private void jump() {
        if (this.callback == null) {
            return;
        }
        this.callback.jump();
    }

    protected void drawNavPointVisibilityWorldView() {
        if (this.callback == null) {
            return;
        }
        this.callback.drawNavPointVisibilityWorldView();
    }

    protected void drawNavPointVisibility() {
        if (this.callback == null) {
            return;
        }
        this.callback.drawNavPointVisibility();
    }

    protected void drawNavMeshWithLinks() {
        if (this.callback == null) {
            return;
        }
        this.callback.drawNavMeshWithLinks();
    }

    protected void drawItemsVisibility() {
        if (this.callback == null) {
            return;
        }
        this.callback.drawItemsVisibility();
    }

    protected void drawNavMesh() {
        this.callback.drawNavMesh();
    }

    public static interface IManualControlCallback {
        public void jump();

        public void raycast();

        public void raycastNavMesh();

        public void drawLevelGeometry();

        public void drawLevelGeometryBSP();

        public void drawClear();

        public void drawNavPointVisibility();

        public void drawNavPointVisibilityWorldView();

        public void drawItemsVisibility();

        public void drawNavMesh();

        public void drawNavMeshWithLinks();

        public void sendGlobalMessage(String var1);

        public boolean isActive();

        public void toggleActive();
    }
}

