/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.bsp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import math.bsp.BspOccupation;
import math.bsp.IBspStrategy;
import math.bsp.node.IConstBspLeafNode;
import math.bsp.strat.BspListDataStrategy;
import math.geom2d.line.StraightLine2D;

public abstract class XyProjectionTPolygonPartitioningStrategy<TPolygon>
extends BspListDataStrategy<TPolygon, StraightLine2D>
implements IBspStrategy<ArrayList<TPolygon>, StraightLine2D> {
    public static int STOP_SPLITTING_NUMBER_OF_POLYGONS = 1;
    protected HashMap<TPolygon, ArrayList<math.geom2d.Point2D>> polygonToVertexLocationsMap = Maps.newHashMap();
    protected HashMap<TPolygon, math.geom2d.Point2D> polygonToVertexCenterMap = Maps.newHashMap();
    static ArrayList<math.geom2d.Point2D> trivialBoundaryOffsets = Lists.newArrayList();

    static {
        trivialBoundaryOffsets.add(new math.geom2d.Point2D(1.0, 0.0));
        trivialBoundaryOffsets.add(new math.geom2d.Point2D(1.0, 1.0));
        trivialBoundaryOffsets.add(new math.geom2d.Point2D(0.0, 1.0));
        trivialBoundaryOffsets.add(new math.geom2d.Point2D(-1.0, 1.0));
    }

    public void clearCache() {
        this.polygonToVertexLocationsMap.clear();
        this.polygonToVertexCenterMap.clear();
    }

    public boolean shouldSplit(IConstBspLeafNode<ArrayList<TPolygon>, StraightLine2D> leafNode) {
        return ((ArrayList)leafNode.getData()).size() > STOP_SPLITTING_NUMBER_OF_POLYGONS;
    }

    public StraightLine2D findBoundary(IConstBspLeafNode<ArrayList<TPolygon>, StraightLine2D> leafNode) {
        StraightLine2D bestBoundary = null;
        double bestBoundaryEliminationCount = 0.0;
        double sufficientEliminationFraction = this.getSufficientEliminationFraction();
        double totalPolygonCount = ((ArrayList)leafNode.getData()).size();
        math.geom2d.Point2D nodeDataCenter = this.getDataCenter((ArrayList)leafNode.getData());
        for (math.geom2d.Point2D trivialBoundaryOffset : trivialBoundaryOffsets) {
            StraightLine2D candidateBoundary = new StraightLine2D((Point2D)nodeDataCenter, (Point2D)nodeDataCenter.plus((Point2D)trivialBoundaryOffset));
            double candidateBoundaryEliminationCount = this.computeEliminationCount(candidateBoundary, (List)leafNode.getData());
            if (bestBoundaryEliminationCount < candidateBoundaryEliminationCount) {
                bestBoundary = candidateBoundary;
                bestBoundaryEliminationCount = candidateBoundaryEliminationCount;
            }
            if (!(bestBoundaryEliminationCount > totalPolygonCount * sufficientEliminationFraction)) continue;
            return bestBoundary;
        }
        for (Object splittingPolygon : (ArrayList)leafNode.getData()) {
            ArrayList<math.geom2d.Point2D> vertices = this.getPolygonVertices(splittingPolygon);
            int i = 0;
            while (i < vertices.size()) {
                math.geom2d.Point2D b;
                math.geom2d.Point2D a = (math.geom2d.Point2D)vertices.get(i);
                StraightLine2D candidateBoundary = new StraightLine2D((Point2D)a, (Point2D)(b = (math.geom2d.Point2D)vertices.get((i + 1) % vertices.size())));
                double candidateBoundaryEliminationCount = this.computeEliminationCount(candidateBoundary, (List)leafNode.getData());
                if (bestBoundaryEliminationCount < candidateBoundaryEliminationCount) {
                    bestBoundary = candidateBoundary;
                    bestBoundaryEliminationCount = candidateBoundaryEliminationCount;
                }
                if (bestBoundaryEliminationCount > totalPolygonCount * sufficientEliminationFraction) {
                    return bestBoundary;
                }
                ++i;
            }
        }
        return bestBoundary;
    }

    public double computeEliminationCount(StraightLine2D boundary, List<TPolygon> polygons) {
        double totalPolygonCount = polygons.size();
        double negativeSidePolygonCount = 0.0;
        double positiveSidePolygonCount = 0.0;
        for (TPolygon polygon : polygons) {
            BspOccupation occupation = this.determineElementOccupation(boundary, polygon);
            if (occupation.intersectsNegative()) {
                negativeSidePolygonCount += 1.0;
            }
            if (!occupation.intersectsPositive()) continue;
            positiveSidePolygonCount += 1.0;
        }
        return Math.min(totalPolygonCount - negativeSidePolygonCount, totalPolygonCount - positiveSidePolygonCount);
    }

    public BspOccupation determineElementOccupation(StraightLine2D boundary, TPolygon element) {
        boolean intersectsPositive = false;
        boolean intersectsNegative = false;
        for (math.geom2d.Point2D vertex : this.getPolygonVertices(element)) {
            BspOccupation vertexOccupation = this.determinePointOccupation(boundary, vertex);
            intersectsPositive = intersectsPositive || vertexOccupation.intersectsPositive();
            boolean bl = intersectsNegative = intersectsNegative || vertexOccupation.intersectsNegative();
        }
        return BspOccupation.get((boolean)intersectsNegative, (boolean)intersectsPositive);
    }

    public BspOccupation determinePointOccupation(StraightLine2D boundary, math.geom2d.Point2D point) {
        if (boundary.getSignedDistance((Point2D)point) >= 0.0) {
            return BspOccupation.POSITIVE;
        }
        return BspOccupation.NEGATIVE;
    }

    protected math.geom2d.Point2D getDataCenter(ArrayList<TPolygon> polygons) {
        double x = 0.0;
        double y = 0.0;
        for (TPolygon polygon : polygons) {
            math.geom2d.Point2D polygonCenter = this.getPolygonVertexCenter(polygon);
            x += polygonCenter.getX();
            y += polygonCenter.getY();
        }
        return new math.geom2d.Point2D(x / (double)polygons.size(), y / (double)polygons.size());
    }

    protected math.geom2d.Point2D projectToXyPlane(Location point) {
        return new math.geom2d.Point2D(point.getX(), point.getY());
    }

    protected ArrayList<math.geom2d.Point2D> getPolygonVertices(TPolygon polygon) {
        if (this.polygonToVertexLocationsMap.containsKey(polygon)) {
            return this.polygonToVertexLocationsMap.get(polygon);
        }
        ArrayList locations = Lists.newArrayList();
        for (Location location : this.getPolygonVerticesUncached(polygon)) {
            locations.add(this.projectToXyPlane(location));
        }
        this.polygonToVertexLocationsMap.put(polygon, locations);
        return locations;
    }

    protected double getSufficientEliminationFraction() {
        return 0.49;
    }

    protected math.geom2d.Point2D getPolygonVertexCenter(TPolygon polygon) {
        if (this.polygonToVertexCenterMap.containsKey(polygon)) {
            return this.polygonToVertexCenterMap.get(polygon);
        }
        double x = 0.0;
        double y = 0.0;
        ArrayList<math.geom2d.Point2D> vertices = this.getPolygonVertices(polygon);
        for (math.geom2d.Point2D vertex : vertices) {
            x += vertex.x;
            y += vertex.y;
        }
        math.geom2d.Point2D center = new math.geom2d.Point2D(x / (double)vertices.size(), y / (double)vertices.size());
        this.polygonToVertexCenterMap.put(polygon, center);
        return center;
    }

    protected abstract ArrayList<Location> getPolygonVerticesUncached(TPolygon var1);
}

