/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder.NavMeshDropGrounder;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.NavMeshPathTracer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.RayPath;
import java.util.NoSuchElementException;
import math.geom2d.Vector2D;

public class NavMeshClearanceComputer {
    protected NavMeshDropGrounder dropGrounder;

    public NavMeshClearanceComputer(NavMeshDropGrounder dropGrounder) {
        this.dropGrounder = dropGrounder;
    }

    public ClearanceLimit findEdge(final Location start, Vector2D direction, final double maxDistance, double maxDropDistance) {
        assert (maxDistance > 0.0);
        NavMeshPolygon sourcePolygon = this.dropGrounder.getPolygonBelow(start, maxDropDistance);
        if (sourcePolygon == null) {
            return new ClearanceLimit(null, start);
        }
        Predicate<RayPath<NavMeshPolygon, NavMeshEdge>> keepTracingPredicate = new Predicate<RayPath<NavMeshPolygon, NavMeshEdge>>(){

            public boolean apply(RayPath<NavMeshPolygon, NavMeshEdge> rayPath) {
                return ((RayPath.PathStep)Iterables.getLast(rayPath.getSteps())).getIntersection().getDistance(start) < maxDistance;
            }
        };
        RayPath<NavMeshPolygon, NavMeshEdge> rayPath = NavMeshPathTracer.trace(sourcePolygon, start, direction, keepTracingPredicate);
        RayPath.PathStep lastStep = null;
        try {
            lastStep = (RayPath.PathStep)Iterables.getLast(rayPath.getSteps());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (lastStep == null) {
            return new ClearanceLimit(null, start);
        }
        if (lastStep.getPolygon() == null) {
            return new ClearanceLimit((NavMeshEdge)lastStep.getEdge(), lastStep.getIntersection());
        }
        return null;
    }

    public ClearanceLimit findEdge(Location start, Vector2D direction) {
        return this.findEdge(start, direction, Double.POSITIVE_INFINITY, 100.0);
    }

    public double computeXyProjectionDistanceFromEdge(Location start, Vector2D direction, double maxDistance, double maxDropDistance) {
        assert (maxDistance > 0.0);
        Location clearanceLimitLocation = this.findEdge(start, direction, maxDistance, maxDropDistance).getLocation();
        if (clearanceLimitLocation == start) {
            return 0.0;
        }
        if (clearanceLimitLocation == null) {
            return maxDistance;
        }
        return Math.min(start.getDistance(clearanceLimitLocation), maxDistance);
    }

    public double computeXyProjectionDistanceFromEdge(Location start, Vector2D vector, double maxDistance) {
        return this.computeXyProjectionDistanceFromEdge(start, vector, maxDistance, 100.0);
    }

    public double computeXyProjectionDistanceFromEdge(Location start, Vector2D vector) {
        return this.computeXyProjectionDistanceFromEdge(start, vector, Double.POSITIVE_INFINITY, 100.0);
    }

    public static class ClearanceLimit {
        protected NavMeshEdge edge;
        protected Location location;

        public ClearanceLimit(NavMeshEdge edge, Location location) {
            this.edge = edge;
            this.location = location;
        }

        public NavMeshEdge getEdge() {
            return this.edge;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

