/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry;

import com.google.inject.internal.Lists;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import math.geom3d.Point3D;

public class RawLevelGeometryFile {
    public ArrayList<RawTriangle> triangles = Lists.newArrayList();

    public RawLevelGeometryFile(String coreFilename, Logger log) throws IOException {
        try (BufferedReader bufferedReader = null;){
            try {
                bufferedReader = new BufferedReader(new FileReader(String.valueOf(coreFilename) + ".scale"));
                double scale = Double.parseDouble(bufferedReader.readLine());
                bufferedReader.close();
                bufferedReader = new BufferedReader(new FileReader(String.valueOf(coreFilename) + ".centre"));
                String[] sc = bufferedReader.readLine().split("[ \\t]");
                if (sc.length < 3) {
                    throw new IOException("Centre file invalid.");
                }
                double[] center = new double[3];
                int i = 0;
                while (i < 3) {
                    center[i] = Double.parseDouble(sc[i]);
                    ++i;
                }
                bufferedReader.close();
                ArrayList vertices = Lists.newArrayList();
                bufferedReader = new BufferedReader(new FileReader(String.valueOf(coreFilename) + ".obj"));
                String line = bufferedReader.readLine();
                while (line != null) {
                    String[] words = line.split("[ \\t]");
                    if (words[0].equals("v")) {
                        if (words.length < 4) {
                            throw new IOException("Invalid vertex.");
                        }
                        double[] v = new double[]{Double.parseDouble(words[1]) * scale + center[0], Double.parseDouble(words[3]) * scale + center[1], Double.parseDouble(words[2]) * scale + center[2]};
                        vertices.add(new Point3D(v[0], v[1], v[2]));
                    } else if (words[0].equals("f")) {
                        if (words.length < 4) {
                            throw new IOException("Invalid triangle.");
                        }
                        int[] t = new int[]{Integer.parseInt(words[1]) - 1, Integer.parseInt(words[2]) - 1, Integer.parseInt(words[3]) - 1};
                        RawTriangle triangle = new RawTriangle((Point3D)vertices.get(t[0]), (Point3D)vertices.get(t[1]), (Point3D)vertices.get(t[2]));
                        this.triangles.add(triangle);
                    } else {
                        throw new IOException("Unrecognized line.");
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (FileNotFoundException e) {
                throw new IOException("Required raw geometry file not found.", e);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid raw geometry file format.", e);
            }
        }
    }

    public static class RawTriangle {
        public final Point3D[] vertices;

        public RawTriangle(Point3D a, Point3D b, Point3D c) {
            this.vertices = new Point3D[]{a, b, c};
        }
    }
}

