/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.storyworld.place;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.storyworld.perception.SPLocation;
import cz.cuni.amis.pogamut.ut2004.storyworld.place.SPStoryPlace;
import cz.cuni.amis.pogamut.ut2004.storyworld.place.SPStoryPlaceBase;
import cz.cuni.amis.pogamut.ut2004.storyworld.place.SPStoryWorldData;
import cz.cuni.amis.utils.Job;
import cz.cuni.amis.utils.maps.HashMapSet;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.vecmath.Point3d;

public class SPStoryWorld {
    private static final double NEAR = 1000.0;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private Map<Token, SPStoryPlace> places;
    private Map<Token, SPStoryPlaceBase> bases;
    private Map<Token, SPStoryPlace> allPlaces = null;
    private Set<NavPoint> navPoints = null;
    private Map<String, NavPoint> navPointsMap = null;
    private HashMapSet<UnrealId, SPStoryPlaceBase> navPointIdToBasePlace = null;
    private IWorldEventListener<MapPointListObtained> mapPointsListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            SPStoryWorld.this.mapPointsList(event);
            new Job<Boolean>(){

                protected void job() throws Exception {
                    this.setResult(true);
                }
            }.startJob();
        }
    };
    private IWorldView worldView;
    private FloydWarshallMap navigation;
    private Logger log;
    private SPStoryWorldData data;

    public SPStoryWorld(String worldXMLDefinitionFile, IWorldView ww, Logger log) throws FileNotFoundException {
        this(SPStoryWorldData.loadXML(new File(worldXMLDefinitionFile)), ww, log);
    }

    public SPStoryWorld(File worldXMLDefinition, IWorldView ww, Logger log) throws FileNotFoundException {
        this(SPStoryWorldData.loadXML(worldXMLDefinition), ww, log);
    }

    public SPStoryWorld(SPStoryWorldData data, IWorldView ww, Logger log) {
        this.log = log;
        this.data = data;
        this.places = data.getPlaces();
        this.bases = data.getBases();
        this.worldView = ww;
        this.worldView.addEventListener(MapPointListObtained.class, this.mapPointsListener);
    }

    private void mapPointsList(MapPointListObtained map) {
        for (SPStoryPlaceBase placeBase : this.bases.values()) {
            placeBase.bountNavPoints(map);
        }
        this.getNavPoints();
        this.getNavPointsToPlaceMap();
    }

    public SPStoryPlace getPlace(Token name) {
        return this.getAllPlaces().get(name);
    }

    public SPStoryPlace getPlace(String name) {
        return this.getAllPlaces().get(Tokens.get((String)name));
    }

    public SPStoryPlaceBase getBase(Token name) {
        return this.bases.get(name);
    }

    public NavPoint getNavPoint(String id) {
        return this.navPointsMap.get(id);
    }

    public SPStoryPlaceBase getBase(String name) {
        return this.bases.get(Tokens.get((String)name));
    }

    public Set<SPStoryPlaceBase> getBase(UnrealId navPointId) {
        Set bases = this.getNavPointsToPlaceMap().get((Object)navPointId);
        if (bases == null || bases.size() == 0) {
            throw new RuntimeException("story base place hasn't been found for nav point " + navPointId);
        }
        return bases;
    }

    public Set<SPStoryPlaceBase> at(SPLocation location) {
        NavPoint nearest = this.getNearestNavPoint(location);
        if (location.asPoint3d().distance(nearest.getLocation().getPoint3d()) > 1000.0) {
            return EMPTY_SET;
        }
        return this.getBase(nearest.getId());
    }

    public NavPoint getNearestNavPoint(SPLocation location) {
        Point3d loc = location.asPoint3d();
        double nearestDistance = Double.MAX_VALUE;
        NavPoint nearest = null;
        for (NavPoint navPoint : this.getNavPoints()) {
            try {
                double distance = loc.distance(navPoint.getLocation().getPoint3d());
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearest = navPoint;
            }
            catch (NullPointerException npe) {}
        }
        return nearest;
    }

    public NavPoint getFurthestNavPoint(SPLocation location) {
        Point3d loc = location.asPoint3d();
        double furthestDistance = Double.MAX_VALUE;
        NavPoint furthest = null;
        for (NavPoint navPoint : this.getNavPoints()) {
            double distance = loc.distance(navPoint.getLocation().getPoint3d());
            if (!(distance > furthestDistance)) continue;
            furthestDistance = distance;
            furthest = navPoint;
        }
        return furthest;
    }

    public boolean isInside(SPLocation location, SPStoryPlace place) {
        Set<SPStoryPlaceBase> bases = this.at(location);
        if (bases == null || bases.size() == 0) {
            return false;
        }
        for (SPStoryPlaceBase base : bases) {
            if (!base.contains(place)) continue;
            return true;
        }
        return false;
    }

    public Set<NavPoint> getNavPoints() {
        if (this.navPoints == null) {
            this.navPoints = new HashSet<NavPoint>();
            this.navPointsMap = new HashMap<String, NavPoint>();
            for (SPStoryPlaceBase base : this.bases.values()) {
                for (NavPoint np : base.getNavPoints()) {
                    this.navPointsMap.put(np.getId().getStringId(), np);
                }
                this.navPoints.addAll(base.getNavPoints());
            }
        }
        return this.navPoints;
    }

    protected HashMapSet<UnrealId, SPStoryPlaceBase> getNavPointsToPlaceMap() {
        if (this.navPointIdToBasePlace == null) {
            this.navPointIdToBasePlace = new HashMapSet();
            for (SPStoryPlaceBase base : this.bases.values()) {
                for (NavPoint navPoint : base.getNavPoints()) {
                    this.navPointIdToBasePlace.add((Object)navPoint.getId(), (Object)base);
                }
            }
        }
        return this.navPointIdToBasePlace;
    }

    protected Map<Token, SPStoryPlace> getAllPlaces() {
        if (this.allPlaces == null) {
            this.allPlaces = new HashMap<Token, SPStoryPlace>();
            for (SPStoryPlace place : this.places.values()) {
                this.allPlaces.put(place.getName(), place);
            }
            for (SPStoryPlaceBase base : this.bases.values()) {
                this.allPlaces.put(base.getName(), base);
            }
        }
        return this.allPlaces;
    }

    public FloydWarshallMap getNavigation() {
        return this.navigation;
    }

    public List<NavPoint> getPath(SPLocation from, SPLocation to) {
        return this.getPath(from, this.getNearestNavPoint(to));
    }

    public List<NavPoint> getPath(SPLocation from, NavPoint to) {
        return this.getNavigation().getPath(this.getNearestNavPoint(from), to);
    }

    public List<NavPoint> getPath(SPLocation from, SPStoryPlace place) {
        NavPoint start = this.getNearestNavPoint(from);
        double shortestPath = Double.POSITIVE_INFINITY;
        List<NavPoint> path = null;
        for (NavPoint np : place.getNavPoints()) {
            double distance = this.getNavigation().getDistance(start, np);
            if (!(shortestPath > distance)) continue;
            shortestPath = distance;
            path = this.getNavigation().getPath(start, np);
        }
        return path;
    }

    public SPStoryWorldData getStoryWorldData() {
        return this.data;
    }

    public String toString() {
        return "SPStoryWorld";
    }
}

