/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004EdgeChecker;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.AStarNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshBSPNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshCore;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import math.geom2d.line.Line2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.plane.Plane3D;

public class NavMesh
implements IPathPlanner<ILocated> {
    private IWorldView worldView;
    private Logger log;
    private Random random;
    private boolean loaded = false;
    private GameInfo loadedForMap = null;
    private ArrayList<double[]> verts = new ArrayList();
    private ArrayList<int[]> polys = new ArrayList();
    private ArrayList<ArrayList<Integer>> vertsToPolys;
    private ArrayList<Boolean> safeVertex;
    private NavMeshBSPNode bspTree;
    private NavMeshBSPNode biggestLeafInTree;
    private ArrayList<OffMeshPoint> offMeshPoints;
    private ArrayList<ArrayList<OffMeshPoint>> polysToOffMeshPoints;
    private Map<UnrealId, NavPoint> nps = null;
    private FloydWarshallMap fwMap;
    private boolean isFwMapAvailable = false;
    private boolean hasTeleports = false;

    public NavMesh(IWorldView worldView, Logger log) {
        this.log = log;
        if (this.log == null) {
            this.log = new LogCategory("NavMesh");
        }
        this.random = new Random();
        this.worldView = worldView;
        NullCheck.check((Object)worldView, (String)"worldView");
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int polyCount() {
        return this.polys.size();
    }

    public int vertCount() {
        return this.verts.size();
    }

    public ArrayList<int[]> getPolys() {
        return this.polys;
    }

    public ArrayList<double[]> getVerts() {
        return this.verts;
    }

    public int[] getPolygon(int polygonId) {
        int[] p = (int[])this.polys.get(polygonId).clone();
        return p;
    }

    public double[] getVertex(int vertexId) {
        double[] v = (double[])this.verts.get(vertexId).clone();
        return v;
    }

    public ArrayList<Integer> getPolygonsByVertex(int vertexId) {
        return (ArrayList)this.vertsToPolys.get(vertexId).clone();
    }

    public ArrayList<Integer> getNeighbourIdsToPolygon(int polygonId) {
        ArrayList<Integer> neighbours = new ArrayList<Integer>();
        int[] p = this.getPolygon(polygonId);
        for (int j = 0; j < p.length; ++j) {
            ArrayList<Integer> p2 = this.getPolygonsByVertex(p[j]);
            block1: for (int k = 0; k < p2.size(); ++k) {
                int candidateId = p2.get(k);
                int secondVertex = p[j == p.length - 1 ? 0 : j + 1];
                int[] candidatePolygon = this.getPolygon(candidateId);
                for (int l = 0; l < candidatePolygon.length; ++l) {
                    if (candidatePolygon[l] != secondVertex) continue;
                    if (neighbours.contains(candidateId) || candidateId == polygonId) continue block1;
                    neighbours.add(candidateId);
                    continue block1;
                }
            }
        }
        return neighbours;
    }

    public ArrayList<OffMeshPoint> getOffMeshPoints() {
        return this.offMeshPoints;
    }

    public List<OffMeshPoint> getOffMeshPointsOnPolygon(int polygonId) {
        return this.polysToOffMeshPoints.get(polygonId);
    }

    public int getNumberOfPolygonsInBiggestLeaf() {
        if (this.biggestLeafInTree != null) {
            return this.biggestLeafInTree.polys.size();
        }
        return -1;
    }

    public void setBiggestLeafInTree(NavMeshBSPNode node) {
        this.biggestLeafInTree = node;
    }

    public int getPolygonId(Point3D point3D) {
        math.geom2d.Point2D point2D = new math.geom2d.Point2D(point3D.getX(), point3D.getY());
        NavMeshBSPNode node = this.bspTree;
        while (!node.isLeaf()) {
            StraightLine2D sepLine = node.sepLine;
            double dist = sepLine.getSignedDistance((Point2D)point2D);
            if (dist < 0.0) {
                node = node.left;
            }
            if (dist > 0.0) {
                node = node.right;
            }
            if (dist != 0.0) continue;
            point2D = new math.geom2d.Point2D(point3D.getX() + this.random.nextDouble() - 0.5, point3D.getY() + this.random.nextDouble() - 0.5);
        }
        ArrayList<Integer> candidatePolygons = new ArrayList<Integer>();
        for (int i = 0; i < node.polys.size(); ++i) {
            Integer pId = (Integer)node.polys.get(i);
            if (!this.polygonContainsPoint(pId, point2D)) continue;
            candidatePolygons.add(pId);
        }
        if (candidatePolygons.isEmpty()) {
            return -1;
        }
        double minDist = NavMeshConstants.maxDistanceBotPolygon;
        int retPId = -2;
        for (int i = 0; i < candidatePolygons.size(); ++i) {
            double[] v3;
            Vector3D vector2;
            double[] v2;
            Vector3D vector1;
            Integer pId = (Integer)candidatePolygons.get(i);
            int[] polygon = this.getPolygon(pId);
            double[] v1 = this.getVertex(polygon[0]);
            Point3D p1 = new Point3D(v1[0], v1[1], v1[2]);
            Plane3D plane = new Plane3D(p1, vector1 = new Vector3D((v2 = this.getVertex(polygon[1]))[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]), vector2 = new Vector3D((v3 = this.getVertex(polygon[2]))[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]));
            double dist = plane.getDistance(point3D);
            if (!(dist < minDist)) continue;
            if (polygon.length > 3) {
                v1 = this.getVertex(polygon[0]);
                p1 = new Point3D(v1[0], v1[1], v1[2]);
                plane = new Plane3D(p1, vector1 = new Vector3D((v2 = this.getVertex(polygon[1]))[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]), vector2 = new Vector3D((v3 = this.getVertex(polygon[3]))[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]));
                dist = plane.getDistance(point3D);
                if (!(dist < minDist)) continue;
                if (polygon.length > 4) {
                    v1 = this.getVertex(polygon[0]);
                    p1 = new Point3D(v1[0], v1[1], v1[2]);
                    plane = new Plane3D(p1, vector1 = new Vector3D((v2 = this.getVertex(polygon[2]))[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]), vector2 = new Vector3D((v3 = this.getVertex(polygon[4]))[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]));
                    dist = plane.getDistance(point3D);
                    if (!(dist < minDist)) continue;
                    retPId = pId;
                    minDist = dist;
                    continue;
                }
                retPId = pId;
                minDist = dist;
                continue;
            }
            retPId = pId;
            minDist = dist;
        }
        this.log.fine("Distance of a point from polygon " + retPId + " is " + minDist);
        return retPId;
    }

    public int getPolygonId(Location location) {
        return this.getPolygonId(new Point3D(location.x, location.y, location.z));
    }

    public boolean load(GameInfo info, boolean shouldReloadNavMesh) {
        File pureMeshFile;
        String mapName;
        block16: {
            if (info == null) {
                this.log.severe("Could not load for 'null' GameInfo!");
                return false;
            }
            if (this.loaded) {
                if (this.loadedForMap == null) {
                    this.clear();
                } else if (this.loadedForMap.getLevel().equals(info.getLevel())) {
                    return true;
                }
            }
            mapName = info.getLevel();
            this.log.warning("Loading NavMesh for: " + mapName);
            String processedNavMeshFileName = NavMeshConstants.processedMeshDir + "/" + mapName + ".navmesh.processed";
            File processedNavMeshFile = new File(processedNavMeshFileName);
            String pureMeshFileName = NavMeshConstants.pureMeshReadDir + "/" + mapName + ".navmesh";
            pureMeshFile = new File(pureMeshFileName);
            if (shouldReloadNavMesh && processedNavMeshFile.exists() && processedNavMeshFile.isFile()) {
                if (pureMeshFile.exists() && pureMeshFile.isFile()) {
                    this.log.warning("Going to RELOAD / REPROCESS navmesh.");
                    this.log.warning("Deleting old processed navmesh file: " + processedNavMeshFile.getAbsolutePath());
                    processedNavMeshFile.delete();
                } else {
                    this.log.warning("NavMesh RELOAD flag true, but .navmesh file for a given map not found (at " + pureMeshFile.getAbsolutePath() + "), going to load .navmesh.processed file.");
                }
            }
            try {
                if (!processedNavMeshFile.exists()) {
                    if (!shouldReloadNavMesh) {
                        this.log.warning("Processed NavMesh does not exist at: " + processedNavMeshFile.getAbsolutePath());
                    }
                    break block16;
                }
                this.loadNavMeshFromCoreFile(processedNavMeshFile);
                this.log.warning("NavMesh LOADED SUCCESSFULLY.");
                this.loaded = true;
                this.loadedForMap = info;
                return true;
            }
            catch (Exception e) {
                this.log.warning(ExceptionToString.process((String)("NavMesh could not be loaded from previously stored binary file: " + processedNavMeshFile.getAbsolutePath()), (Throwable)e));
            }
        }
        try {
            if (!pureMeshFile.exists()) {
                this.log.warning("NavMesh source text file does not exist at: " + pureMeshFile.getAbsolutePath());
                this.log.severe("NavMesh COULD NOT INITIALIZE FOR MAP: " + mapName);
                return false;
            }
            this.loadSourceFile(pureMeshFile);
        }
        catch (Exception e) {
            this.log.warning(ExceptionToString.process((String)("NavMesh could not be loaded from source text file: " + pureMeshFile.getAbsolutePath()), (Throwable)e));
            this.log.severe("NavMesh COULD NOT HAVE BEEN INITIALIZED FOR MAP: " + mapName);
            return false;
        }
        this.resetVertsToPolys();
        this.resetSafeVerts();
        this.resetBSPTree();
        if (!this.eliminateUnreachablePolygons()) {
            return false;
        }
        this.resetOffMeshConnections();
        this.saveNavMeshCore(mapName);
        this.loaded = true;
        this.loadedForMap = info;
        return true;
    }

    protected void loadNavMeshFromCoreFile(File processedNavMeshFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.log.warning("Loading previously stored NavMesh from binary file: " + processedNavMeshFile.getAbsolutePath());
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(processedNavMeshFile));
        NavMeshCore core = (NavMeshCore)in.readObject();
        this.biggestLeafInTree = core.biggestLeafInTree;
        this.bspTree = core.bspTree;
        this.polys = core.polys;
        this.verts = core.verts;
        this.vertsToPolys = core.vertsToPolys;
        this.offMeshPoints = core.offMeshPoints;
        this.polysToOffMeshPoints = core.polysToOffMeshPoints;
        this.safeVertex = core.safeVertex;
    }

    protected void loadSourceFile(File pureMeshFile) throws NumberFormatException, IOException {
        String line;
        this.log.warning("Loading NavMesh from text file: " + pureMeshFile.getAbsolutePath());
        BufferedReader br = new BufferedReader(new FileReader(pureMeshFile));
        while ((line = br.readLine()) != null) {
            String[] toks = line.split("[ \\t]");
            if (toks[0].equals("v")) {
                double[] v = new double[]{Double.parseDouble(toks[1]), Double.parseDouble(toks[2]), Double.parseDouble(toks[3])};
                this.verts.add(v);
            }
            if (!toks[0].equals("p")) continue;
            int[] p = new int[toks.length - 1];
            for (int i = 0; i < toks.length - 1; ++i) {
                p[i] = Integer.parseInt(toks[i + 1]);
            }
            this.polys.add(p);
        }
    }

    protected void resetVertsToPolys() {
        int i;
        this.log.info("Setting vertsToPolys mapping array...");
        this.vertsToPolys = new ArrayList();
        for (i = 0; i < this.verts.size(); ++i) {
            this.vertsToPolys.add(new ArrayList());
        }
        for (i = 0; i < this.polys.size(); ++i) {
            int[] p = this.polys.get(i);
            for (int j = 0; j < p.length; ++j) {
                ArrayList<Integer> p2 = this.vertsToPolys.get(p[j]);
                if (p2.contains(i)) continue;
                p2.add(i);
            }
        }
    }

    protected void resetSafeVerts() {
        this.log.info("Setting safe vertices...");
        this.safeVertex = new ArrayList();
        int safeCount = 0;
        for (int v1 = 0; v1 < this.verts.size(); ++v1) {
            this.log.fine("Looking at vertex " + v1 + "...");
            double sum = 0.0;
            ArrayList<Integer> polys = this.vertsToPolys.get(v1);
            for (Integer pId : polys) {
                int[] polygon = this.getPolygon(pId);
                int v0 = -1;
                int v2 = -1;
                for (int i = 0; i < polygon.length; ++i) {
                    if (polygon[i] != v1) continue;
                    v0 = i == 0 ? polygon[polygon.length - 1] : polygon[i - 1];
                    v2 = i == polygon.length - 1 ? polygon[0] : polygon[i + 1];
                    break;
                }
                double[] vv0 = this.getVertex(v0);
                double[] vv1 = this.getVertex(v1);
                double[] vv2 = this.getVertex(v2);
                double a = Math.sqrt((vv1[0] - vv0[0]) * (vv1[0] - vv0[0]) + (vv1[1] - vv0[1]) * (vv1[1] - vv0[1]) + (vv1[2] - vv0[2]) * (vv1[2] - vv0[2]));
                double b = Math.sqrt((vv2[0] - vv1[0]) * (vv2[0] - vv1[0]) + (vv2[1] - vv1[1]) * (vv2[1] - vv1[1]) + (vv2[2] - vv1[2]) * (vv2[2] - vv1[2]));
                double c = Math.sqrt((vv2[0] - vv0[0]) * (vv2[0] - vv0[0]) + (vv2[1] - vv0[1]) * (vv2[1] - vv0[1]) + (vv2[2] - vv0[2]) * (vv2[2] - vv0[2]));
                double gama = Math.acos((a * a + b * b - c * c) / (2.0 * a * b));
                this.log.fine("Angle gama is " + gama);
                sum += gama;
            }
            this.log.fine("Sum angle is " + sum);
            if (sum >= 6.28) {
                this.safeVertex.add(v1, true);
                ++safeCount;
                continue;
            }
            this.safeVertex.add(v1, false);
        }
        this.log.info("There are " + safeCount + " safe and " + (this.verts.size() + safeCount) + " unsafe vertices.");
    }

    protected void resetBSPTree() {
        this.log.info("Creating BSP tree...");
        this.bspTree = new NavMeshBSPNode(this, null);
        for (int i = 0; i < this.polys.size(); ++i) {
            this.bspTree.polys.add(i);
        }
        this.biggestLeafInTree = null;
        this.bspTree.build();
        this.log.info("BSP tree for NavMesh polygons has been built. Biggest leaf has " + this.biggestLeafInTree.polys.size() + " polygons.");
    }

    protected boolean eliminateUnreachablePolygons() {
        int i;
        this.log.info("eliminateUnreachablePolygons() starts...");
        Map navPoints = this.nps;
        if (navPoints == null) {
            navPoints = this.worldView.getAll(NavPoint.class);
        }
        if (navPoints == null || navPoints.size() == 0) {
            this.log.warning("There are no navpoints present within the worldview, could not eliminateUnreachablePolygons() ...");
            return false;
        }
        boolean[] reachable = new boolean[this.polys.size()];
        this.log.info("Marking reachable polygons...");
        for (NavPoint navPoint : navPoints.values()) {
            Point3D point3D = navPoint.getLocation().asPoint3D();
            int pId = this.getPolygonId(point3D);
            if (pId < 0) continue;
            this.markAsReachableRecursive(pId, reachable);
        }
        int reachableCount = 0;
        int polyDelCount = 0;
        int vertDelCount = 0;
        for (i = 0; i < this.polys.size(); ++i) {
            if (!reachable[i]) continue;
            ++reachableCount;
        }
        if (this.polys.size() == reachableCount) {
            this.log.warning("Marking complete. All " + reachableCount + " polygons are reachable, no need to delete anything.");
            return true;
        }
        this.log.warning("Marking complete. There are " + reachableCount + " reachable polygons and " + (this.polys.size() - reachableCount) + " unreachable polygons.");
        this.log.warning("Deleting unreachable polygons...");
        for (i = this.polys.size() - 1; i >= 0; --i) {
            if (reachable[i]) continue;
            this.polys.remove(i);
            ++polyDelCount;
        }
        this.resetVertsToPolys();
        this.log.warning("Deleting unused vertices...");
        for (i = this.vertsToPolys.size() - 1; i >= 0; --i) {
            ArrayList<Integer> polygons = this.vertsToPolys.get(i);
            if (!polygons.isEmpty()) continue;
            this.verts.remove(i);
            ++vertDelCount;
            for (int j = 0; j < this.polys.size(); ++j) {
                int[] polygon = this.polys.get(j);
                for (int k = 0; k < polygon.length; ++k) {
                    if (polygon[k] <= i) continue;
                    int n = k;
                    polygon[n] = polygon[n] - 1;
                }
            }
        }
        this.log.warning("Deleting done. " + polyDelCount + " polygons and " + vertDelCount + " vertices were deleted.");
        this.resetVertsToPolys();
        this.resetSafeVerts();
        this.resetBSPTree();
        return true;
    }

    private void markAsReachableRecursive(int pId, boolean[] reachable) {
        if (reachable[pId]) {
            return;
        }
        reachable[pId] = true;
        ArrayList<Integer> neighbours = this.getNeighbourIdsToPolygon(pId);
        for (int i = 0; i < neighbours.size(); ++i) {
            this.markAsReachableRecursive(neighbours.get(i), reachable);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void resetOffMeshConnections() {
        void var4_10;
        UnrealId uId;
        NavPoint np;
        this.log.info("Creating off-mesh connections...");
        HashMap<UnrealId, OffMeshPoint> offPoints = new HashMap<UnrealId, OffMeshPoint>();
        Map navPoints = this.nps;
        if (navPoints == null) {
            navPoints = this.worldView.getAll(NavPoint.class);
        }
        for (Map.Entry<UnrealId, NavPoint> entry : navPoints.entrySet()) {
            np = entry.getValue();
            uId = entry.getKey();
            int pId = this.getPolygonId(np.getLocation().asPoint3D());
            if (np.isLiftCenter()) {
                pId = -1;
            }
            OffMeshPoint op = new OffMeshPoint(np, pId);
            offPoints.put(uId, op);
        }
        for (Map.Entry<Object, NavPoint> entry : navPoints.entrySet()) {
            np = entry.getValue();
            uId = (UnrealId)entry.getKey();
            for (Map.Entry<UnrealId, NavPointNeighbourLink> entry2 : np.getOutgoingEdges().entrySet()) {
                NavPointNeighbourLink link = entry2.getValue();
                UnrealId uId2 = entry2.getKey();
                NavPoint target = link.getToNavPoint();
                this.log.fine("Checking edge from navpoint " + uId + " to navpoint " + target.getId() + "...");
                boolean forceIgnore = false;
                boolean forceAdd = false;
                boolean addThisEdge = false;
                if (np.isLiftCenter()) {
                    forceAdd = true;
                }
                if (target.isLiftCenter()) {
                    forceAdd = true;
                }
                boolean bl = forceIgnore = !UT2004EdgeChecker.checkLink(link);
                if (!forceAdd && !forceIgnore) {
                    Line2D linkAsLine2D = new Line2D(link.getFromNavPoint().getLocation().x, link.getFromNavPoint().getLocation().y, link.getToNavPoint().getLocation().x, link.getToNavPoint().getLocation().y);
                    int currentPolygonId = this.getPolygonId(link.getFromNavPoint().getLocation().asPoint3D());
                    int targetPolygonId = this.getPolygonId(link.getToNavPoint().getLocation().asPoint3D());
                    int tabooPolygon = -1;
                    while (currentPolygonId >= 0 && currentPolygonId != targetPolygonId) {
                        int newPolygon = -1;
                        ArrayList<Integer> neighbours = this.getNeighbourIdsToPolygon(currentPolygonId);
                        for (Integer neighbour : neighbours) {
                            if (neighbour == tabooPolygon) continue;
                            Line2D sharedEdge = null;
                            int[] polygon1 = this.getPolygon(currentPolygonId);
                            int[] polygon2 = this.getPolygon(neighbour);
                            for (int i = 0; i < polygon1.length; ++i) {
                                int v1 = polygon1[i];
                                int v2 = polygon1[i == polygon1.length - 1 ? 0 : i + 1];
                                boolean containsV1 = false;
                                boolean containsV2 = false;
                                for (int j = 0; j < polygon2.length; ++j) {
                                    if (polygon2[j] == v1) {
                                        containsV1 = true;
                                    }
                                    if (polygon2[j] != v2) continue;
                                    containsV2 = true;
                                }
                                if (!containsV1 || !containsV2) continue;
                                double[] vertex1 = this.getVertex(v1);
                                double[] vertex2 = this.getVertex(v2);
                                sharedEdge = new Line2D(vertex1[0], vertex1[1], vertex2[0], vertex2[1]);
                            }
                            if (sharedEdge == null) {
                                this.log.severe("Shared edge between polygon " + currentPolygonId + " and " + neighbour + " was not found!");
                            }
                            if (linkAsLine2D.getIntersection(sharedEdge) == null) continue;
                            this.log.fine("Crossed a line into polygon " + neighbour);
                            tabooPolygon = currentPolygonId;
                            newPolygon = neighbour;
                            break;
                        }
                        currentPolygonId = newPolygon;
                    }
                    addThisEdge = currentPolygonId < 0;
                } else {
                    if (forceAdd) {
                        addThisEdge = true;
                    }
                    if (forceIgnore) {
                        addThisEdge = false;
                    }
                }
                if (addThisEdge) {
                    this.log.fine("This edge is off-mesh: " + uId.getStringId() + " -> " + target.getId().getStringId());
                    OffMeshPoint op1 = (OffMeshPoint)offPoints.get(uId);
                    OffMeshPoint op2 = (OffMeshPoint)offPoints.get(target.getId());
                    OffMeshEdge oe = new OffMeshEdge(op1, op2, link);
                    op1.getOutgoingEdges().add(oe);
                    op2.getIncomingEdges().add(oe);
                    continue;
                }
                this.log.finer("This edge is not off-mesh.");
            }
        }
        this.offMeshPoints = new ArrayList();
        int offCount = 0;
        for (OffMeshPoint op : offPoints.values()) {
            if (op.getOutgoingEdges().isEmpty() && op.getIncomingEdges().isEmpty()) continue;
            this.offMeshPoints.add(op);
            ++offCount;
        }
        this.log.warning("We found " + offCount + " offMeshPoints from total of " + offPoints.size() + " NavPoints.");
        this.polysToOffMeshPoints = new ArrayList();
        boolean bl = false;
        while (var4_10 < this.polys.size()) {
            this.polysToOffMeshPoints.add(new ArrayList());
            ++var4_10;
        }
        for (OffMeshPoint op : this.offMeshPoints) {
            int pId = op.getPId();
            if (pId < 0) continue;
            this.polysToOffMeshPoints.get(pId).add(op);
        }
        this.log.info("Off-mesh connections done.");
    }

    protected void saveNavMeshCore(String mapName) {
        String coreFileName = NavMeshConstants.processedMeshDir + "\\" + mapName + ".navmesh.processed";
        File coreFile = new File(coreFileName);
        this.log.info("Writing NavMesh core to a file: " + coreFile.getAbsolutePath());
        if (coreFile.exists()) {
            this.log.warning("NavMesh core file exist, rewriting: " + coreFile.getAbsolutePath());
            coreFile.delete();
        }
        coreFile.getParentFile().mkdirs();
        try {
            NavMeshCore core = new NavMeshCore();
            core.biggestLeafInTree = this.biggestLeafInTree;
            core.bspTree = this.bspTree;
            core.polys = this.polys;
            core.verts = this.verts;
            core.vertsToPolys = this.vertsToPolys;
            core.offMeshPoints = this.offMeshPoints;
            core.polysToOffMeshPoints = this.polysToOffMeshPoints;
            core.safeVertex = this.safeVertex;
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(coreFile));
            out.writeObject(core);
            this.log.warning("NavMesh core binary file saved at: " + coreFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process((String)"Failed to write/serialize NavMesh core file to disk.", (Throwable)e));
        }
    }

    private boolean polygonContainsPoint(Integer pId, math.geom2d.Point2D point2D) {
        boolean result = true;
        double rightSide = 0.0;
        int[] polygon = this.getPolygon(pId);
        for (int i = 0; i < polygon.length; ++i) {
            double[] v1 = this.getVertex(polygon[i]);
            double[] v2 = i < polygon.length - 1 ? this.getVertex(polygon[i + 1]) : this.getVertex(polygon[0]);
            math.geom2d.Point2D p1 = new math.geom2d.Point2D(v1[0], v1[1]);
            math.geom2d.Point2D p2 = new math.geom2d.Point2D(v2[0], v2[1]);
            StraightLine2D line = new StraightLine2D((Point2D)p1, (Point2D)p2);
            double dist = line.getSignedDistance((Point2D)point2D);
            if (rightSide == 0.0) {
                rightSide = Math.signum(dist);
                continue;
            }
            if (!(rightSide * dist < 0.0)) continue;
            result = false;
            break;
        }
        return result;
    }

    public IPathFuture<ILocated> computePath(ILocated from, ILocated to) {
        return new PrecomputedPathFuture((Object)from, (Object)to, this.getPath(from, to));
    }

    public double getDistance(ILocated from, ILocated to) {
        IPathFuture<ILocated> path = this.computePath(from, to);
        if (path.isDone()) {
            List list = path.get();
            if (list.size() == 0) {
                return Double.POSITIVE_INFINITY;
            }
            ILocated location = (ILocated)list.get(0);
            double result = 0.0;
            for (int i = 1; i < list.size(); ++i) {
                ILocated next = (ILocated)list.get(i);
                result += location.getLocation().getDistance(next.getLocation());
                location = next;
            }
            return result;
        }
        return Double.POSITIVE_INFINITY;
    }

    public List<INavMeshAtom> getPolygonPath(INavMeshAtom fromAtom, INavMeshAtom toAtom) {
        ArrayList<AStarNode> pickable = new ArrayList<AStarNode>();
        ArrayList<AStarNode> expanded = new ArrayList<AStarNode>();
        AStarNode firstNode = new AStarNode(null, fromAtom, this, fromAtom, toAtom);
        pickable.add(firstNode);
        AStarNode targetNode = null;
        if (fromAtom.equals(toAtom)) {
            targetNode = firstNode;
        }
        while (targetNode == null) {
            if (pickable.isEmpty()) {
                return null;
            }
            AStarNode best = (AStarNode)pickable.get(0);
            for (AStarNode node : pickable) {
                if (!(node.getEstimatedTotalDistance() < best.getEstimatedTotalDistance())) continue;
                best = node;
            }
            List<INavMeshAtom> neighbours = best.getAtom().getNeighbours(this);
            for (INavMeshAtom atom : neighbours) {
                boolean add = true;
                for (AStarNode expNode : expanded) {
                    if (!expNode.getAtom().equals(atom)) continue;
                    add = false;
                }
                if (!add) continue;
                AStarNode newNode = new AStarNode(best, atom, this, fromAtom, toAtom);
                best.getFollowers().add(newNode);
                pickable.add(newNode);
                if (!atom.equals(toAtom)) continue;
                targetNode = newNode;
            }
            pickable.remove(best);
            expanded.add(best);
        }
        ArrayList<INavMeshAtom> path = new ArrayList<INavMeshAtom>();
        for (AStarNode node = targetNode; node != null; node = node.getFrom()) {
            path.add(node.getAtom());
        }
        Collections.reverse(path);
        return path;
    }

    public List<INavMeshAtom> getPolygonPath(Location from, Location to) {
        INavMeshAtom fromAtom = this.getNearestAtom(from);
        INavMeshAtom toAtom = this.getNearestAtom(to);
        return this.getPolygonPath(fromAtom, toAtom);
    }

    private List<ILocated> getPolygonCentrePath(ILocated from, ILocated to, List<INavMeshAtom> polygonPath) {
        ArrayList<ILocated> path = new ArrayList<ILocated>();
        path.add(from);
        Object lastAtom = null;
        for (INavMeshAtom atom : polygonPath) {
            if (atom.getClass() == OffMeshPoint.class) {
                NavPoint np = (NavPoint)this.worldView.get((WorldObjectId)((OffMeshPoint)atom).getNavPointId());
                path.add(np);
            } else {
                NavMeshPolygon polygon = (NavMeshPolygon)atom;
                if (lastAtom == null || lastAtom.getClass() == OffMeshPoint.class) {
                    boolean inside;
                    OffMeshPoint op = (OffMeshPoint)lastAtom;
                    if (lastAtom == null) {
                        inside = this.polygonContainsPoint(polygon.getPolygonId(), new math.geom2d.Point2D(from.getLocation().x, from.getLocation().y));
                    } else {
                        inside = false;
                        List offPs = this.polysToOffMeshPoints.get(polygon.getPolygonId());
                        for (OffMeshPoint op2 : offPs) {
                            if (!op2.equals(op)) continue;
                            inside = true;
                        }
                    }
                    if (!inside) {
                        path.add((ILocated)this.getLocation(atom));
                    }
                } else {
                    NavMeshPolygon polygon2 = (NavMeshPolygon)lastAtom;
                    int[] p1 = this.getPolygon(polygon.getPolygonId());
                    int[] p2 = this.getPolygon(polygon2.getPolygonId());
                    int v1 = -1;
                    int v2 = -1;
                    block2: for (int i = 0; i < p1.length; ++i) {
                        for (int j = 0; j < p2.length; ++j) {
                            if (p1[i] != p2[j]) continue;
                            if (v1 == -1) {
                                v1 = p1[i];
                                continue;
                            }
                            if (p1[i] == v1) break block2;
                            v2 = p1[i];
                            break block2;
                        }
                    }
                    double[] vv1 = this.getVertex(v1);
                    double[] vv2 = this.getVertex(v2);
                    path.add((ILocated)new Location((vv1[0] + vv2[0]) / 2.0, (vv1[1] + vv2[1]) / 2.0, (vv1[2] + vv2[2]) / 2.0 + NavMeshConstants.liftPolygonLocation));
                }
            }
            lastAtom = atom;
        }
        path.add(to);
        return path;
    }

    private List<ILocated> getFunneledPath(ILocated from, ILocated to, List<INavMeshAtom> polygonPath) {
        ArrayList<ILocated> path = new ArrayList<ILocated>();
        path.add(from);
        INavMeshAtom lastAtom = null;
        INavMeshAtom atom = null;
        int index = -1;
        while (index < polygonPath.size() - 1) {
            lastAtom = ++index > 0 ? polygonPath.get(index - 1) : null;
            atom = polygonPath.get(index);
            if (atom.getClass() == OffMeshPoint.class) {
                NavPoint np = (NavPoint)this.worldView.get((WorldObjectId)((OffMeshPoint)atom).getNavPointId());
                path.add(np);
                continue;
            }
            NavMeshPolygon polygon = (NavMeshPolygon)atom;
            if (lastAtom == null || lastAtom.getClass() == OffMeshPoint.class) {
                boolean inside;
                OffMeshPoint op = (OffMeshPoint)lastAtom;
                if (lastAtom == null) {
                    inside = this.polygonContainsPoint(polygon.getPolygonId(), new math.geom2d.Point2D(from.getLocation().x, from.getLocation().y));
                } else {
                    inside = false;
                    List offPs = this.polysToOffMeshPoints.get(polygon.getPolygonId());
                    for (OffMeshPoint op2 : offPs) {
                        if (!op2.equals(op)) continue;
                        inside = true;
                    }
                }
                if (inside) continue;
                path.add((ILocated)this.getLocation(atom));
                continue;
            }
            ILocated start = (ILocated)path.get(path.size() - 1);
            NavMeshPolygon polygon2 = (NavMeshPolygon)lastAtom;
            int[] p1 = this.getPolygon(polygon.getPolygonId());
            int[] p2 = this.getPolygon(polygon2.getPolygonId());
            int v1 = -1;
            int v2 = -1;
            block2: for (int i = 0; i < p1.length; ++i) {
                for (int j = 0; j < p2.length; ++j) {
                    if (p1[i] != p2[j]) continue;
                    if (v1 == -1) {
                        v1 = p1[i];
                        continue;
                    }
                    if (p1[i] == v1) break block2;
                    v2 = p1[i];
                    break block2;
                }
            }
            double[] vv1 = this.getVertex(v1);
            double[] vv2 = this.getVertex(v2);
            Line2D gateway = new Line2D(vv1[0], vv1[1], vv2[0], vv2[1]);
            if (start.getLocation().x == vv2[0] && start.getLocation().y == vv2[1] || start.getLocation().x == vv1[0] && start.getLocation().y == vv1[1]) {
                this.log.fine("We are already in the next polygon. No comparation, let's just continue.");
                continue;
            }
            double dist = gateway.getSignedDistance(start.getLocation().x, start.getLocation().y);
            Line2D leftMantinel = new Line2D(start.getLocation().x, start.getLocation().y, vv2[0], vv2[1]);
            Line2D rightMantinel = new Line2D(start.getLocation().x, start.getLocation().y, vv1[0], vv1[1]);
            if (dist < 0.0) {
                Line2D swap = leftMantinel;
                leftMantinel = rightMantinel;
                rightMantinel = swap;
                vv1 = this.getVertex(v2);
                vv2 = this.getVertex(v1);
                gateway = new Line2D(vv1[0], vv1[1], vv2[0], vv2[1]);
            }
            int leftMantinelIndex = index;
            double leftMantinelZ = vv2[2];
            Location leftMantinelTarget = this.safeVertex.get(v2) != false ? new Location(vv2[0], vv2[1], vv2[2] + NavMeshConstants.liftPolygonLocation) : (gateway.getLength() <= 2.0 * NavMeshConstants.agentRadius ? new Location((vv2[0] + vv1[0]) / 2.0, (vv2[1] + vv1[1]) / 2.0, (vv2[2] + vv1[2]) / 2.0 + NavMeshConstants.liftPolygonLocation) : new Location(vv2[0] + (vv1[0] - vv2[0]) / gateway.getLength() * NavMeshConstants.agentRadius, vv2[1] + (vv1[1] - vv2[1]) / gateway.getLength() * NavMeshConstants.agentRadius, vv2[2] + (vv1[2] - vv2[2]) / gateway.getLength() * NavMeshConstants.agentRadius + NavMeshConstants.liftPolygonLocation));
            int rightMantinelIndex = index;
            double rightMantinelZ = vv1[2];
            Location rightMantinelTarget = this.safeVertex.get(v1) != false ? new Location(vv1[0], vv1[1], vv1[2] + NavMeshConstants.liftPolygonLocation) : (gateway.getLength() <= 2.0 * NavMeshConstants.agentRadius ? new Location((vv2[0] + vv1[0]) / 2.0, (vv2[1] + vv1[1]) / 2.0, (vv2[2] + vv1[2]) / 2.0 + NavMeshConstants.liftPolygonLocation) : new Location(vv1[0] + (vv2[0] - vv1[0]) / gateway.getLength() * NavMeshConstants.agentRadius, vv1[1] + (vv2[1] - vv1[1]) / gateway.getLength() * NavMeshConstants.agentRadius, vv1[2] + (vv2[2] - vv1[2]) / gateway.getLength() * NavMeshConstants.agentRadius + NavMeshConstants.liftPolygonLocation));
            boolean targetAdded = false;
            boolean outOfMantinels = false;
            boolean endOfPolygonPathReached = false;
            while (!targetAdded && !outOfMantinels) {
                lastAtom = polygonPath.get(++index - 1);
                if (index < polygonPath.size()) {
                    atom = polygonPath.get(index);
                } else {
                    endOfPolygonPathReached = true;
                }
                polygon2 = (NavMeshPolygon)lastAtom;
                if (endOfPolygonPathReached || atom.getClass() == OffMeshPoint.class) {
                    NavPoint np = null;
                    if (!endOfPolygonPathReached) {
                        np = (NavPoint)this.worldView.get((WorldObjectId)((OffMeshPoint)atom).getNavPointId());
                    }
                    Object target = endOfPolygonPathReached ? to : np;
                    Line2D virtualGateway1 = new Line2D(target.getLocation().x, target.getLocation().y, leftMantinel.p2.x, leftMantinel.p2.y);
                    dist = virtualGateway1.getSignedDistance(start.getLocation().x, start.getLocation().y);
                    if (dist < 0.0) {
                        path.add((ILocated)leftMantinelTarget);
                        outOfMantinels = true;
                        index = leftMantinelIndex;
                        continue;
                    }
                    Line2D virtualGateway2 = new Line2D(rightMantinel.p2.x, rightMantinel.p2.y, target.getLocation().x, target.getLocation().y);
                    dist = virtualGateway2.getSignedDistance(start.getLocation().x, start.getLocation().y);
                    if (dist < 0.0) {
                        path.add((ILocated)rightMantinelTarget);
                        outOfMantinels = true;
                        index = rightMantinelIndex;
                        continue;
                    }
                    if (!endOfPolygonPathReached) {
                        path.add(np);
                    }
                    targetAdded = true;
                    continue;
                }
                polygon = (NavMeshPolygon)atom;
                math.geom2d.Point2D middleOfOldGateway = new math.geom2d.Point2D((gateway.p1.x + gateway.p2.x) / 2.0, (gateway.p1.y + gateway.p2.y) / 2.0);
                p1 = this.getPolygon(polygon.getPolygonId());
                p2 = this.getPolygon(polygon2.getPolygonId());
                v1 = -1;
                v2 = -1;
                block5: for (int i = 0; i < p1.length; ++i) {
                    for (int j = 0; j < p2.length; ++j) {
                        if (p1[i] != p2[j]) continue;
                        if (v1 == -1) {
                            v1 = p1[i];
                            continue;
                        }
                        if (p1[i] == v1) break block5;
                        v2 = p1[i];
                        break block5;
                    }
                }
                if ((dist = (gateway = new Line2D((vv1 = this.getVertex(v1))[0], vv1[1], (vv2 = this.getVertex(v2))[0], vv2[1])).getSignedDistance((Point2D)middleOfOldGateway)) < 0.0) {
                    vv1 = this.getVertex(v2);
                    vv2 = this.getVertex(v1);
                    gateway = new Line2D(vv1[0], vv1[1], vv2[0], vv2[1]);
                }
                if ((dist = leftMantinel.getSignedDistance((Point2D)gateway.p2)) < 0.0) {
                    dist = rightMantinel.getSignedDistance((Point2D)gateway.p2);
                    if (dist > 0.0) {
                        leftMantinel = new Line2D(leftMantinel.p1, gateway.p2);
                        leftMantinelIndex = index;
                        leftMantinelZ = vv2[2];
                        leftMantinelTarget = this.safeVertex.get(v2).booleanValue() ? new Location(vv2[0], vv2[1], vv2[2] + NavMeshConstants.liftPolygonLocation) : (gateway.getLength() <= 2.0 * NavMeshConstants.agentRadius ? new Location((vv2[0] + vv1[0]) / 2.0, (vv2[1] + vv1[1]) / 2.0, (vv2[2] + vv1[2]) / 2.0 + NavMeshConstants.liftPolygonLocation) : new Location(vv2[0] + (vv1[0] - vv2[0]) / gateway.getLength() * NavMeshConstants.agentRadius, vv2[1] + (vv1[1] - vv2[1]) / gateway.getLength() * NavMeshConstants.agentRadius, vv2[2] + (vv1[2] - vv2[2]) / gateway.getLength() * NavMeshConstants.agentRadius + NavMeshConstants.liftPolygonLocation));
                    } else {
                        path.add((ILocated)rightMantinelTarget);
                        outOfMantinels = true;
                        index = rightMantinelIndex;
                    }
                }
                if (!((dist = rightMantinel.getSignedDistance((Point2D)gateway.p1)) > 0.0)) continue;
                dist = leftMantinel.getSignedDistance((Point2D)gateway.p1);
                if (dist < 0.0) {
                    rightMantinel = new Line2D(rightMantinel.p1, gateway.p1);
                    rightMantinelIndex = index;
                    rightMantinelZ = vv1[2];
                    if (this.safeVertex.get(v1).booleanValue()) {
                        rightMantinelTarget = new Location(vv1[0], vv1[1], vv1[2] + NavMeshConstants.liftPolygonLocation);
                        continue;
                    }
                    if (gateway.getLength() <= 2.0 * NavMeshConstants.agentRadius) {
                        rightMantinelTarget = new Location((vv2[0] + vv1[0]) / 2.0, (vv2[1] + vv1[1]) / 2.0, (vv2[2] + vv1[2]) / 2.0 + NavMeshConstants.liftPolygonLocation);
                        continue;
                    }
                    rightMantinelTarget = new Location(vv1[0] + (vv2[0] - vv1[0]) / gateway.getLength() * NavMeshConstants.agentRadius, vv1[1] + (vv2[1] - vv1[1]) / gateway.getLength() * NavMeshConstants.agentRadius, vv1[2] + (vv2[2] - vv1[2]) / gateway.getLength() * NavMeshConstants.agentRadius + NavMeshConstants.liftPolygonLocation);
                    continue;
                }
                path.add((ILocated)leftMantinelTarget);
                outOfMantinels = true;
                index = leftMantinelIndex;
            }
        }
        path.add(to);
        return path;
    }

    public List<ILocated> getPath(ILocated from, ILocated to) {
        List<INavMeshAtom> polygonPath = null;
        if (this.nps == null) {
            this.initNavPoints();
        }
        if (this.isFwMapAvailable && this.nps != null) {
            List<NavPoint> path;
            NavPoint fromNp = (NavPoint)DistanceUtils.getNearest(this.nps.values(), (ILocated)from);
            NavPoint toNp = (NavPoint)DistanceUtils.getNearest(this.nps.values(), (ILocated)to);
            if (this.hasTeleports && (path = this.fwMap.getPath(fromNp, toNp)) != null) {
                INavMeshAtom atomFrom = this.getNearestAtom(from.getLocation());
                boolean skip = false;
                for (NavPoint np : path) {
                    if (skip) {
                        atomFrom = this.getNearestOffmeshPoint(np.getLocation());
                        skip = false;
                        continue;
                    }
                    if (!np.isTeleporter()) continue;
                    INavMeshAtom atomTo = this.getNearestOffmeshPoint(np.getLocation());
                    List<INavMeshAtom> pathPart = this.getPolygonPath(atomFrom, atomTo);
                    if (pathPart == null) {
                        polygonPath = null;
                        break;
                    }
                    if (polygonPath == null) {
                        polygonPath = pathPart;
                    } else {
                        polygonPath.addAll(pathPart);
                    }
                    skip = true;
                }
                if (polygonPath != null) {
                    INavMeshAtom atomTo = this.getNearestAtom(to.getLocation());
                    List<INavMeshAtom> pathPart = this.getPolygonPath(atomFrom, atomTo);
                    if (pathPart != null) {
                        polygonPath.addAll(pathPart);
                    } else {
                        polygonPath = null;
                    }
                }
            }
        }
        if (polygonPath == null) {
            polygonPath = this.getPolygonPath(from.getLocation(), to.getLocation());
        }
        if (polygonPath == null) {
            return null;
        }
        List<ILocated> path = this.getFunneledPath(from, to, polygonPath);
        return path;
    }

    private INavMeshAtom getNearestAtom(Location location) {
        return this.getNearestAtom(location, true);
    }

    public NavMeshPolygon getNearestPolygon(Location location) {
        return (NavMeshPolygon)this.getNearestAtom(location, false);
    }

    private INavMeshAtom getNearestAtom(Location location, boolean includeOffMeshPoints) {
        int pId = this.getPolygonId(location);
        if (pId >= 0) {
            return new NavMeshPolygon(pId);
        }
        INavMeshAtom nearest = null;
        if (includeOffMeshPoints) {
            nearest = this.getNearestOffmeshPoint(location);
        }
        double minDist = Double.MAX_VALUE;
        if (nearest == null) {
            for (int i = 0; i < this.polys.size(); ++i) {
                NavMeshPolygon p = new NavMeshPolygon(i);
                Location pl = this.getLocation(p);
                double dist = location.getDistance(pl);
                if (!(dist < minDist)) continue;
                nearest = p;
                minDist = dist;
            }
        }
        return nearest;
    }

    protected double getDistance(INavMeshAtom atom1, INavMeshAtom atom2) {
        if (atom1.equals(atom2)) {
            return 0.0;
        }
        Location l1 = this.getLocation(atom1);
        Location l2 = this.getLocation(atom2);
        return l1.getDistance(l2);
    }

    private Location getLocation(INavMeshAtom atom1) {
        if (atom1.getClass() == OffMeshPoint.class) {
            return this.getLocation((OffMeshPoint)atom1);
        }
        if (atom1.getClass() == NavMeshPolygon.class) {
            return this.getLocation((NavMeshPolygon)atom1);
        }
        throw new UnsupportedOperationException("Not implemented. Not now. Not ever.");
    }

    private Location getLocation(OffMeshPoint op) {
        NavPoint np = (NavPoint)this.worldView.get((WorldObjectId)op.getNavPointId());
        return np.getLocation();
    }

    private Location getLocation(NavMeshPolygon p) {
        int[] polygon = this.getPolygon(p.getPolygonId());
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (int i = 0; i < polygon.length; ++i) {
            double[] v = this.getVertex(polygon[i]);
            sumX += v[0];
            sumY += v[1];
            sumZ += v[2];
        }
        return new Location(sumX / (double)polygon.length, sumY / (double)polygon.length, sumZ / (double)polygon.length + NavMeshConstants.liftPolygonLocation);
    }

    public double getDistanceFromEdge(Location location, Vector2d vector, double rayLength) {
        if (rayLength <= 0.0) {
            return 0.0;
        }
        vector.normalize();
        vector.x *= rayLength;
        vector.y *= rayLength;
        Location end = new Location(location.x + vector.x, location.y + vector.y);
        Line2D ray = new Line2D(location.x, location.y, end.x, end.y);
        int pId = this.getPolygonId(location);
        if (pId < 0) {
            return 0.0;
        }
        int currentPolygonId = pId;
        int lastPolygonId = -1;
        int nextPolygonId = -1;
        math.geom2d.Point2D cross = null;
        int v1 = -1;
        int v2 = -1;
        int[] polygon = this.getPolygon(currentPolygonId);
        for (int i = 0; i < polygon.length; ++i) {
            double[] vertex2;
            v1 = polygon[i];
            v2 = polygon[i == polygon.length - 1 ? 0 : i + 1];
            double[] vertex1 = this.getVertex(v1);
            Line2D edge = new Line2D(vertex1[0], vertex1[1], (vertex2 = this.getVertex(v2))[0], vertex2[1]);
            cross = ray.getIntersection((LinearShape2D)edge);
            if (cross == null) continue;
            if (cross.x <= Math.max(edge.p1.x, edge.p2.x) && cross.x >= Math.min(edge.p1.x, edge.p2.x) && cross.x <= Math.max(ray.p1.x, ray.p2.x) && cross.x >= Math.min(ray.p1.x, ray.p2.x)) break;
            cross = null;
        }
        double distanceToPolygonEdge = ray.p1.getDistance(cross);
        if (cross == null || distanceToPolygonEdge >= rayLength) {
            return 0.0;
        }
        nextPolygonId = this.getNeighbourPolygon(currentPolygonId, v1, v2);
        if (nextPolygonId == -1) {
            return distanceToPolygonEdge;
        }
        vector = (Vector2d)vector.clone();
        vector.normalize();
        Location crossLocation = new Location(cross.x + vector.x, cross.y + vector.y, location.z);
        return distanceToPolygonEdge + this.getDistanceFromEdge(crossLocation, vector, rayLength - distanceToPolygonEdge);
    }

    public double getDistanceFromEdge(Location location, Vector2d vector) {
        return this.getDistanceFromEdge(location, vector, 10000.0);
    }

    public int getNeighbourPolygon(int currentPolygonId, int v1, int v2) {
        ArrayList<Integer> neighbours = this.getNeighbourIdsToPolygon(currentPolygonId);
        for (Integer neighbour : neighbours) {
            int[] polygon2 = this.getPolygon(neighbour);
            boolean containsV1 = false;
            boolean containsV2 = false;
            for (int j = 0; j < polygon2.length; ++j) {
                if (polygon2[j] == v1) {
                    containsV1 = true;
                }
                if (polygon2[j] != v2) continue;
                containsV2 = true;
            }
            if (!containsV1 || !containsV2) continue;
            return neighbour;
        }
        return -1;
    }

    public NavMeshBSPNode getBiggestLeafInTree() {
        return this.biggestLeafInTree;
    }

    protected void setFwMap(FloydWarshallMap fwMap) {
        this.fwMap = fwMap;
        this.isFwMapAvailable = fwMap != null;
    }

    private void initNavPoints() {
        this.nps = this.worldView.getAll(NavPoint.class);
        if (this.nps != null) {
            for (NavPoint np : this.nps.values()) {
                if (!np.isTeleporter()) continue;
                this.hasTeleports = true;
                break;
            }
        }
    }

    private INavMeshAtom getNearestOffmeshPoint(Location location) {
        OffMeshPoint nearest = null;
        double minDist = Double.MAX_VALUE;
        for (OffMeshPoint op : this.offMeshPoints) {
            double dist = location.getDistance(op.getLocation());
            if (!(dist < minDist)) continue;
            nearest = op;
            minDist = dist;
        }
        return nearest;
    }

    protected void clear() {
        this.log.warning("NavMesh has been cleared...");
        this.verts = new ArrayList();
        this.polys = new ArrayList();
        this.vertsToPolys = null;
        this.safeVertex = null;
        this.bspTree = null;
        this.biggestLeafInTree = null;
        this.offMeshPoints = null;
        this.polysToOffMeshPoints = null;
        this.loaded = false;
        this.loadedForMap = null;
    }
}

