/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.test;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.params.IRemoteAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.observer.IUT2004Observer;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ObserverRunner;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.After;
import org.junit.Before;

public class UT2004Test {
    public static final String[] CTF_MAPS = new String[]{"CTF-1on1-Joust", "CTF-AbsoluteZero", "CTF-Avaris", "CTF-BridgeOfFate", "CTF-Chrome", "CTF-Citadel", "CTF-Colossus", "CTF-December", "CTF-DE-ElecFields", "CTF-DoubleDammage", "CTF-Face3", "CTF-FaceClassic", "CTF-Geothermal", "CTF-Grassyknoll", "CTF-Grendelkeep", "CTF-January", "CTF-Lostfaith", "CTF-Magma", "CTF-Maul", "CTF-MoonDragon", "CTF-Orbital2", "CTF-Smote", "CTF-TwinTombs"};
    public static String[] DM_MAPS = new String[]{"DM-1on1-Albatross", "DM-1on1-Crash", "DM-1on1-Desolation", "DM-1on1-Idoma", "DM-1on1-Irondust", "DM-1on1-Mixer", "DM-1on1-Roughinery", "DM-1on1-Serpen-tine", "DM-1on1-Spirit", "DM-1on1-Squader", "DM-1on1-Trite", "DM-Antalus", "DM-Asbestos", "DM-Compressed", "DM-Corrugation", "DM-Curse4", "DM-Deck17", "DM-DE-Grendelkeep", "DM-DE-Ironic", "DM-DE-Osiris2", "DM-DesertIsle", "DM-Flux2", "DM-Gael", "DM-Gestalt", "DM-Goliath", "DM-HyperBlast2", "DM-Icetomb", "DM-Inferno", "DM-Injector", "DM-Insidious", "DM-IronDeity", "DM-Junkyard", "DM-Leviathan", "DM-Metallurgy", "DM-Morpheus3", "DM-Oceanic", "DM-Phobos2", "DM-Plunge", "DM-Rankin", "DM-Rrajigar", "DM-Rustatorium", "DM-Sulphur", "DM-TokaraForest", "DM-TrainingDay"};
    protected IAgentId testId = new AgentId("Test");
    protected LogCategory log = new LogCategory("UT2004Test");
    protected UCCWrapper ucc = null;
    protected boolean useInternalUcc = true;
    protected String unrealHome = "C:\\Games\\UT";

    public UT2004Test() {
        this.log.addHandler((ILogPublisher)new LogPublisher.ConsolePublisher(this.testId));
    }

    public void startUCC(UCCWrapperConf uccConf) throws UCCStartException {
        if (this.unrealHome != null) {
            uccConf.setUnrealHome(this.unrealHome);
        }
        if (this.useInternalUcc) {
            this.ucc = new UCCWrapper(uccConf);
        }
    }

    public void endUcc() {
        if (this.useInternalUcc) {
            this.ucc.stop();
        }
    }

    @Before
    public void beforeTest() throws UCCStartException {
        this.startUCC(new UCCWrapperConf());
    }

    @After
    public void afterTest() {
        this.endUcc();
        Pogamut.getPlatform().close();
    }

    protected boolean awaitAgentUp(AbstractAgent agent) {
        System.out.println("Awaiting server UP(timeout 60s)...");
        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag)agent.getState(), IAgentStateUp.class).await(60000L, TimeUnit.MILLISECONDS);
        return state != null && state instanceof IAgentStateUp;
    }

    protected boolean awaitAgentDown(AbstractAgent agent) {
        System.out.println("Awaiting server DOWN (timeout 60s)...");
        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag)agent.getState(), IAgentStateDown.class).await(120000L, TimeUnit.MILLISECONDS);
        return state != null && state instanceof IAgentStateDown;
    }

    protected <T extends IUT2004BotController> UT2004Bot startUTBot(Class<T> controller) {
        return this.startUTBot(controller, null);
    }

    protected <T extends IUT2004BotController> UT2004Bot startUTBot(Class<T> controller, UT2004AgentParameters params) {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(controller));
        String host = Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getBotPort();
        }
        UT2004BotRunner botRunner = new UT2004BotRunner((IAgentFactory)factory, "TestBot", host, port);
        UT2004Bot bot = params == null ? (UT2004Bot)botRunner.startAgent() : (UT2004Bot)botRunner.startAgents(new IAgentParameters[]{params}).get(0);
        return bot;
    }

    protected <T extends IUT2004BotController> List<UT2004Bot> startAllUTBots(Class<T> controller, UT2004BotParameters ... params) {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(controller));
        String host = Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey());
        if (host == null) {
            host = "localhost";
        }
        if (port == 0) {
            port = 3000;
        }
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getBotPort();
        }
        UT2004BotRunner botRunner = new UT2004BotRunner((IAgentFactory)factory, "TestBot", host, port);
        botRunner.setPausing(true);
        return botRunner.startAgents(params);
    }

    protected IUT2004Server startUTServer(IAgentFactory<IUT2004Server, IRemoteAgentParameters> factory) {
        String host = Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_SERVER_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_SERVER_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getControlPort();
        }
        UT2004ServerRunner runner = new UT2004ServerRunner(factory, "TEST server", host, port){

            protected void preStartHook(IAgent agent) throws PogamutException {
                super.preStartHook(agent);
                agent.getLogger().setLevel(Level.ALL);
            }
        };
        return runner.startAgent();
    }

    protected IUT2004Observer startUTObserver(IAgentFactory<IUT2004Observer, IRemoteAgentParameters> factory) {
        String host = Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_SERVER_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_SERVER_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getObserverPort();
        }
        UT2004ObserverRunner runner = new UT2004ObserverRunner(factory, "TEST observer", host, port){

            protected void preStartHook(IAgent agent) throws PogamutException {
                super.preStartHook(agent);
                agent.getLogger().setLevel(Level.ALL);
            }
        };
        return runner.startAgent();
    }
}

