/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.CollisionDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.JumpBoundaries;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.JumpModule;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WallCollision;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Tuple3d;

public class NavMeshRunner
implements IUT2004PathRunner {
    private UT2004Bot bot;
    private AgentInfo memory;
    private AdvancedLocomotion body;
    private Logger log;
    private JumpBoundaries jumpBoundaries;
    IWorldEventListener<WallCollision> myCollisionsListener = new IWorldEventListener<WallCollision>(){

        public void notify(WallCollision event) {
            NavMeshRunner.this.lastCollidingEvent = event;
        }
    };
    private JumpModule jumpModule;
    private CollisionDetector collisionDetector;
    private boolean inCollision = false;
    private int runnerStep = 0;
    private int jumpStep = 0;
    private int collisionNum = 0;
    private Location collisionSpot = null;
    private double distance;
    private double distance2D;
    private double distanceZ;
    private double velocity;
    private double velocityZ;
    private boolean jumpRequired;
    private Location runningFrom;
    private Location firstLocation;
    private Location secondLocation;
    private ILocated focus;
    private NavPointNeighbourLink link;
    private boolean reachable;
    private double angle;
    private boolean accelerating = false;
    protected WallCollision lastCollidingEvent = null;
    private static final double WALL_COLLISION_THRESHOLD = 1.0;
    private static final int IDEAL_JUMP_RESERVE = 80;
    private double lastVelocityZ = 0.02;

    @Override
    public void reset() {
        this.runnerStep = 0;
        this.jumpStep = 0;
        this.collisionNum = 0;
        this.collisionSpot = null;
        this.lastCollidingEvent = null;
        this.distance = 0.0;
        this.distance2D = 0.0;
        this.distanceZ = 0.0;
        this.velocity = 0.0;
        this.velocityZ = 0.0;
        this.angle = 0.0;
        this.jumpRequired = false;
        this.jumpBoundaries = null;
        this.accelerating = false;
    }

    @Override
    public boolean runToLocation(Location runningFrom, Location firstLocation, Location secondLocation, ILocated focus, NavPointNeighbourLink navPointsLink, boolean reachable) {
        ++this.runnerStep;
        this.runningFrom = runningFrom;
        this.firstLocation = firstLocation;
        this.secondLocation = secondLocation;
        this.focus = focus;
        this.link = navPointsLink;
        this.reachable = reachable;
        this.distance = this.memory.getLocation().getDistance(firstLocation);
        this.distance2D = this.memory.getLocation().getDistance2D(firstLocation);
        this.distanceZ = firstLocation.getDistanceZ(this.memory.getLocation());
        double newVelocity = this.memory.getVelocity().size();
        this.accelerating = this.isAccelerating(newVelocity, this.velocity);
        this.velocity = newVelocity;
        this.velocityZ = this.memory.getVelocity().z;
        boolean bl = this.jumpRequired = !reachable || this.jumpModule.needsJump(this.link);
        if (this.jumpBoundaries == null || this.jumpBoundaries.getLink() != this.link) {
            this.jumpBoundaries = this.jumpModule.computeJumpBoundaries(this.link);
            this.debug("Computed jump boundaries. Jumpable: " + this.jumpBoundaries.isJumpable() + ", Start: " + this.jumpBoundaries.getTakeOffMin() + ", Ene: " + this.jumpBoundaries.getTakeOffMax());
        }
        Location direction = Location.sub((Location)firstLocation, (Location)this.memory.getLocation()).setZ(0.0);
        direction = direction.getNormalized();
        Location velocityDir = new Location((Tuple3d)this.memory.getVelocity().asVector3d()).setZ(0.0);
        velocityDir = velocityDir.getNormalized();
        this.angle = direction.dot(velocityDir);
        this.logDebugData(firstLocation, secondLocation, focus, reachable);
        if (this.runnerStep <= 1) {
            this.debug("FIRST STEP - start running towards new location");
            this.move((ILocated)firstLocation, (ILocated)secondLocation, focus);
        }
        if (this.collisionDetector.isColliding(this.memory.getLocation(), this.velocity, this.distance)) {
            this.inCollision = true;
            this.debug("Internal collision detector signalling collision, solving by force JUMPING!");
            return this.initJump(true);
        }
        if (this.jumpStep > 0) {
            this.debug("we're already jumping");
            return this.iterateJumpSequence();
        }
        if (this.isColliding()) {
            this.debug("sensing collision");
            return this.resolveCollision();
        }
        if (this.collisionSpot != null || this.collisionNum != 0) {
            this.debug("no collision, clearing collision data");
            this.collisionNum = 0;
            this.collisionSpot = null;
        }
        this.log.log(Level.FINER, "TRACE: RunnerStep: {0}", this.runnerStep);
        if (this.velocity < 5.0 && this.runnerStep > 5) {
            this.debug("velocity is zero and we're in the middle of running");
            if (this.link != null && (this.link.getFromNavPoint().isLiftCenter() || this.link.getFromNavPoint().isLiftExit())) {
                if (this.link.getFromNavPoint().isLiftCenter()) {
                    this.debug("we're standing on the lift center, ok");
                } else {
                    this.debug("we're standing on the lift exit, ok");
                }
            } else {
                this.debug("and we're not standing on the lift center");
                return this.initJump(true);
            }
        }
        if (this.jumpRequired) {
            this.debug("jump is required");
            return this.resolveJump();
        }
        this.debug("keeping running to the target");
        this.move((ILocated)firstLocation, (ILocated)secondLocation, focus);
        return true;
    }

    private boolean isAccelerating(double newVelocity, double oldVelocity) {
        return this.velocity > 0.0 && (this.isMaxVelocity(newVelocity) || newVelocity > oldVelocity);
    }

    private void logDebugData(Location firstLocation, Location secondLocation, ILocated focus, boolean reachable) {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.debug("NavMeshRunner!");
            this.debug("running to    = " + firstLocation + " and than to " + secondLocation + " and focusing to " + focus);
            this.debug("bot position  = " + this.memory.getLocation());
            this.debug("distance      = " + this.distance);
            this.debug("distance2D    = " + this.distance2D);
            this.debug("distanceZ     = " + this.distanceZ);
            this.debug("velocity      = " + this.velocity);
            this.debug("velocityZ     = " + this.velocityZ);
            this.debug("angle         = " + Math.acos(this.angle) * 57.29577951308232);
            this.debug("jumpRequired  = " + this.jumpRequired + (!reachable ? " NOT_REACHABLE" : "") + (this.link == null ? "" : ((this.link.getFlags() & LinkFlag.JUMP.get()) != 0 ? " JUMP_FLAG" : "") + (this.link.isForceDoubleJump() ? " DOUBLE_JUMP_FORCED" : "") + (this.link.getNeededJump() != null ? " AT[" + this.link.getNeededJump() + "]" : "")));
            this.debug("reachable     = " + reachable);
            if (this.link != null) {
                this.debug("link          = " + (Object)((Object)this.link));
            } else {
                this.debug("LINK NOT PRESENT");
            }
            this.debug("collisionNum  = " + this.collisionNum);
            this.debug("collisionSpot = " + this.collisionSpot);
            this.debug("jumpStep      = " + this.jumpStep);
            this.debug("runnerStep    = " + this.runnerStep);
        }
    }

    public NavMeshRunner(UT2004Bot bot, AgentInfo agentInfo, AdvancedLocomotion locomotion, Logger log, NavMesh navMesh) {
        NullCheck.check((Object)bot, (String)"bot");
        this.bot = bot;
        NullCheck.check((Object)((Object)agentInfo), (String)"agentInfo");
        this.memory = agentInfo;
        NullCheck.check((Object)((Object)locomotion), (String)"locomotion");
        this.body = locomotion;
        bot.getWorldView().addEventListener(WallCollision.class, this.myCollisionsListener);
        this.log = log;
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.jumpModule = new JumpModule(navMesh, this.log);
        this.collisionDetector = new CollisionDetector();
    }

    private void debug(String message) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Runner: {0}", message);
        }
    }

    private void move(ILocated firstLocation, ILocated secondLocation, ILocated focus) {
        Move move = new Move();
        if (firstLocation != null) {
            move.setFirstLocation(firstLocation.getLocation());
            if (secondLocation == null || secondLocation.equals(firstLocation)) {
                move.setSecondLocation(firstLocation.getLocation());
            } else {
                double dist = firstLocation.getLocation().getDistance(secondLocation.getLocation());
                double quantifier = 1.0 + 200.0 / dist;
                Location extendedSecondLocation = firstLocation.getLocation().interpolate(secondLocation.getLocation(), quantifier);
                move.setSecondLocation(extendedSecondLocation);
            }
        } else if (secondLocation != null) {
            move.setSecondLocation(secondLocation.getLocation());
        }
        if (focus != null) {
            if (focus instanceof Player) {
                move.setFocusTarget((UnrealId)((IWorldObject)focus).getId());
            } else {
                move.setFocusLocation(focus.getLocation());
            }
        }
        this.debug("MOVING: " + (Object)((Object)move));
        this.bot.getAct().act((CommandMessage)move);
    }

    private boolean resolveCollision() {
        if (this.collisionSpot == null || this.memory.getLocation().getDistance2D(this.collisionSpot) > 120.0) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Runner.resolveCollision(): collision");
            }
            this.collisionSpot = this.memory.getLocation();
            this.collisionNum = 1;
            this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
            return true;
        }
        if (this.collisionNum > 8) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Runner.resolveCollision(): Solving collision by FORCE JUMPING");
            }
            this.inCollision = true;
            return this.initJump(true);
        }
        ++this.collisionNum;
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        return true;
    }

    private boolean isColliding() {
        if (this.lastCollidingEvent == null) {
            return false;
        }
        this.debug("isColliding():(memory.getTime():" + this.memory.getTime() + " - (lastCollidingEvent.getSimTime() / 1000):" + this.lastCollidingEvent.getSimTime() / 1000L + " <= WALL_COLLISION_THRESHOLD:" + 1.0 + " )");
        if (this.memory.getTime() - (double)(this.lastCollidingEvent.getSimTime() / 1000L) <= 1.0) {
            this.debug("isColliding():return true;");
            return true;
        }
        return false;
    }

    private boolean resolveJump() {
        this.debug("resolveJump(): called");
        int jumpDistance2D = (int)this.distance2D;
        this.debug("resolveJump(): jumpDistance2D = " + jumpDistance2D);
        boolean jumpIndicated = false;
        boolean mustJumpIfIndicated = false;
        if (this.jumpModule.needsJump(this.link)) {
            this.debug("resolveJump(): deliberation - jumping condition present");
            jumpIndicated = true;
        }
        if (!this.jumpBoundaries.isJumpable() && (this.runnerStep > 1 && this.velocity > 389.5 && this.angle < 20.0 && jumpDistance2D < 500 || jumpDistance2D < 250)) {
            this.debug("resolveJump(): we're facing forced jump and are near - forcing jump");
            mustJumpIfIndicated = true;
        }
        this.debug("resolveJump(): jumpIndicated       = " + jumpIndicated);
        this.debug("resolveJump(): mustJumpIfIndicated = " + mustJumpIfIndicated);
        if (jumpIndicated && mustJumpIfIndicated) {
            if (this.distanceZ > 0.0) {
                this.debug("resolveJump(): we MUST jump!");
                return this.prepareJump(true);
            }
            this.debug("resolveJump(): we MUST fall down with a jump!");
            return this.prepareJump(true);
        }
        if (jumpIndicated) {
            this.debug("resolveJump(): we should jump");
            return this.prepareJump(false);
        }
        this.debug("resolveJump(): we do not need to jump, waiting to reach the right spot to jump from");
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        return true;
    }

    private boolean prepareJump(boolean jumpForced) {
        this.debug("prepareJump(): called");
        Double jumpAngleDeviation = Math.acos(this.jumpModule.getCorrectedAngle(this.angle, this.runnerStep <= 1));
        jumpForced |= this.runnerStep > 1 && this.jumpBoundaries.isPastBoundaries(this.memory.getLocation());
        Double jumpVelocity = this.jumpModule.getCorrectedVelocity(this.velocity, this.accelerating);
        boolean angleSuitable = !jumpAngleDeviation.isNaN() && jumpAngleDeviation < 0.3490658503988659;
        this.debug("prepareJump(): jumpAngleDeviation = " + jumpAngleDeviation);
        this.debug("prepareJump(): angleSuitable      = " + angleSuitable);
        if (jumpAngleDeviation > 1.0471975511965976) {
            this.debug("prepareJump(): Impossible jump angle, postponing jump..");
            this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
            return true;
        }
        if (jumpForced) {
            this.debug("prepareJump(): jump is forced, bypassing jump checks!");
        } else {
            this.debug("prepareJump(): jump is not forced, checking jump conditions");
            if (!this.jumpModule.isJumpable(this.memory.getLocation(), this.jumpBoundaries.getLandingTarget(), (double)jumpVelocity)) {
                this.debug("prepareJump(): not jumpable! Start: " + this.memory.getLocation() + " Target: " + this.jumpBoundaries.getLandingTarget() + " Velocity: " + this.velocity + " Jump Velocity: " + jumpVelocity);
                this.debug("prepareJump(): proceeding with the straight movement to gain speed");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
            if (!angleSuitable) {
                this.debug("prepareJump(): angle is not suitable for jumping (angle > 20 degrees)");
                this.debug("prepareJump(): proceeding with the straight movement to gain speed");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
            if (this.jumpBoundaries.isJumpable() && this.jumpBoundaries.getTakeOffMax().getDistance2D(this.memory.getLocation()) > 80.0) {
                boolean angleIdeal;
                boolean bl = angleIdeal = !jumpAngleDeviation.isNaN() && jumpAngleDeviation < Math.PI / 90;
                if (!angleIdeal) {
                    this.debug("prepareJump(): proceeding with the straight movement - waiting for ideal jump ANGLE");
                    this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                    return true;
                }
                if (this.velocity < 389.5) {
                    this.debug("prepareJump(): proceeding with the straight movement - waiting for ideal speed");
                    this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                    return true;
                }
            } else {
                this.debug("prepareJump(): passed ideal reserve spot, lower requirments on speed and angle");
            }
            this.debug("prepareJump(): velocity & angle is OK!");
        }
        this.debug("prepareJump(): JUMP");
        return this.initJump(jumpForced);
    }

    private boolean initJump(boolean jumpForced) {
        this.debug("initJump(): called");
        boolean doubleJump = true;
        Double jumpForce = Double.NaN;
        Double jumpVelocity = this.jumpModule.getCorrectedVelocity(this.velocity, this.accelerating);
        Double jumpAngleCos = this.jumpModule.getCorrectedAngle(this.angle, this.runnerStep <= 1);
        if (!this.jumpBoundaries.isJumpable()) {
            this.debug("initJump(): jump could not be made (distanceZ = " + this.distanceZ + " > 130)");
            if (jumpForced) {
                this.debug("initJump(): but jump is being forced!");
            } else {
                this.debug("initJump(): jump is not forced ... we will wait till the bot reach the right jumping spot");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                this.jumpStep = 0;
                return true;
            }
        }
        if (!this.jumpBoundaries.isJumpable()) {
            this.debug("Jump boundaries not present! We shouldn't be trying to JUMP!");
            jumpForce = Double.NaN;
        } else if (!this.jumpBoundaries.isInBoundaries(this.memory.getLocation())) {
            if (this.runnerStep > 1 && this.jumpBoundaries.isPastBoundaries(this.memory.getLocation())) {
                this.debug("Already passed max take-off point, forcing jump!");
                jumpForced = true;
                jumpForce = this.jumpModule.computeJump(this.memory.getLocation(), this.jumpBoundaries, jumpVelocity, jumpAngleCos);
            } else {
                this.debug("Not within jump boundaries! We should'n t JUMP");
                jumpForce = Double.NaN;
            }
        } else {
            jumpForce = this.jumpModule.computeJump(this.memory.getLocation(), this.jumpBoundaries, jumpVelocity, jumpAngleCos);
            if (jumpForce < 340.0) {
                doubleJump = false;
            }
        }
        if (jumpForced && this.inCollision) {
            this.inCollision = false;
            this.jumpStep = 1;
            this.debug("initJump(): In collision, forcing jump - MAX!");
            return this.jump(true, 0.39, 755.0);
        }
        if (jumpForce.isNaN()) {
            if (jumpForced) {
                if (!this.accelerating) {
                    this.debug("initJump(): Forcing jump but NOT accelerating, postpone!");
                    this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                    return true;
                }
                this.jumpStep = 1;
                this.debug("initJump(): Forcing jump - MAX!");
                return this.jump(true, 0.39, 755.0);
            }
            this.debug("initJump(): Jump failed to compute, continuing with move! Computed force: " + jumpForce);
            this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
            return true;
        }
        if (jumpForce < 0.0) {
            this.debug("initJump(): We don't need to jump, continuing with move! Computed force: " + jumpForce);
            if (this.jumpBoundaries.isJumpable() && this.jumpBoundaries.getTakeoffEdgeDirection() != null) {
                Location movementDirection = this.jumpBoundaries.getLandingTarget().sub(this.jumpBoundaries.getTakeOffMax()).setZ(0.0).getNormalized();
                Location meshDirection = this.jumpBoundaries.getTakeoffEdgeDirection();
                double fallAngleCos = meshDirection.setZ(0.0).getNormalized().dot(movementDirection);
                double takeOffDistance = this.jumpBoundaries.getLandingTarget().getDistance2D(this.jumpBoundaries.getTakeOffMax());
                if (Math.abs(fallAngleCos) > Math.cos(1.2566370614359172)) {
                    this.debug("initJump(): Not direct approach to fall, we should jump a little. Angle: " + Math.acos(fallAngleCos) * 57.29577951308232);
                    this.jumpBoundaries.setLandingTarget(this.jumpBoundaries.getTakeOffMax().interpolate(this.jumpBoundaries.getLandingTarget(), 80.0 / takeOffDistance).setZ(this.jumpBoundaries.getTakeOffMax().z));
                    return true;
                }
                this.debug("initJump(): Fall solved by not jumping, as angle is suitable. AngleCos: " + fallAngleCos);
                this.jumpStep = 1;
                return true;
            }
            this.debug("initJump(): Fall solved by not jumping, as angle is suitable. Boundaries not jumpable.");
            this.jumpStep = 1;
            return true;
        }
        this.jumpStep = 1;
        return this.jump(doubleJump, 0.39, jumpForce);
    }

    private boolean jump(boolean doubleJump, double delay, double force) {
        if (doubleJump) {
            this.debug("DOUBLE JUMPING (delay = " + delay + ", force = " + force + ")");
        } else {
            this.debug("JUMPING (delay = " + delay + ", force = " + force + ")");
        }
        this.body.jump(doubleJump, delay, force);
        return true;
    }

    private boolean iterateJumpSequence() {
        this.debug("iterateJumpSequence(): called");
        switch (this.jumpStep) {
            case 1: {
                if (this.velocityZ > 100.0) {
                    this.debug("iterateJumpSequence(): jumping in progress (velocityZ > 100), increasing jumpStep");
                    ++this.jumpStep;
                }
                this.debug("iterateJumpSequence(): issuing move command to the target (just to be sure)");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
        }
        ++this.jumpStep;
        if (this.velocityZ <= 0.01) {
            if (this.velocityZ > this.lastVelocityZ) {
                this.debug("iterateJumpSequence(): jump has ended");
                this.lastVelocityZ = 0.02;
            } else {
                this.lastVelocityZ = this.velocityZ;
            }
        }
        this.debug("iterateJumpSequence(): continuing movement to the target");
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        return true;
    }

    private boolean isMaxVelocity(double newVelocity) {
        return Math.abs(newVelocity - 439.5) < 5.0;
    }
}

