/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;

public class JumpBoundaries {
    private boolean jumpable;
    private Location takeOffMin;
    private Location takeOffMax;
    private Location takeoffEdgeDirection;
    private Location landingTarget;
    private Location navigTarget;
    private Location targetEdgeDirection;
    private NavPointNeighbourLink link;

    public JumpBoundaries(NavPointNeighbourLink link, Location takeOffMin, Location takeOffMax, Location takeoffEdgeDirection, Location target, Location targetEdgeDirection, Location navigTarget) {
        this.link = link;
        this.takeOffMin = takeOffMin;
        this.takeOffMax = takeOffMax;
        this.takeoffEdgeDirection = takeoffEdgeDirection;
        this.landingTarget = target;
        this.targetEdgeDirection = targetEdgeDirection;
        this.navigTarget = navigTarget;
        this.jumpable = true;
    }

    public JumpBoundaries(NavPointNeighbourLink link) {
        this.link = link;
        this.jumpable = false;
    }

    public NavPointNeighbourLink getLink() {
        return this.link;
    }

    public void setLink(NavPointNeighbourLink link) {
        this.link = link;
    }

    public boolean isJumpable() {
        return this.jumpable;
    }

    public void setJumpable(boolean jumpable) {
        this.jumpable = jumpable;
    }

    public Location getTakeOffMin() {
        return this.takeOffMin;
    }

    public void setTakeOffMin(Location takeOffMin) {
        this.takeOffMin = takeOffMin;
    }

    public Location getTakeOffMax() {
        return this.takeOffMax;
    }

    public void setTakeOffMax(Location takeOffMax) {
        this.takeOffMax = takeOffMax;
    }

    public Location getLandingTarget() {
        return this.landingTarget;
    }

    public void setLandingTarget(Location landingTarget) {
        this.landingTarget = landingTarget;
    }

    boolean isInBoundaries(Location botLocation) {
        if (!this.jumpable) {
            return false;
        }
        if (this.takeOffMin.equals(this.takeOffMax, 1.0)) {
            return botLocation.getDistance(this.takeOffMin) < 20.0;
        }
        return botLocation.getDistance(this.takeOffMax) + botLocation.getDistance(this.takeOffMin) <= 2.0 * this.takeOffMin.getDistance(this.takeOffMax);
    }

    boolean isPastBoundaries(Location botLocation) {
        if (this.jumpable) {
            return botLocation.getDistance(this.landingTarget) < this.takeOffMax.getDistance(this.landingTarget);
        }
        return false;
    }

    public boolean isJumpUp() {
        return this.jumpable && this.landingTarget.z - this.takeOffMax.z > 45.0;
    }

    public Location getTargetEdgeDirection() {
        return this.targetEdgeDirection;
    }

    public Location getTakeoffEdgeDirection() {
        return this.takeoffEdgeDirection;
    }

    public Location getNavigTarget() {
        return this.navigTarget;
    }

    boolean canLandLater(double distanceLater) {
        return this.landingTarget.getDistance2D(this.navigTarget) > distanceLater;
    }
}

